/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.PButtonPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SwingHierarchyDialog
extends JDialog {
    private static final int DEFAULT_WINDOW_HEIGHT = 600;
    private static final int DEFAULT_WINDOW_WIDTH = 550;
    protected Map myWindowMap = new HashMap();
    protected DefaultMutableTreeNode myRootNode;
    protected JTree mySwingHierarchyTree;
    protected JFrame myRootFrame;
    protected Window myCurrentlySelectedWindow;
    protected JComboBox myWindowSelectionComboBox;
    protected Component mySelectedComponent = null;
    protected BorderGlassPane myCurrentGlassPane;
    private FocusListener focusListener;

    public SwingHierarchyDialog(JFrame rootFrame) {
        this.myRootFrame = rootFrame;
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", SwingHierarchyDialog.this.focusListener);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", SwingHierarchyDialog.this.focusListener);
            }
        });
        this.setLocationByPlatform(true);
        this.setAlwaysOnTop(true);
        this.setDialogModality();
        this.setSize(550, 600);
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        this.myWindowSelectionComboBox = new JComboBox();
        this.myWindowSelectionComboBox.setPreferredSize(new Dimension(350, 25));
        this.myWindowSelectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Window newSelection = (Window)SwingHierarchyDialog.this.myWindowMap.get(SwingHierarchyDialog.this.myWindowSelectionComboBox.getSelectedItem());
                if (newSelection != null && SwingHierarchyDialog.this.myCurrentlySelectedWindow != newSelection) {
                    SwingHierarchyDialog.this.cleanCurrentGlassPane();
                    SwingHierarchyDialog.this.myCurrentlySelectedWindow = newSelection;
                    SwingHierarchyDialog.this.buildComponentTree();
                    SwingHierarchyDialog.this.repaint();
                }
            }
        });
        comboPanel.add(this.myWindowSelectionComboBox);
        JButton refreshButton = new JButton("Refresh windows");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingHierarchyDialog.this.cleanCurrentGlassPane();
                SwingHierarchyDialog.this.buildWindowList();
            }
        });
        comboPanel.add(refreshButton);
        this.add((Component)comboPanel, "North");
        JPanel treePanel = new JPanel(new BorderLayout());
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.mySwingHierarchyTree = new JTree(this.myRootNode);
        this.mySwingHierarchyTree.setRootVisible(true);
        this.mySwingHierarchyTree.setShowsRootHandles(true);
        this.mySwingHierarchyTree.setSelectionModel(selectionModel);
        this.mySwingHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SwingHierarchyDialog.this.mySwingHierarchyTree.getSelectionCount() > 0) {
                    SwingHierarchyDialog.this.myCurrentGlassPane = SwingHierarchyDialog.this.createGlassPaneIfItDoesNotExist();
                    DefaultMutableTreeNode selectedTreeNode = (DefaultMutableTreeNode)SwingHierarchyDialog.this.mySwingHierarchyTree.getLastSelectedPathComponent();
                    SwingHierarchyDialog.this.mySelectedComponent = ((SwingComponentNode)selectedTreeNode.getUserObject()).getComponent();
                    if (SwingHierarchyDialog.this.mySelectedComponent != null) {
                        SwingHierarchyDialog.this.markComponentBorder(SwingHierarchyDialog.this.mySelectedComponent);
                    }
                }
            }
        });
        final TreePopupMenu popupMenu = new TreePopupMenu(this);
        this.mySwingHierarchyTree.add(popupMenu);
        this.mySwingHierarchyTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        treePanel.setBorder(BorderFactory.createEmptyBorder(12, 26, 22, 26));
        treePanel.add((Component)new JScrollPane(this.mySwingHierarchyTree), "Center");
        this.add((Component)treePanel, "Center");
        PButtonPane buttonPanel = new PButtonPane();
        JButton closeButton = new JButton("Close");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingHierarchyDialog.this.cleanCurrentGlassPane();
                SwingHierarchyDialog.this.dispose();
            }
        };
        closeButton.addActionListener(al);
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.buildWindowList();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.focusListener = new FocusListener();
        focusManager.addPropertyChangeListener("focusOwner", this.focusListener);
        focusManager.addPropertyChangeListener("permanentFocusOwner", this.focusListener);
    }

    protected void setDialogModality() {
        try {
            Class<?> clazz = Class.forName("java.awt.Dialog$ModalExclusionType");
            Object valueOf = Enum.valueOf(clazz, "APPLICATION_EXCLUDE");
            Method m = this.getClass().getMethod("setModalExclusionType", clazz);
            m.invoke((Object)this, valueOf);
        }
        catch (RuntimeException clazz) {
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to set dialog modality. This tool may not work correctly.", "Modality error", 0);
        }
    }

    protected void markComponentBorder(Component component) {
        if (component != null) {
            this.drawBorder(component);
        }
        if (component instanceof Container) {
            int i = 0;
            while (i < ((Container)component).getComponents().length) {
                Component child = ((Container)component).getComponents()[i];
                this.markComponentBorder(child);
                ++i;
            }
        }
    }

    protected void drawBorder(Component component) {
        if (SwingUtilities.getRootPane(component) != null) {
            Point compLoc = new Point();
            Point windowLoc = new Point();
            SwingUtilities.convertPointToScreen(compLoc, component);
            SwingUtilities.convertPointToScreen(windowLoc, SwingUtilities.getRootPane(component));
            int x = compLoc.x - windowLoc.x;
            int y = compLoc.y - windowLoc.y;
            Rectangle rect = new Rectangle(x, y, component.getBounds().width - 1, component.getBounds().height - 1);
            this.myCurrentGlassPane.addBorder(rect);
        }
    }

    protected void createChildNodes(Container container, DefaultMutableTreeNode containerNode) {
        int i = 0;
        while (i < container.getComponents().length) {
            Component component = container.getComponents()[i];
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(new SwingComponentNode(component));
            containerNode.add(childNode);
            if (component instanceof Container) {
                this.createChildNodes((Container)component, childNode);
            }
            ++i;
        }
    }

    protected void buildComponentTree() {
        if (this.myRootNode != null) {
            this.myRootNode.removeAllChildren();
        }
        this.myRootNode = new DefaultMutableTreeNode(new SwingComponentNode(this.myCurrentlySelectedWindow));
        this.createChildNodes(this.myCurrentlySelectedWindow, this.myRootNode);
        this.mySwingHierarchyTree.setModel(new DefaultTreeModel(this.myRootNode));
        this.setTitle("Component tree: " + (String)this.myWindowSelectionComboBox.getSelectedItem());
        this.repaint();
    }

    protected void buildWindowList() {
        this.myWindowMap.clear();
        int i = 0;
        while (i < this.myRootFrame.getOwnedWindows().length) {
            Window child = this.myRootFrame.getOwnedWindows()[i];
            if (child != this && child != JOptionPane.getRootFrame()) {
                String title = child.getName();
                if (child instanceof Dialog) {
                    title = ((Dialog)child).getTitle();
                } else if (child instanceof JFrame) {
                    title = ((JFrame)child).getTitle();
                }
                if (title != null && title.trim().length() > 0) {
                    String clazzName = child.getClass().getName();
                    this.myWindowMap.put(String.valueOf(title) + " [" + clazzName + "]", child);
                }
            }
            ++i;
        }
        this.myWindowMap.put(String.valueOf(this.myRootFrame.getTitle()) + " [" + this.myRootFrame.getClass().getName() + "]", this.myRootFrame);
        this.myWindowSelectionComboBox.removeAllItems();
        for (String windowName : this.myWindowMap.keySet()) {
            if (this.myWindowMap.get(windowName) == this.myRootFrame) {
                this.myWindowSelectionComboBox.insertItemAt(windowName, 0);
                continue;
            }
            this.myWindowSelectionComboBox.addItem(windowName);
        }
        this.myWindowSelectionComboBox.setSelectedIndex(0);
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.buildComponentTree();
    }

    protected BorderGlassPane createGlassPaneIfItDoesNotExist() {
        BorderGlassPane glassPane = null;
        if (this.myCurrentlySelectedWindow instanceof JDialog) {
            JDialog dialog = (JDialog)this.myCurrentlySelectedWindow;
            if (dialog.getGlassPane() == null || !(dialog.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(dialog);
                dialog.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)dialog.getGlassPane();
            }
        } else if (this.myCurrentlySelectedWindow instanceof JFrame) {
            JFrame frame = (JFrame)this.myCurrentlySelectedWindow;
            if (frame.getGlassPane() == null || !(frame.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(frame);
                frame.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)frame.getGlassPane();
            }
        }
        if (glassPane != null) {
            glassPane.clearBorders();
        }
        return glassPane;
    }

    protected void cleanCurrentGlassPane() {
        if (this.myCurrentGlassPane != null) {
            this.myCurrentGlassPane.clearBorders();
            this.myCurrentlySelectedWindow.repaint();
        }
    }

    private static class BorderGlassPane
    extends JComponent {
        protected List myBorders = new LinkedList();

        public BorderGlassPane(Window window) {
            this.setSize(window.getSize());
        }

        public void clearBorders() {
            this.myBorders.clear();
        }

        public void addBorder(Rectangle rect) {
            this.myBorders.add(rect);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.RED);
            int i = 0;
            while (i < this.myBorders.size()) {
                Rectangle rect = (Rectangle)this.myBorders.get(i);
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
                ++i;
            }
        }
    }

    class FocusListener
    implements PropertyChangeListener {
        FocusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("focusOwner".equals(evt.getPropertyName()) || "permanentFocusOwner".equals(evt.getPropertyName())) {
                if (!(evt.getNewValue() instanceof JComponent)) {
                    return;
                }
                JComponent focusedComponent = (JComponent)evt.getNewValue();
                if (focusedComponent == null || SwingUtilities.getWindowAncestor(focusedComponent) == SwingHierarchyDialog.this) {
                    return;
                }
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)SwingHierarchyDialog.this.mySwingHierarchyTree.getModel().getRoot();
                Enumeration<TreeNode> e = root.depthFirstEnumeration();
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                    SwingComponentNode swingNode = (SwingComponentNode)child.getUserObject();
                    if (focusedComponent != swingNode.getComponent()) continue;
                    TreePath path = new TreePath(child.getPath());
                    SwingHierarchyDialog.this.mySwingHierarchyTree.setSelectionPath(path);
                    SwingHierarchyDialog.this.mySwingHierarchyTree.scrollPathToVisible(path);
                    break;
                }
            }
        }
    }

    private static class SwingComponentNode {
        protected String myName;
        protected String myClassName;
        protected Component myComponent;

        public SwingComponentNode(Component component) {
            this.myClassName = component.getClass().getName();
            this.myName = component.getName();
            this.myComponent = component;
        }

        public Component getComponent() {
            return this.myComponent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.myName != null) {
                sb.append(this.myName);
            }
            sb.append("  [" + this.myClassName + "]");
            return sb.toString();
        }
    }

    class TreePopupMenu
    extends JPopupMenu {
        public TreePopupMenu(final SwingHierarchyDialog parentDialog) {
            JMenuItem detailsItem = new JMenuItem("Details...");
            detailsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component comp;
                    if (((TreePopupMenu)TreePopupMenu.this).SwingHierarchyDialog.this.mySwingHierarchyTree.getSelectionCount() > 0 && (comp = TreePopupMenu.this.getSelectedNodeComponent().getComponent()) != null) {
                        String text = TextUtils.forcedTextWrap(comp.toString(), "\n", 120);
                        JOptionPane.showMessageDialog(parentDialog, text, String.valueOf(comp.getClass().getName()) + " details", 1);
                    }
                }
            });
            this.add(detailsItem);
        }

        protected SwingComponentNode getSelectedNodeComponent() {
            return (SwingComponentNode)((DefaultMutableTreeNode)SwingHierarchyDialog.this.mySwingHierarchyTree.getLastSelectedPathComponent()).getUserObject();
        }
    }
}

