/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import com.nokia.em.poseidon.util.debugging.TracingEventQueue;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.spinner.SpinnerIntegerModel;
import com.nokia.widgets.table.PTableModelSorter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ThreadInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ThreadTraceDialog
extends JDialog {
    private static final int DEFAULT_WINDOW_HEIGHT = 500;
    private static final int DEFAULT_WINDOW_WIDTH = 450;
    private DefaultTableModel tableModel;
    private JTable table;
    private Timer timer;
    private int delay = 1500;

    public ThreadTraceDialog() {
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setSize(450, 500);
        this.buildUI();
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.createTimer();
    }

    private void createTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer = new Timer(this.delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadTraceDialog.this.refreshThreadList();
            }
        });
        this.timer.setInitialDelay(1500);
        this.timer.setRepeats(true);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.createTable();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(25, 25, 25, 25);
        constraints.anchor = 19;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, constraints);
        JPanel optionPanel = new JPanel();
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 25, 25, 10);
        constraints.gridy = 1;
        optionPanel.add(PLabel.createSystemText("Refresh timeout (ms)"));
        final PSpinner integerSpinner = new PSpinner(new SpinnerIntegerModel(1500, 100, 10000, 100));
        integerSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object o = integerSpinner.getValue();
                if (o != null) {
                    ThreadTraceDialog.this.delay = Integer.parseInt(o.toString());
                    ThreadTraceDialog.this.createTimer();
                    ThreadTraceDialog.this.timer.start();
                }
            }
        });
        integerSpinner.setMandatoryEntry(true);
        optionPanel.add(integerSpinner);
        ActionListener refreshListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadTraceDialog.this.refreshThreadList();
            }
        };
        JButton cancelButton = new JButton("Refresh");
        cancelButton.addActionListener(refreshListener);
        optionPanel.add(Box.createHorizontalStrut(25));
        optionPanel.add(cancelButton);
        this.add((Component)optionPanel, constraints);
        JPanel buttonPanel = new JPanel(new PButtonRowLayout());
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadTraceDialog.this.timer.stop();
                ThreadTraceDialog.this.dispose();
            }
        };
        JButton acceptButton = new JButton("Close");
        acceptButton.addActionListener(exitListener);
        this.getRootPane().setDefaultButton(acceptButton);
        buttonPanel.add(acceptButton);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.anchor = 15;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)buttonPanel, constraints);
    }

    private void createTable() {
        Object[] columns = new String[]{"Name", "ID", "State", "Notes"};
        this.tableModel = new DefaultTableModel(columns, 0);
        PTableModelSorter sortableModel = new PTableModelSorter(this.tableModel);
        this.table = new JTable(sortableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFocusable(false);
        TableColumn column = null;
        int i = 0;
        while (i < 3) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 0 || i == 2) {
                column.setPreferredWidth(120);
            } else {
                column.setPreferredWidth(40);
            }
            ++i;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.refreshThreadList();
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void refreshThreadList() {
        List<ThreadInfo> list = TracingEventQueue.getInstance().getThreadInfo();
        Iterator<ThreadInfo> it = list.iterator();
        Vector<Vector> v = this.tableModel.getDataVector();
        this.resetThreadStatuses();
        boolean found = false;
        while (it.hasNext()) {
            ThreadInfo info = it.next();
            for (Vector o : v) {
                if (info.getThreadId() != ((Long)o.get(1)).longValue()) continue;
                found = true;
                o.set(0, info.getThreadName());
                o.set(1, info.getThreadId());
                o.set(2, info.getThreadState());
                if (info.getThreadState() == Thread.State.BLOCKED) {
                    o.set(3, "Lock: " + info.getLockName() + " owned by: " + info.getLockOwnerName());
                    break;
                }
                o.set(3, "");
                break;
            }
            if (found) continue;
            this.tableModel.addRow(new Object[]{info.getThreadName(), info.getThreadId(), info.getThreadState()});
        }
        this.tableModel.fireTableDataChanged();
    }

    private void resetThreadStatuses() {
        Vector<Vector> v = this.tableModel.getDataVector();
        for (Vector o : v) {
            o.set(2, "DEAD");
        }
    }
}

