/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class TracingEventQueue
extends EventQueue {
    private static TracingEventQueueThreadJMX tracingThread;
    private static TracingEventQueue instance;
    private Set<ChangeListener> threadListeners = new HashSet<ChangeListener>();
    private Set<ChangeListener> problemListeners = new HashSet<ChangeListener>();

    public static TracingEventQueue getInstance() {
        if (instance == null) {
            instance = new TracingEventQueue();
        }
        return instance;
    }

    private TracingEventQueue() {
        tracingThread = new TracingEventQueueThreadJMX(500L);
        tracingThread.start();
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        tracingThread.eventDispatched(event);
        super.dispatchEvent(event);
        tracingThread.eventProcessed(event);
    }

    public boolean addThreadListener(ChangeListener listener) {
        return this.threadListeners.add(listener);
    }

    public boolean addProblemListener(ChangeListener listener) {
        return this.problemListeners.add(listener);
    }

    public boolean removeThreadListener(ChangeListener listener) {
        return this.threadListeners.remove(listener);
    }

    public boolean removeProblemListener(ChangeListener listener) {
        return this.problemListeners.remove(listener);
    }

    public void fireProblemsChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.problemListeners) {
            listener.stateChanged(event);
        }
    }

    public void fireThreadsChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.threadListeners) {
            listener.stateChanged(event);
        }
    }

    public Thread getTracingThread() {
        return tracingThread;
    }

    public Set<ProblemEvent> getProblemEvents() {
        return TracingEventQueue.tracingThread.problemEvents;
    }

    public List<ThreadInfo> getThreadInfo() {
        long[] threadIds;
        LinkedList<ThreadInfo> t = new LinkedList<ThreadInfo>();
        long[] lArray = threadIds = TracingEventQueue.tracingThread.threadBean.getAllThreadIds();
        int n = threadIds.length;
        int n2 = 0;
        while (n2 < n) {
            long threadId = lArray[n2];
            t.add(TracingEventQueue.tracingThread.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE));
            ++n2;
        }
        return t;
    }

    public static class ProblemEvent {
        public long timeOnEDT;
        public ThreadInfo threadInfo;
        public AWTEvent event;
    }

    protected class TracingEventQueueThreadJMX
    extends Thread {
        protected long thresholdDelay;
        protected Map<AWTEvent, Long> eventTimeMap;
        protected Set<ProblemEvent> problemEvents;
        protected Set<ProblemEvent> threadSet;
        protected ThreadMXBean threadBean;

        public TracingEventQueueThreadJMX(long delay) {
            this.setName("Event Queue Trace");
            this.thresholdDelay = delay;
            this.eventTimeMap = new HashMap<AWTEvent, Long>();
            this.problemEvents = new LinkedHashSet<ProblemEvent>();
            this.threadSet = new LinkedHashSet<ProblemEvent>();
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName objName = new ObjectName("java.lang:type=Threading");
                Set<ObjectName> mbeans = mbeanServer.queryNames(objName, null);
                for (ObjectName name : mbeans) {
                    this.threadBean = ManagementFactory.newPlatformMXBeanProxy(mbeanServer, name.toString(), ThreadMXBean.class);
                    this.threadBean.setThreadContentionMonitoringEnabled(true);
                    this.threadBean.setThreadCpuTimeEnabled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public synchronized void eventDispatched(AWTEvent event) {
            this.eventTimeMap.put(event, System.currentTimeMillis());
        }

        public synchronized void eventProcessed(AWTEvent event) {
            this.checkEventTime(event, System.currentTimeMillis(), this.eventTimeMap.get(event));
            this.eventTimeMap.put(event, null);
        }

        private void checkEventTime(AWTEvent event, long currTime, long startTime) {
            long currProcessingTime = currTime - startTime;
            if (currProcessingTime >= this.thresholdDelay) {
                ProblemEvent problemEvent = new ProblemEvent();
                this.problemEvents.add(problemEvent);
                problemEvent.event = event;
                problemEvent.timeOnEDT = currProcessingTime;
                if (this.threadBean != null) {
                    long[] threadIds;
                    long[] lArray = threadIds = this.threadBean.getAllThreadIds();
                    int n = threadIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long threadId = lArray[n2];
                        ThreadInfo info = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                        if (info != null && info.getThreadName().startsWith("AWT-EventQueue")) {
                            problemEvent.threadInfo = info;
                            TracingEventQueue.this.fireProblemsChanged();
                        }
                        ++n2;
                    }
                    long[] deadlockedThreads = this.threadBean.findMonitorDeadlockedThreads();
                    if (deadlockedThreads != null && deadlockedThreads.length > 0) {
                        System.out.println("Deadlocked threads:");
                        long[] lArray2 = deadlockedThreads;
                        int n3 = deadlockedThreads.length;
                        n = 0;
                        while (n < n3) {
                            StackTraceElement[] stack;
                            long threadId = lArray2[n];
                            ThreadInfo info = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                            System.out.println(String.valueOf(info.getThreadName()) + " / " + (Object)((Object)info.getThreadState()));
                            StackTraceElement[] stackTraceElementArray = stack = info.getStackTrace();
                            int n4 = stack.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                StackTraceElement stackEntry = stackTraceElementArray[n5];
                                System.out.println("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]");
                                ++n5;
                            }
                            ++n;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long currTime = System.currentTimeMillis();
                TracingEventQueueThreadJMX tracingEventQueueThreadJMX = this;
                synchronized (tracingEventQueueThreadJMX) {
                    for (Map.Entry<AWTEvent, Long> entry : this.eventTimeMap.entrySet()) {
                        AWTEvent event = entry.getKey();
                        if (entry.getValue() == null) continue;
                        long startTime = entry.getValue();
                        this.checkEventTime(event, currTime, startTime);
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

