/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;

public final class ClassParser {
    private ClassParser() {
    }

    public static List<Class> getClasses(String packageName) throws Exception {
        ArrayList<Class> result = new ArrayList<Class>();
        if (packageName != null) {
            String packagePath = packageName.replace('.', '/');
            String classpath = System.getProperty("java.class.path", "");
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File[] files;
                String token = st.nextToken();
                File file = new File(token);
                if (file.getPath().endsWith(".jar")) {
                    JarFile jarFile;
                    try {
                        jarFile = new JarFile(file);
                    }
                    catch (Exception e) {
                        JarException ex = new JarException("Failed to open JAR file: " + file.getAbsolutePath());
                        ex.initCause(e);
                        throw ex;
                    }
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = entries.nextElement().getName();
                        if (!entryName.startsWith(packagePath) || !entryName.endsWith(".class")) continue;
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURL()});
                        String className = entryName.replace('/', '.').substring(0, entryName.lastIndexOf(46));
                        if (!className.contains("$")) {
                            Class<?> clazz = classLoader.loadClass(className);
                            result.add(clazz);
                        }
                        classLoader.close();
                    }
                    if (jarFile == null) continue;
                    jarFile.close();
                    continue;
                }
                File packageDirectory = new File(String.valueOf(file.getPath()) + '/' + packagePath);
                if (!packageDirectory.exists() || (files = packageDirectory.listFiles()) == null) continue;
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String className;
                    File f = fileArray[n2];
                    if (f.getPath().endsWith(".class") && !(className = String.valueOf(packageName) + "." + f.getName().substring(0, f.getName().lastIndexOf(46))).contains("$")) {
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURL()});
                        Class<?> clazz = classLoader.loadClass(className);
                        result.add(clazz);
                        classLoader.close();
                    }
                    ++n2;
                }
            }
        }
        return result;
    }
}

