/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class IOUtils {
    private IOUtils() {
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteFile(File file) {
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean delFile(File file) {
        boolean deleteOk = false;
        if (file != null && !(deleteOk = file.delete())) {
            try {
                file.deleteOnExit();
            }
            catch (Exception e) {
                Logger.getLogger(IOUtils.class).warn("Failed to delete file: " + file.getName(), e);
            }
        }
        return deleteOk;
    }
}

