/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class PFileFilter
extends FileFilter {
    private List<String> myFilters = new ArrayList<String>();
    private String myDescription;
    private String myFullDescription;
    private boolean myUseExtensionsInDescription = false;

    public PFileFilter() {
    }

    public PFileFilter(String extension) {
        this(extension, null);
    }

    public PFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public PFileFilter(String[] filters) {
        this(filters, null);
    }

    public PFileFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File file) {
        if (this.myFilters.contains("*")) {
            return true;
        }
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(file);
            if (extension != null && this.myFilters.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String fileName;
        int iIndex;
        if (file != null && (iIndex = (fileName = file.getName()).lastIndexOf(46)) > 0 && iIndex < fileName.length() - 1) {
            return fileName.substring(iIndex + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        String toBeExtension = extension;
        if (toBeExtension.startsWith(".") && toBeExtension.length() > 1) {
            toBeExtension = toBeExtension.substring(1);
        }
        this.myFilters.add(toBeExtension.toLowerCase());
        this.myDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.myFullDescription == null) {
            if (this.myDescription == null || this.isExtensionListInDescription()) {
                String string = this.myFullDescription = this.myDescription == null ? "(" : String.valueOf(this.myDescription) + " (";
                if (this.myFilters.size() > 0) {
                    this.myFullDescription = String.valueOf(this.myFullDescription) + "*." + this.myFilters.get(0);
                    int i = 1;
                    while (i < this.myFilters.size()) {
                        this.myFullDescription = String.valueOf(this.myFullDescription) + "; *." + this.myFilters.get(i);
                        ++i;
                    }
                }
                this.myFullDescription = String.valueOf(this.myFullDescription) + ")";
            } else {
                this.myFullDescription = this.myDescription;
            }
        }
        return this.myFullDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
        this.myFullDescription = null;
    }

    public void setExtensionListInDescription(boolean show) {
        this.myUseExtensionsInDescription = show;
        this.myFullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.myUseExtensionsInDescription;
    }

    public List<String> getExtensions() {
        return this.myFilters;
    }
}

