/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file;

import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class PFileOutputStream
extends OutputStream {
    private long myExpectedByteSize;
    private File myDestFile;
    private OutputStream myStream;

    public PFileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public PFileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public PFileOutputStream(File file, boolean append) throws FileNotFoundException {
        this.myStream = new FileOutputStream(file, append);
        this.myDestFile = file;
        this.myExpectedByteSize = 0L;
    }

    public PFileOutputStream(FileOutputStream output) throws NullPointerException {
        if (output == null) {
            throw new NullPointerException("OutputStream should not be null");
        }
        this.myStream = output;
        this.myDestFile = null;
        this.myExpectedByteSize = 0L;
    }

    @Override
    public void write(int data) throws IOException {
        ++this.myExpectedByteSize;
        try {
            this.myStream.write(data);
        }
        catch (IOException e) {
            DiskSpaceChecker diskSpaceChecker = new DiskSpaceChecker.Builder(this.myExpectedByteSize).setDestinationFile(this.myDestFile).setCause(e).build();
            throw (IOException)diskSpaceChecker.getCause();
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.myExpectedByteSize += (long)data.length;
        try {
            this.myStream.write(data);
        }
        catch (IOException e) {
            DiskSpaceChecker diskSpaceChecker = new DiskSpaceChecker.Builder(this.myExpectedByteSize).setDestinationFile(this.myDestFile).setCause(e).build();
            throw (IOException)diskSpaceChecker.getCause();
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.myExpectedByteSize += (long)length;
        try {
            this.myStream.write(data, offset, length);
        }
        catch (IOException e) {
            DiskSpaceChecker diskSpaceChecker = new DiskSpaceChecker.Builder(this.myExpectedByteSize).setDestinationFile(this.myDestFile).setCause(e).build();
            throw (IOException)diskSpaceChecker.getCause();
        }
    }

    @Override
    public void flush() throws IOException {
        this.myStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.myStream.close();
    }

    public FileDescriptor getFD() throws IOException {
        FileDescriptor fileDescriptor = null;
        if (this.myStream instanceof FileOutputStream) {
            fileDescriptor = ((FileOutputStream)this.myStream).getFD();
        }
        return fileDescriptor;
    }

    public FileChannel getChannel() {
        FileChannel fileChannel = null;
        if (this.myStream instanceof FileOutputStream) {
            fileChannel = ((FileOutputStream)this.myStream).getChannel();
        }
        return fileChannel;
    }

    public long getExpectedByteSize() {
        return this.myExpectedByteSize;
    }

    public void setDestinationFile(File dest) {
        this.myDestFile = dest;
    }

    public File getDestinationFile() {
        return this.myDestFile;
    }
}

