/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.CopyFileProgressListener;
import com.nokia.em.poseidon.util.file.FileWriteAccessException;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileOutputStream;
import com.nokia.em.poseidon.util.file.ZippingProgressListener;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public final class PFileUtils {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final int ZIP_FILE_COUNT_WARNING_LIMIT_EXCEEDED = -1;
    public static final int ZIP_FILE_COUNT_NO_WARNING_LIMIT = -1;
    private static final long L_CRC_MIN = 0x80000001L;
    private static final long L_CRC_MAX = 0x100000000L;
    private static final long L_REDUCE_VAL = 0x100000000L;
    private static long myZippedSize = 0L;
    private static long myCopiedSize = 0L;

    private PFileUtils() {
    }

    public static File createTempDir(String dirNamePrefix) {
        File tempDir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + dirNamePrefix + System.currentTimeMillis());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        return tempDir;
    }

    public static boolean delete(File toBeDeleted) {
        String[] dirList = toBeDeleted.list();
        if (dirList != null) {
            int i = 0;
            while (i < dirList.length) {
                File childFile = new File(toBeDeleted, dirList[i]);
                PFileUtils.delete(childFile);
                ++i;
            }
        }
        return IOUtils.delFile(toBeDeleted);
    }

    public static File createDirectory(File parent, String directoryName) {
        File subDirectory = new File(parent, directoryName);
        subDirectory.mkdir();
        return subDirectory;
    }

    public static void copyFile(final File destination, File source, final CopyFileProgressListener listener, int interval) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                myCopiedSize = destination.length();
                listener.copyFileUpdated(myCopiedSize);
            }
        }, 0L, (long)interval);
        try {
            PFileUtils.copyFileByChunk(destination, source, listener);
            timer.cancel();
            myCopiedSize = destination.length();
            listener.copyFileCompleted(myCopiedSize);
        }
        catch (Exception ex) {
            timer.cancel();
            myCopiedSize = destination.length();
            listener.copyFileFailed(myCopiedSize, ex);
        }
    }

    private static void copyFileByChunk(File destinationFile, File sourceFile, CopyFileProgressListener listener) throws IOException {
        File parent = destinationFile.getParentFile();
        if (parent != null) {
            PFileUtils.checkFileWriteAccessException(parent);
        }
        DiskSpaceChecker.checkDiskSpaceException(destinationFile, sourceFile.length());
        if (destinationFile.getAbsolutePath().equals(sourceFile.getAbsolutePath())) {
            return;
        }
        myCopiedSize = 0L;
        if (!destinationFile.exists()) {
            new File(destinationFile.getParent()).mkdirs();
            destinationFile.createNewFile();
        }
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destinationChannel = null;
        FileInputStream inStream = null;
        PFileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(sourceFile);
            outStream = new PFileOutputStream(destinationFile);
            sourceChannel = inStream.getChannel();
            destinationChannel = outStream.getChannel();
            if (destinationChannel == null) {
                return;
            }
            long count = 0L;
            long size = ((FileChannel)sourceChannel).size();
            do {
                if (!listener.isAbortCopyFile()) continue;
                IOUtils.deleteFile(destinationFile);
                break;
            } while ((count += ((FileChannel)destinationChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), count, size - count)) < size);
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destinationChannel != null) {
                destinationChannel.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static void copyFile(File destinationFile, File sourceFile) throws IOException {
        if (destinationFile.getAbsolutePath().equals(sourceFile.getAbsolutePath())) {
            return;
        }
        DiskSpaceChecker.checkDiskSpaceException(destinationFile, sourceFile.length());
        PFileUtils.copyFileToStream(new PFileOutputStream(destinationFile), sourceFile);
    }

    public static void copyFileToStream(PFileOutputStream destinationStream, File sourceFile) throws IOException {
        File destinationFile = destinationStream.getDestinationFile();
        if (destinationFile.getAbsolutePath().equals(sourceFile.getAbsolutePath())) {
            return;
        }
        myCopiedSize = 0L;
        if (!destinationFile.exists()) {
            destinationFile.createNewFile();
        }
        FileChannel source = null;
        FileChannel destination = null;
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(sourceFile);
                source = input.getChannel();
                destination = destinationStream.getChannel();
                destination.transferFrom(source, 0L, source.size());
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                DiskSpaceChecker diskSpaceChecker = new DiskSpaceChecker.Builder(source.size()).setDestinationFile(destinationFile).setCause(e).build();
                throw (IOException)diskSpaceChecker.getCause();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(source);
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(destination);
            IOUtils.closeQuietly(destinationStream);
            throw throwable;
        }
        IOUtils.closeQuietly(source);
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(destination);
        IOUtils.closeQuietly(destinationStream);
    }

    public static void zip(File destination, File source) throws IOException {
        PFileUtils.zip(destination, Collections.singletonList(source));
    }

    public static void zip(File destination, List<File> sources) throws IOException {
        myZippedSize = 0L;
        try (ZipOutputStream zos = null;){
            zos = new ZipOutputStream(new PFileOutputStream(destination));
            for (File source : sources) {
                int length;
                if (!source.isDirectory()) {
                    length = 0;
                    String parent = source.getParent();
                    if (parent != null) {
                        length = (String.valueOf(parent) + File.separatorChar).length();
                    }
                    PFileUtils.zipFile(source, zos, length);
                    continue;
                }
                length = (String.valueOf(source.getPath()) + File.separatorChar).length();
                PFileUtils.zipDir(source, zos, length);
            }
        }
    }

    public static void zip(File destination, File source, final ZippingProgressListener listener, int interval) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                listener.zippingUpdated(myZippedSize);
            }
        }, 0L, (long)interval);
        try {
            PFileUtils.zip(destination, Collections.singletonList(source));
            timer.cancel();
            listener.zippingCompleted(myZippedSize);
        }
        catch (Exception ex) {
            timer.cancel();
            listener.zippingFailed(myZippedSize, ex);
        }
    }

    public static File gzip(File source) throws IOException {
        File destination = null;
        try (DeflaterOutputStream out = null;){
            int len;
            destination = new File(source.getAbsolutePath().concat(".gz"));
            out = new GZIPOutputStream(new FileOutputStream(destination));
            FileInputStream in = new FileInputStream(source);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((GZIPOutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((GZIPOutputStream)out).finish();
        }
        return destination;
    }

    public static File gunzip(File source) throws IOException {
        File destination = null;
        try (OutputStream out = null;){
            int len;
            destination = new File(source.getAbsolutePath().replace(".gz", ""));
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(source));
            out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
        }
        return destination;
    }

    public static File unZip(File source, File destinationDir) throws IOException {
        return PFileUtils.unZip(source, destinationDir, null);
    }

    public static File unZip(File source, File destinationDir, String extFilter) throws IOException {
        ZipInputStream zip = null;
        FileOutputStream fos = null;
        byte[] readBuffer = new byte[2156];
        String filter = extFilter == null ? null : extFilter.toLowerCase();
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(source);
            zip = new ZipInputStream(fis);
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String elementName = PFileUtils.getSystemCompatibleFileName(entry.getName());
                if (filter != null && !elementName.toLowerCase().endsWith(filter)) {
                    zip.closeEntry();
                    continue;
                }
                File elementFile = new File(destinationDir, elementName);
                File parent = elementFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    int bytesIn;
                    fos = new FileOutputStream(elementFile);
                    while ((bytesIn = zip.read(readBuffer)) != -1) {
                        fos.write(readBuffer, 0, bytesIn);
                    }
                }
                finally {
                    fos.close();
                }
                zip.closeEntry();
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        return destinationDir;
    }

    private static String getSystemCompatibleFileName(String name) {
        char toBeReplaced = '\\' == File.separatorChar ? (char)'/' : '\\';
        return name.replace(toBeReplaced, File.separatorChar);
    }

    public static File[] unZipFileTree(File file) throws IOException {
        return PFileUtils.unZipFileTree(file, null);
    }

    public static File[] unZipFileTree(File file, String extFilter) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File root = PFileUtils.unZip(file, PFileUtils.createTempDir("PFileUtilsUnzipFileTree"), extFilter);
        PFileUtils.addChildFiles(files, root);
        if (files.isEmpty()) {
            return PFileUtils.listFileTree(file);
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getZipFileCount(File source, int limit) throws IOException {
        ZipInputStream zip = null;
        int fileCount = 0;
        int trigger = limit == -1 ? Integer.MAX_VALUE : limit;
        try {
            ZipEntry entry;
            zip = new ZipInputStream(new FileInputStream(source));
            while ((entry = zip.getNextEntry()) != null && fileCount <= trigger) {
                if (!entry.isDirectory()) {
                    ++fileCount;
                }
                zip.closeEntry();
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        if (fileCount > trigger) {
            return -1;
        }
        int n = fileCount;
        return n;
    }

    public static long getFileSize(File file) throws Exception {
        long size = 0L;
        File[] flist = file.listFiles();
        if (flist != null) {
            int i = 0;
            while (i < flist.length) {
                size = flist[i].isDirectory() ? (size += PFileUtils.getFileSize(flist[i])) : (size += flist[i].length());
                ++i;
            }
        }
        return size;
    }

    public static File[] listFileTree(File file) {
        ArrayList<File> files = new ArrayList<File>();
        PFileUtils.addChildFiles(files, file);
        return files.toArray(new File[files.size()]);
    }

    public static FileState canWriteTo(File file) {
        if (file.exists()) {
            if (!file.canWrite()) {
                return FileState.CANNOT_WRITE;
            }
            if (file.isHidden()) {
                return FileState.HIDDEN;
            }
            return FileState.EXISTS;
        }
        File tempFile = new File(file.getAbsolutePath());
        if (tempFile.getParent() == null) {
            return FileState.PATH_NOT_EXISTS;
        }
        if (!new File(tempFile.getParent()).exists()) {
            return FileState.PATH_NOT_EXISTS;
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            IOUtils.deleteFile(file);
        }
        if (!file.canWrite()) {
            return FileState.CANNOT_WRITE;
        }
        IOUtils.deleteFile(file);
        return FileState.WRITABLE;
    }

    public static File isReadableFile(String path) {
        File file = null;
        try {
            file = new File(path);
        }
        catch (Exception e) {
            return null;
        }
        if (file.canRead() && !file.isDirectory()) {
            return file;
        }
        return null;
    }

    public static String removeInvalidCharacters(String filename) {
        StringBuilder finalName = new StringBuilder(filename);
        int nameLen = filename.length();
        int i = nameLen - 1;
        while (i >= 0) {
            char ch = filename.charAt(i);
            if ((ch < ' ' || ch > '~') && !PFileUtils.isUTF8CharacterSupported() && !PFileUtils.isLanguangeSupported(filename, i) || ch == '\\' || ch == '/' || ch == ':' || ch == '*' || ch == '?' || ch == '\"' || ch == '<' || ch == '>' || ch == '|') {
                finalName.deleteCharAt(i);
            }
            --i;
        }
        return finalName.toString();
    }

    public static boolean isLanguangeSupported(String filename, int i) {
        int codepoint = filename.codePointAt(i);
        return Character.UnicodeScript.of(codepoint) == Character.UnicodeScript.HAN;
    }

    public static boolean isUTF8CharacterSupported() {
        return PoseidonRuntime.getRuntime().getParameters().isDefined("UTF8");
    }

    public static URL parseToURL(String location) {
        URL url = null;
        File file = new File(location);
        if (file.exists()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return url;
            }
        } else {
            url = PFileUtils.class.getResource(location);
            if (url == null) {
                url = PFileUtils.class.getClassLoader().getResource(location);
            }
        }
        return url;
    }

    public static long calculateCRCChecksum(File file) throws IOException {
        Adler32 inChecker = new Adler32();
        CheckedInputStream in = null;
        in = new CheckedInputStream(new FileInputStream(file), inChecker);
        int fileIndex = in.read();
        while (fileIndex != -1) {
            fileIndex = in.read();
        }
        in.close();
        long lngCheckSum = inChecker.getValue();
        if (lngCheckSum >= 0x80000001L && lngCheckSum <= 0x100000000L) {
            lngCheckSum -= 0x100000000L;
        }
        return lngCheckSum;
    }

    private static void zipDir(File zipDir, ZipOutputStream zos, int exludedPathLegth) throws IOException {
        String[] dirList = zipDir.list();
        if (dirList == null) {
            return;
        }
        int i = 0;
        while (i < dirList.length) {
            File file = new File(zipDir, dirList[i]);
            if (file.isDirectory()) {
                PFileUtils.zipDir(file, zos, exludedPathLegth);
            } else {
                PFileUtils.zipFile(file, zos, exludedPathLegth);
            }
            ++i;
        }
    }

    private static void zipFile(File file, ZipOutputStream zos, int exludedPathLength) throws IOException {
        byte[] readBuffer = new byte[2156];
        try (FileInputStream fis = null;){
            int bytesIn;
            fis = new FileInputStream(file);
            String entryPath = file.getPath().substring(exludedPathLength);
            ZipEntry anEntry = new ZipEntry(entryPath);
            zos.putNextEntry(anEntry);
            while ((bytesIn = fis.read(readBuffer)) != -1) {
                zos.write(readBuffer, 0, bytesIn);
                myZippedSize += (long)bytesIn;
            }
            anEntry.setTime(file.lastModified());
        }
    }

    private static void addChildFiles(List<File> files, File root) {
        File[] children;
        if (root.isFile()) {
            files.add(root);
        } else if (root.isDirectory() && (children = root.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                PFileUtils.addChildFiles(files, children[i]);
                ++i;
            }
        }
    }

    public static String getFileExtension(File fileToBeResolved) {
        int iIndex;
        String fileName = fileToBeResolved.getName();
        return PFileUtils.fileNameContainsExtension(fileName, iIndex = fileName.lastIndexOf(46)) ? fileName.substring(iIndex + 1) : null;
    }

    public static String getFileNameWithoutExtension(File fileToBeResolved) {
        int iIndex;
        String fileName = fileToBeResolved.getName();
        return PFileUtils.fileNameContainsExtension(fileName, iIndex = fileName.lastIndexOf(46)) ? fileName.substring(0, iIndex) : fileName;
    }

    public static String getFilePathnameWithoutExtension(File fileToBeResolved) {
        int iIndex;
        String pathname = fileToBeResolved.getPath();
        return PFileUtils.fileNameContainsExtension(pathname, iIndex = pathname.lastIndexOf(46)) ? pathname.substring(0, iIndex) : pathname;
    }

    public static boolean isEqual(File file1, File file2) {
        return PFileUtils.getRealPath(file1).equals(PFileUtils.getRealPath(file2));
    }

    public static boolean isParent(File parent, File file) {
        File realParent = file.getParentFile();
        if (realParent == null) {
            return false;
        }
        if (PFileUtils.getRealPath(realParent).length() < PFileUtils.getRealPath(parent).length()) {
            return false;
        }
        if (PFileUtils.isEqual(parent, realParent)) {
            return true;
        }
        return PFileUtils.isParent(parent, realParent);
    }

    public static String readTextFile(String filename) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            sb.append(String.valueOf(line) + System.getProperty("line.separator"));
        }
        reader.close();
        return sb.toString().trim();
    }

    private static String getRealPath(File file) {
        String fileStr = null;
        try {
            fileStr = file.getCanonicalPath();
        }
        catch (IOException e) {
            fileStr = file.getAbsolutePath();
        }
        return fileStr;
    }

    private static boolean fileNameContainsExtension(String fileName, int extensionStartIndex) {
        return extensionStartIndex > 0 && extensionStartIndex < fileName.length();
    }

    public static boolean isFileExisting(Object file) {
        File localFile = null;
        if (file instanceof File) {
            localFile = new File(((File)file).getAbsolutePath());
        } else if (file instanceof String) {
            localFile = new File((String)file);
        }
        return localFile != null && localFile.exists() && !localFile.isDirectory();
    }

    public static boolean isFileExtensionAppended(String fileName, String fileExtension) {
        int extensionStartIndex = fileName.lastIndexOf(".") + 1;
        if (extensionStartIndex > 0) {
            String appendedExtension = fileName.substring(extensionStartIndex);
            return appendedExtension.equalsIgnoreCase(fileExtension);
        }
        return false;
    }

    public static String addIncrementToFileName(String path, File defaultFile) {
        String currentDirectory = String.valueOf(path) + System.getProperty("file.separator");
        String fileName = PFileUtils.getFileNameWithoutExtension(defaultFile);
        String fileExtension = PFileUtils.getFileExtension(defaultFile);
        int i = 1;
        File tempFile = new File(String.valueOf(currentDirectory) + defaultFile);
        while (tempFile.exists() && i < 999) {
            tempFile = new File(String.valueOf(currentDirectory) + fileName + "(" + i + ")." + fileExtension);
            ++i;
        }
        return tempFile.getName();
    }

    public static List<String> parseTxtFileRows(String configFile) throws IOException {
        String inputLine;
        ArrayList<String> rows = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(configFile));
        while ((inputLine = reader.readLine()) != null) {
            if ((inputLine = inputLine.trim()).length() <= 0 || inputLine.startsWith("#")) continue;
            rows.add(inputLine);
        }
        reader.close();
        return rows;
    }

    public static boolean makeDirectory(File dir) throws SecurityException {
        dir.mkdirs();
        return dir.exists();
    }

    public static void checkFileWriteAccessException(File fileToBeWrittenTo) throws FileWriteAccessException {
        if (!fileToBeWrittenTo.exists() || !fileToBeWrittenTo.canWrite()) {
            throw new FileWriteAccessException("Cannot write or access " + fileToBeWrittenTo.toString());
        }
    }

    public static String getLatestFileName(String prefix, String extension, File parent, boolean writable) {
        int index = PFileUtils.getLatestFileIndexWithPrefix(prefix, extension, parent, writable);
        if (index == 0) {
            return String.valueOf(prefix) + extension;
        }
        if (index > 0) {
            return String.valueOf(prefix) + "_" + index + extension;
        }
        return null;
    }

    private static int getLatestFileIndexWithPrefix(String prefix, String extension, File parent, boolean writable) {
        File parentFile = parent;
        if (parentFile == null) {
            parentFile = new File(System.getProperty("user.dir"));
        }
        int maxIndex = -1;
        int writableIndex = -1;
        int tempN = -1;
        String[] files = PFileUtils.listFiles(prefix, extension, parentFile);
        if (files == null) {
            return -1;
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            int index1 = childName.lastIndexOf("_");
            if (index1 != -1) {
                int index2 = childName.lastIndexOf(".");
                if (index2 > index1) {
                    try {
                        tempN = Integer.parseInt(childName.substring(index1 + 1, index2));
                    }
                    catch (NumberFormatException e) {
                        Logger.getLogger(PSettings.class).error("Fail to parse file name:" + childName, e);
                    }
                    if (maxIndex < tempN) {
                        maxIndex = tempN;
                        if (new File(parentFile, childName).canWrite()) {
                            writableIndex = tempN;
                        }
                    }
                }
            } else if (maxIndex == -1) {
                tempN = 0;
                maxIndex = 0;
                if (new File(parentFile, childName).canWrite()) {
                    writableIndex = 0;
                }
            }
            ++n2;
        }
        if (writable) {
            if (writableIndex == -1 && parent.canWrite()) {
                writableIndex = maxIndex + 1;
            }
            return writableIndex;
        }
        return maxIndex;
    }

    private static String[] listFiles(final String prefix, final String extension, File parentFile) {
        if (parentFile == null || !parentFile.exists()) {
            return null;
        }
        String[] files = parentFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(extension);
            }
        });
        return files;
    }

    public static File renameFile(File file, String newFilename) {
        if (file == null || newFilename == null || newFilename.isEmpty()) {
            return null;
        }
        try {
            return PFileUtils.createRenamedFile(file, newFilename);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static File createRenamedFile(File file, String newFilename) throws IOException {
        Path filePath = file.toPath();
        Path newFilePath = filePath.resolveSibling(newFilename);
        Files.move(filePath, newFilePath, StandardCopyOption.REPLACE_EXISTING);
        return newFilePath.toFile();
    }

    public static enum FileState {
        CANNOT_WRITE,
        EXISTS,
        WRITABLE,
        PATH_NOT_EXISTS,
        HIDDEN;

    }
}

