/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file.dirwatch;

import com.nokia.em.poseidon.util.file.dirwatch.DirectoryListener;
import com.nokia.em.poseidon.util.file.dirwatch.DirectoryWatchService;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DirectoryWatchServiceImpl
implements DirectoryWatchService {
    private WatchService myDirWatcher;
    private Map<WatchKey, List<DirListenerInfo>> myKeysVsPath;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    @Override
    public void start() {
        try {
            this.myDirWatcher = FileSystems.getDefault().newWatchService();
            this.myKeysVsPath = new HashMap<WatchKey, List<DirListenerInfo>>();
            Thread r = new Thread(){

                @Override
                public void run() {
                    DirectoryWatchServiceImpl.this.processEvents();
                }
            };
            r.start();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).error("Directory watch service starting failed." + e);
        }
    }

    @Override
    public void stop() {
        try {
            this.myKeysVsPath.clear();
            this.myDirWatcher.close();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).error("Directory watch service stopping failed." + e);
        }
    }

    @Override
    public void addDirectoryListener(DirectoryListener listener, Path path, boolean recursive) throws IOException {
        DirListenerInfo lp = new DirListenerInfo(listener, path, recursive);
        if (recursive) {
            this.registerAll(lp);
        } else {
            this.register(lp, path);
        }
    }

    @Override
    public void removeDirectoryListener(DirectoryListener listener) {
        ArrayList<WatchKey> keysToBeRemoved = new ArrayList<WatchKey>();
        for (WatchKey key : this.myKeysVsPath.keySet()) {
            ArrayList<DirListenerInfo> dliToBeRemoved = new ArrayList<DirListenerInfo>();
            for (DirListenerInfo dli : this.myKeysVsPath.get(key)) {
                if (!dli.getListener().equals(listener)) continue;
                dliToBeRemoved.add(dli);
            }
            this.myKeysVsPath.get(key).removeAll(dliToBeRemoved);
            if (!this.myKeysVsPath.get(key).isEmpty()) continue;
            keysToBeRemoved.add(key);
        }
        for (WatchKey key : keysToBeRemoved) {
            key.cancel();
            this.myKeysVsPath.remove(key);
        }
    }

    private void register(DirListenerInfo lp, Path path) throws IOException {
        WatchKey key = path.register(this.myDirWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        List<DirListenerInfo> listeners = this.myKeysVsPath.get(key);
        if (listeners != null) {
            listeners.add(lp);
        } else {
            listeners = new ArrayList<DirListenerInfo>();
            listeners.add(lp);
            this.myKeysVsPath.put(key, listeners);
        }
    }

    private void registerAll(final DirListenerInfo lp) throws IOException {
        Files.walkFileTree(lp.getPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DirectoryWatchServiceImpl.this.register(lp, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void processEvents() {
        while (true) {
            WatchKey key;
            try {
                while ((key = this.myDirWatcher.poll(1L, TimeUnit.SECONDS)) == null) {
                }
            }
            catch (InterruptedException x) {
                Logger.getLogger(this.getClass()).error("Directory watching service poller interrupted." + x);
                return;
            }
            catch (ClosedWatchServiceException e) {
                Logger.getLogger(this.getClass()).error("Directory watching service closed." + e);
                return;
            }
            List<DirListenerInfo> lpList = this.myKeysVsPath.get(key);
            if (lpList == null || lpList.isEmpty()) continue;
            Path dir = lpList.get(0).getPath();
            if (dir == null) {
                Logger.getLogger(this.getClass()).error("Directory watching service did not recognize WatchKey." + key);
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = DirectoryWatchServiceImpl.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                for (DirListenerInfo lp : lpList) {
                    this.notifyListeners(lp, kind, child);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.myKeysVsPath.remove(key);
            if (this.myKeysVsPath.isEmpty()) break;
        }
    }

    private void notifyListeners(DirListenerInfo lp, WatchEvent.Kind kind, Path child) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            lp.getListener().entryCreated(child);
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            lp.getListener().entryDeleted(child);
        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            lp.getListener().entryModified(child);
        }
        if (lp.isRecursive() && kind == StandardWatchEventKinds.ENTRY_CREATE) {
            try {
                if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    this.registerAll(new DirListenerInfo(lp.getListener(), child, true));
                }
            }
            catch (IOException x) {
                Logger.getLogger(this.getClass()).error("Directory watch service cannot register new folder." + x);
            }
        }
    }

    private class DirListenerInfo {
        DirectoryListener myListener;
        Path myPath;
        boolean myRecursive;

        public DirListenerInfo(DirectoryListener listener, Path path, boolean recursive) {
            this.myListener = listener;
            this.myPath = path;
            this.myRecursive = recursive;
        }

        public DirectoryListener getListener() {
            return this.myListener;
        }

        public Path getPath() {
            return this.myPath;
        }

        public boolean isRecursive() {
            return this.myRecursive;
        }
    }
}

