/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file.diskspace;

import com.nokia.em.poseidon.util.file.PFileOutputStream;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import java.io.File;
import org.apache.log4j.Logger;

public final class DiskSpaceChecker {
    private static int UNDETERMINED_BYTE_SIZE = -1;
    private File myDestFile;
    private long mySourceByte;
    private Throwable myCause;

    private DiskSpaceChecker(Builder builder) {
        this.myDestFile = builder.myDestFile;
        this.initSourceByte(builder);
        this.initCause(builder.myCause);
    }

    private void initSourceByte(Builder builder) {
        this.mySourceByte = builder.mySourceByte;
        if (builder.mySourceFile != null && this.mySourceByte <= 0L) {
            this.mySourceByte = DiskSpaceChecker.getFileSize(builder.mySourceFile);
        }
        if (builder.myFileOutStream != null && this.mySourceByte <= 0L) {
            this.mySourceByte = builder.myFileOutStream.getExpectedByteSize();
        }
    }

    private void initCause(Throwable cause) {
        try {
            DiskSpaceChecker.checkDiskSpaceException(this.myDestFile, this.mySourceByte);
            this.myCause = DiskSpaceChecker.extractDiskSpaceException(cause);
            if (this.myCause == null) {
                this.myCause = cause;
            }
        }
        catch (DiskSpaceException e) {
            this.myCause = new DiskSpaceException(e.getMessage(), cause);
        }
    }

    public static Throwable extractDiskSpaceException(Throwable cause) {
        if (cause == null) {
            return null;
        }
        if (cause instanceof DiskSpaceException) {
            return cause;
        }
        if (cause.getCause() == null) {
            return null;
        }
        return DiskSpaceChecker.extractDiskSpaceException(cause.getCause());
    }

    public Throwable getCause() {
        return this.myCause;
    }

    public static void checkDiskSpaceException(File destination, long sourceSize) throws DiskSpaceException {
        DiskSpaceChecker.checkDiskSpaceException(destination, null, sourceSize);
    }

    public static void checkDiskSpaceException(File target, String serverFile, long sourceSize) throws DiskSpaceException {
        if (!DiskSpaceChecker.hasAvailableForDiskSpace(target, sourceSize)) {
            String location = serverFile == null ? target.getAbsolutePath() : serverFile;
            throw new DiskSpaceException(location, sourceSize, DiskSpaceChecker.getFreeSpace(target));
        }
    }

    public static boolean hasAvailableForDiskSpace(File destination, long sourceSize) {
        if (sourceSize < 0L) {
            return true;
        }
        long availableSpace = DiskSpaceChecker.getFreeSpace(destination);
        if (availableSpace < 0L) {
            return true;
        }
        return availableSpace >= sourceSize;
    }

    public static long getFreeSpace(File file) {
        long size = UNDETERMINED_BYTE_SIZE;
        if (file == null) {
            return size;
        }
        File fileToCheck = file;
        File parent = file.getAbsoluteFile().getParentFile();
        if (parent != null && PFileUtils.makeDirectory(parent)) {
            fileToCheck = parent;
        }
        try {
            size = fileToCheck.getFreeSpace();
        }
        catch (SecurityException e) {
            Logger.getLogger(DiskSpaceChecker.class).warn("Failed to check available space: " + file.getName(), e);
        }
        return size;
    }

    public static long getFileSize(File file) {
        long size = 0L;
        try {
            if (!file.exists()) {
                return size;
            }
            if (file.isFile()) {
                return file.length();
            }
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                return size;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                size += DiskSpaceChecker.getFileSize(f);
                ++n2;
            }
        }
        catch (SecurityException e) {
            Logger.getLogger(DiskSpaceChecker.class).warn("Failed to get file size: " + file.getName(), e);
        }
        return size;
    }

    /* synthetic */ DiskSpaceChecker(Builder builder, DiskSpaceChecker diskSpaceChecker) {
        this(builder);
    }

    public static class Builder {
        private File myDestFile;
        private File mySourceFile;
        private PFileOutputStream myFileOutStream;
        private long mySourceByte;
        private Throwable myCause;

        public Builder(File source) throws NullPointerException {
            if (source == null) {
                throw new NullPointerException("The file source of disk space checking is null");
            }
            this.mySourceFile = source;
            this.mySourceByte = UNDETERMINED_BYTE_SIZE;
        }

        public Builder(PFileOutputStream source) throws NullPointerException {
            if (source == null) {
                throw new NullPointerException("The stream source of disk space checking is null");
            }
            this.myFileOutStream = source;
            this.mySourceByte = UNDETERMINED_BYTE_SIZE;
        }

        public Builder(long byteSize) throws IllegalArgumentException {
            if (byteSize < 0L) {
                throw new IllegalArgumentException("Byte size of the source cause of checking should not be negative.");
            }
            this.mySourceByte = byteSize;
        }

        public Builder(Throwable cause) {
            this.myCause = cause;
            this.mySourceByte = UNDETERMINED_BYTE_SIZE;
        }

        public Builder setDestinationFile(File dest) {
            this.myDestFile = dest;
            return this;
        }

        public Builder setCause(Throwable cause) {
            this.myCause = cause;
            return this;
        }

        public DiskSpaceChecker build() {
            return new DiskSpaceChecker(this, null);
        }
    }
}

