/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.file.diskspace;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import java.io.IOException;
import java.text.MessageFormat;

public class DiskSpaceException
extends IOException {
    private static final long serialVersionUID = -1810224271600677622L;
    private static final int KB = 1024;
    private ResourceBundle myRB = I18n.getI18n().getBundle(this.getClass());
    private String mySourceLoc;
    private long mySourceByteSize;
    private long myDestByteSize;

    public DiskSpaceException() {
    }

    public DiskSpaceException(String message) {
        super(message);
    }

    public DiskSpaceException(String message, Throwable cause) {
        super(message, cause);
    }

    public DiskSpaceException(String sourceLoc, long sourceByteSize, long destByteSize) {
        this.mySourceLoc = sourceLoc;
        this.mySourceByteSize = sourceByteSize;
        this.myDestByteSize = destByteSize;
    }

    public DiskSpaceException(String sourceLoc, long sourceByteSize, long destByteSize, Throwable cause) {
        super(cause);
        this.mySourceLoc = sourceLoc;
        this.mySourceByteSize = sourceByteSize;
        this.myDestByteSize = destByteSize;
    }

    @Override
    public String getMessage() {
        if (this.mySourceLoc == null) {
            return super.getMessage();
        }
        return this.formatMessage(this.mySourceLoc, this.mySourceByteSize, this.myDestByteSize);
    }

    private String formatMessage(String sourceLoc, long sourceByteSize, long destByteSize) {
        Object[] texts = new Object[]{Float.valueOf((float)destByteSize / 1024.0f), sourceLoc, Float.valueOf((float)sourceByteSize / 1024.0f)};
        return MessageFormat.format(this.myRB.getString("DiskSpaceException.Info"), texts);
    }
}

