/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.helper;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.conninfo.BasicConnectionFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import com.nokia.em.poseidon.util.helper.WriterInterFace;
import com.nokia.widgets.text.TimeZoneFormatter;
import com.nokia.widgets.text.TimestampFormatter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class FileWriterHelper {
    private static final int MAX_LINE_LENGTH = 100;
    private PrintWriter myWriter;
    private String myTitle;
    private boolean myHasPcTime;
    private ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private Logger myLogger = Logger.getLogger(this.getClass());
    private static final String EMPTY_STRING = "";
    private static final String NEW_LINE = System.getProperty("line.separator");

    public FileWriterHelper(WriterInterFace writerInterface) {
        this.myWriter = writerInterface.getWriter();
        this.myTitle = writerInterface.getTitle();
    }

    public FileWriterHelper(String title) {
        this.myTitle = title;
    }

    public void writeHeader() {
        String header = this.getHeader();
        this.myWriter.println();
        this.writeSeparatorLine();
        this.myWriter.println();
        this.writeHeaderOrFooterToFile(this.getFormattedReport(header, 100));
        this.myWriter.println();
        this.writeSeparatorLine();
        this.myWriter.println();
        this.myWriter.println();
    }

    public void writeHeaderWithDefinedFormat(String header) {
        this.myWriter.println();
        this.writeSeparatorLine();
        this.myWriter.println();
        this.writeHeaderOrFooterToFile(this.getFormattedReport(header, 100));
        this.myWriter.println();
        this.writeSeparatorLine();
        this.myWriter.println();
        this.myWriter.println();
    }

    public void writeHeaderByRow(String ... headers) {
        this.writeSeparatorLine();
        this.myWriter.println();
        this.writeHeaderOrFooterToFile(this.getHeadersByRow(headers));
        this.myWriter.println();
        this.writeSeparatorLine();
        this.myWriter.println();
        this.myWriter.println();
    }

    public String getHeadersByRow(String ... headers) {
        List<String> headersList = Arrays.asList(headers);
        StringBuilder reportHeader = new StringBuilder(3);
        for (String header : headersList) {
            try {
                if (header.equals(headersList.get(0))) {
                    this.myTitle = header;
                    reportHeader.append(this.getFormattedReport(this.getHeader(), 100));
                } else {
                    reportHeader.append(this.getFormattedReport(header, 100));
                }
                if (header.equals(headersList.get(headersList.size() - 1))) continue;
                reportHeader.append(NEW_LINE);
            }
            catch (Exception e) {
                this.myLogger.error("[ERROR] An error has occured, invalid string input.", e);
            }
        }
        return reportHeader.toString();
    }

    public String getHeader() {
        String header = String.valueOf(this.getReportTitle()) + "    " + this.getSiteName() + "    " + this.getCurrentDateAndTime();
        return header;
    }

    public String getHeaderForCsv() {
        String header = String.valueOf(this.getReportTitle()) + " " + this.getSiteName() + " " + this.getCurrentDateAndTime();
        return header;
    }

    public String getFormattedReport(String report, int width) {
        if (report == null) {
            return EMPTY_STRING;
        }
        if (report.length() <= width) {
            return this.alignTextToCenter(report);
        }
        String subString = EMPTY_STRING;
        int breakPoint = report.lastIndexOf("    ", width);
        subString = report.substring(0, breakPoint);
        if (subString.length() <= width) {
            subString = this.alignTextToCenter(subString);
        }
        return this.alignTextToCenter(String.valueOf(subString) + NEW_LINE + this.getFormattedReport(report.substring(breakPoint).trim(), width));
    }

    public String alignTextToCenter(String report) {
        String centeredString = report;
        int index = (100 - report.length()) / 2;
        while (index > 0) {
            centeredString = " " + centeredString;
            --index;
        }
        return centeredString;
    }

    public String getReportTitle() {
        return String.valueOf(this.myTitle) + " " + this.myResourceBundle.getString("FileWriterHelper.ReportHeader_Text");
    }

    public String getSiteName() {
        ConnectionEvent event;
        ConnectionInfo connectionInfoService = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
        if (connectionInfoService != null && (event = connectionInfoService.getLatestConnectionEvent(new BasicConnectionFilter(ConnectionStatus.CONNECTED))) != null) {
            return event.getNetworkElementName();
        }
        return EMPTY_STRING;
    }

    public String getCurrentDateAndTime() {
        Date currentDate = new Date(System.currentTimeMillis());
        String additionalTextString = this.myHasPcTime ? " " + this.myResourceBundle.getString("FileWriterHelper.Timezone_AdditionalInfo_Text") : EMPTY_STRING;
        return String.valueOf(TimestampFormatter.applyLongFormat(currentDate)) + " " + TimeZoneFormatter.formatGMTText(Calendar.getInstance().getTimeZone(), currentDate) + additionalTextString;
    }

    public void writeFooter() {
        this.writeSeparatorLine();
        this.myWriter.println();
        this.writeHeaderOrFooterToFile(this.getFormattedReport(this.getFooter(), 100));
        this.myWriter.println();
        this.writeSeparatorLine();
    }

    public void writeHeaderOrFooterToFile(String report) {
        this.myWriter.write(report.toCharArray(), 0, report.length());
    }

    public String getFooter() {
        Object[] args = new Object[]{this.myTitle};
        String footer = MessageFormat.format(this.myResourceBundle.getString("FileWriterHelper.ReportFooter_Text"), args);
        return footer;
    }

    private void writeSeparatorLine() {
        this.writeHeaderOrFooterToFile(this.generateLineSeparators());
    }

    public String generateLineSeparators() {
        StringBuilder separatorLine = new StringBuilder(100);
        int index = 0;
        while (index < 100) {
            separatorLine.append("=");
            ++index;
        }
        return separatorLine.toString();
    }

    public void setHasPcTime() {
        this.myHasPcTime = true;
    }

    public PrintWriter getWriter() {
        return this.myWriter;
    }

    public String getTitle() {
        return this.myTitle;
    }
}

