/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.logging;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.text.PTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LoggerPanel
extends PPanel {
    private static final int DEFAULT_MAX_DOCUMENT_LENGTH = 10000000;
    private static final int SEARCH_FIELD_COLUMNS = 20;
    private static final String MESSAGE_TEMPLATE = "[{0}]";
    private static final String START_BUTTON_TEXT = "Start logging";
    private static final String STOP_BUTTON_TEXT = "Stop logging";
    private static final String CLEAR_BUTTON_TEXT = "Clear";
    private static final String SEARCH_BUTTON_TEXT = "Search";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TIME_STAMP_DATE_FORMAT = "[HH:mm:ss.SSS] [dd.MM.yyyy]";
    private static final Color TIME_STAMP_COLOR = new Color(178, 33, 33);
    private static final Color LOGGER_NAME_COLOR = new Color(0, 0, 139);
    private static final Color LOG_LEVEL_COLOR = new Color(0, 139, 69);
    private static final Color SEARCH_HIGHLIGHT_COLOR = new Color(255, 215, 0);
    private SimpleAttributeSet myTimeStampAttrSet;
    private SimpleAttributeSet myLoggerNameAttrSet;
    private SimpleAttributeSet myLogLevelAttrSet;
    private JTextPane myLogTextPanel;
    private AbstractDocument myDocument;
    private PTextField mySearchField;
    private JButton mySearchButton;
    private JButton myStartButton;
    private JButton myClearButton;
    private DefaultHighlighter.DefaultHighlightPainter myHighlightPainter;
    private PPanel myAdvancedPanel;
    private String mySearchWord;
    private PanelLoggerAppender myAppender;
    private List<Logger> myLoggers = new ArrayList<Logger>();
    private List<String> myTextFilters = new ArrayList<String>();
    private int myLogMaxLength = 10000000;
    private boolean myIsRunning = false;

    public LoggerPanel() {
        this(new Logger[0]);
    }

    public LoggerPanel(Logger[] loggers) {
        this(loggers, new String[0]);
    }

    public LoggerPanel(Logger[] loggers, String ... filters) {
        this(loggers, 10000000, filters);
    }

    public LoggerPanel(Logger[] loggers, int maxLogLenght, String ... filters) {
        super(new BorderLayout());
        Object[] objectArray = loggers;
        int n = loggers.length;
        int n2 = 0;
        while (n2 < n) {
            Logger logger = objectArray[n2];
            this.myLoggers.add(logger);
            ++n2;
        }
        objectArray = filters;
        n = filters.length;
        n2 = 0;
        while (n2 < n) {
            Object filter = objectArray[n2];
            this.myTextFilters.add((String)filter);
            ++n2;
        }
        this.myLogMaxLength = maxLogLenght;
        this.init();
        this.buildUI();
    }

    private void init() {
        this.myAppender = new PanelLoggerAppender();
        this.myLogTextPanel = new JTextPane();
        this.myLogTextPanel.setEditable(false);
        this.myDocument = (AbstractDocument)((Object)this.myLogTextPanel.getStyledDocument());
        this.myTimeStampAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.myTimeStampAttrSet, TIME_STAMP_COLOR);
        StyleConstants.setBold(this.myTimeStampAttrSet, true);
        this.myLoggerNameAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.myLoggerNameAttrSet, LOGGER_NAME_COLOR);
        StyleConstants.setBold(this.myLoggerNameAttrSet, true);
        this.myLogLevelAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.myLogLevelAttrSet, LOG_LEVEL_COLOR);
        StyleConstants.setBold(this.myLogLevelAttrSet, true);
        this.mySearchField = new PTextField();
        this.mySearchField.setColumns(20);
        this.mySearchButton = new JButton();
        this.mySearchButton.setAction(this.createSearchAction());
        this.myStartButton = new JButton();
        this.myStartButton.setAction(this.createStartAction());
        this.myClearButton = new JButton();
        this.myClearButton.setAction(this.createClearAction());
        this.myAdvancedPanel = this.createAdvancedPanel();
        this.myAdvancedPanel.setVisible(true);
        this.myHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(SEARCH_HIGHLIGHT_COLOR);
    }

    private void buildUI() {
        this.add((Component)this.myAdvancedPanel, "North");
        this.add((Component)new JScrollPane(this.myLogTextPanel), "Center");
    }

    public synchronized void startLogging() {
        for (Logger logger : this.myLoggers) {
            logger.addAppender(this.myAppender);
        }
        this.myIsRunning = true;
        this.updateStartButtonText();
    }

    public synchronized void stopLogging() {
        for (Logger logger : this.myLoggers) {
            logger.removeAppender(this.myAppender);
        }
        this.myIsRunning = false;
        this.updateStartButtonText();
    }

    public synchronized void addLogger(Logger logger) {
        if (!this.myLoggers.contains(logger)) {
            this.myLoggers.add(logger);
            if (this.myIsRunning) {
                logger.addAppender(this.myAppender);
            }
        }
    }

    public synchronized void removeLogger(Logger logger) {
        if (this.myLoggers.remove(logger)) {
            logger.removeAppender(this.myAppender);
        }
    }

    public synchronized void removeAllLoggers() {
        for (Logger logger : this.myLoggers) {
            logger.removeAppender(this.myAppender);
        }
        this.myLoggers.clear();
    }

    public void clearLogs() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LoggerPanel.this.myDocument.replace(0, LoggerPanel.this.myDocument.getLength(), "", null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setAdvancedPanelVisible(boolean visible) {
        this.myAdvancedPanel.setVisible(visible);
    }

    private Action createSearchAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerPanel.this.searchText(LoggerPanel.this.mySearchField.getText());
            }
        };
        action.putValue("Name", SEARCH_BUTTON_TEXT);
        return action;
    }

    private Action createStartAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoggerPanel.this.myIsRunning) {
                    LoggerPanel.this.stopLogging();
                } else {
                    LoggerPanel.this.startLogging();
                }
            }
        };
        action.putValue("Name", this.myIsRunning ? STOP_BUTTON_TEXT : START_BUTTON_TEXT);
        return action;
    }

    private Action createClearAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerPanel.this.clearLogs();
            }
        };
        action.putValue("Name", CLEAR_BUTTON_TEXT);
        return action;
    }

    private PPanel createAdvancedPanel() {
        PPanel panel = new PPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0);
        PLabel searchLabel = new PLabel("Search text:");
        searchLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        panel.add((Component)searchLabel, constraints);
        constraints.gridx = 1;
        constraints.fill = 2;
        panel.add((Component)this.mySearchField, constraints);
        constraints.gridx = 2;
        constraints.fill = 0;
        panel.add((Component)this.mySearchButton, constraints);
        PPanel buttonPanel = new PPanel(new PHorizontalLayout(2, 6, 0, 0));
        buttonPanel.add(this.myStartButton);
        buttonPanel.add(this.myClearButton);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(6, 0, 6, 0);
        panel.add((Component)buttonPanel, constraints);
        constraints.gridy = 1;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        panel.add((Component)new PLabel(), constraints);
        return panel;
    }

    private void updateStartButtonText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggerPanel.this.myStartButton.getAction().putValue("Name", LoggerPanel.this.myIsRunning ? LoggerPanel.STOP_BUTTON_TEXT : LoggerPanel.START_BUTTON_TEXT);
            }
        });
    }

    private void addLog(LoggingEvent event) {
        String logDate = new SimpleDateFormat(TIME_STAMP_DATE_FORMAT).format(new Date(event.getTimeStamp()));
        String loggerName = MessageFormat.format(MESSAGE_TEMPLATE, event.getLoggerName());
        String logLevel = MessageFormat.format(MESSAGE_TEMPLATE, event.getLevel().toString());
        String message = String.valueOf(LINE_SEPARATOR) + event.getRenderedMessage() + LINE_SEPARATOR + LINE_SEPARATOR;
        try {
            if (this.isAllowedByFilters(String.valueOf(loggerName) + logLevel + message)) {
                int caretPos = this.myLogTextPanel.getCaretPosition();
                this.myDocument.insertString(this.myDocument.getLength(), logDate, this.myTimeStampAttrSet);
                this.myDocument.insertString(this.myDocument.getLength(), loggerName, this.myLoggerNameAttrSet);
                this.myDocument.insertString(this.myDocument.getLength(), logLevel, this.myLogLevelAttrSet);
                this.myDocument.insertString(this.myDocument.getLength(), message, null);
                this.myLogTextPanel.setCaretPosition(caretPos);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.checkMaxViewedLogSize();
    }

    private boolean isAllowedByFilters(String text) {
        if (this.myTextFilters == null || this.myTextFilters.size() == 0) {
            return true;
        }
        String lowerText = text.toLowerCase();
        for (String filter : this.myTextFilters) {
            if (lowerText.indexOf(filter.toLowerCase()) < 0) continue;
            return true;
        }
        return false;
    }

    private void checkMaxViewedLogSize() {
        if (this.myDocument.getLength() > this.myLogMaxLength) {
            int removeElementIndex = this.myDocument.getDefaultRootElement().getElementIndex(this.myDocument.getLength() - this.myLogMaxLength);
            int removeEndOffset = this.myDocument.getDefaultRootElement().getElement(removeElementIndex).getEndOffset();
            int removeOffs = Math.min(removeEndOffset, this.myDocument.getLength());
            try {
                this.myDocument.remove(0, removeOffs);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void searchText(String text) {
        try {
            Highlighter h = this.myLogTextPanel.getHighlighter();
            if (text.equalsIgnoreCase(this.mySearchWord)) {
                return;
            }
            h.removeAllHighlights();
            this.mySearchWord = text.toLowerCase();
            if (this.mySearchWord.length() == 0) {
                return;
            }
            int wordSize = this.mySearchWord.length();
            String content = this.myDocument.getText(0, this.myDocument.getLength()).toLowerCase();
            int lastIndex = content.indexOf(this.mySearchWord, 0);
            if (lastIndex != -1) {
                h.addHighlight(lastIndex, lastIndex + wordSize, this.myHighlightPainter);
                this.myLogTextPanel.setCaretPosition(lastIndex);
            }
            while ((lastIndex = content.indexOf(this.mySearchWord, lastIndex)) != -1) {
                int endIndex = lastIndex + wordSize;
                h.addHighlight(lastIndex, endIndex, this.myHighlightPainter);
                lastIndex = endIndex;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private class PanelLoggerAppender
    extends AppenderSkeleton {
        private PanelLoggerAppender() {
        }

        @Override
        protected void append(final LoggingEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoggerPanel.this.addLog(event);
                }
            });
        }

        @Override
        public void close() {
        }

        @Override
        public boolean requiresLayout() {
            return false;
        }
    }
}

