/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.logging;

import java.util.Arrays;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class TimeZoneXMLLayout
extends Layout {
    private static final int DEFAULT_SIZE = 256;
    private static final int UPPER_LIMIT = 2048;
    private StringBuffer buf = new StringBuffer(256);
    private boolean locationInfo = false;
    private boolean properties = false;

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setProperties(boolean flag) {
        this.properties = flag;
    }

    public boolean getProperties() {
        return this.properties;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public String format(LoggingEvent event) {
        Set keySet;
        String[] s;
        if (this.buf.capacity() > 2048) {
            this.buf = new StringBuffer(256);
        } else {
            this.buf.setLength(0);
        }
        this.buf.append("<log4j:event logger=\"");
        this.buf.append(Transform.escapeTags(event.getLoggerName()));
        this.buf.append("\" timestamp=\"");
        this.buf.append(event.timeStamp);
        this.buf.append("\" timezone=\"");
        this.buf.append(TimeZone.getDefault().getID());
        this.buf.append("\" level=\"");
        this.buf.append(Transform.escapeTags(String.valueOf(event.getLevel())));
        this.buf.append("\" thread=\"");
        this.buf.append(Transform.escapeTags(event.getThreadName()));
        this.buf.append("\">\r\n");
        this.buf.append("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(this.buf, event.getRenderedMessage());
        this.buf.append("]]></log4j:message>\r\n");
        String ndc = event.getNDC();
        if (ndc != null) {
            this.buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCDATA(this.buf, ndc);
            this.buf.append("]]></log4j:NDC>\r\n");
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.buf.append("<log4j:throwable><![CDATA[");
            int i = 0;
            while (i < s.length) {
                Transform.appendEscapingCDATA(this.buf, s[i]);
                this.buf.append("\r\n");
                ++i;
            }
            this.buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locInfo = event.getLocationInformation();
            this.buf.append("<log4j:locationInfo class=\"");
            this.buf.append(Transform.escapeTags(locInfo.getClassName()));
            this.buf.append("\" method=\"");
            this.buf.append(Transform.escapeTags(locInfo.getMethodName()));
            this.buf.append("\" file=\"");
            this.buf.append(Transform.escapeTags(locInfo.getFileName()));
            this.buf.append("\" line=\"");
            this.buf.append(locInfo.getLineNumber());
            this.buf.append("\"/>\r\n");
        }
        if (this.properties && (keySet = event.getPropertyKeySet()).size() > 0) {
            this.buf.append("<log4j:properties>\r\n");
            Object[] keys = keySet.toArray();
            Arrays.sort(keys);
            int i = 0;
            while (i < keys.length) {
                String key = keys[i].toString();
                Object val = event.getMDC(key);
                if (val != null) {
                    this.buf.append("<log4j:data name=\"");
                    this.buf.append(Transform.escapeTags(key));
                    this.buf.append("\" value=\"");
                    this.buf.append(Transform.escapeTags(String.valueOf(val)));
                    this.buf.append("\"/>\r\n");
                }
                ++i;
            }
            this.buf.append("</log4j:properties>\r\n");
        }
        this.buf.append("</log4j:event>\r\n\r\n");
        return this.buf.toString();
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }
}

