/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.logging;

import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TruncatingFileAppender
extends RollingFileAppender {
    private static final String DATETIME_REG = "\\[[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{3}\\]\\s*\\[[0-9]{2}.[0-9]{2}.[0-9]{4}\\]";
    private static final String DATETIME_REG_UTC = "[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{3}Z";
    private static final String DATETIME_EVENT_SAMPLE = "log4jDateTimeEventSample";
    protected FileOutputStream myOutStream;
    protected double myStartCutPercentage;
    protected double myStopCutPercentage;
    protected int mySearchBufferSize;
    protected String myBackupFileType;
    protected int mySampleSize;
    protected LoggingEvent mySampleEvent;
    protected boolean myTruncatingHasFailed;
    protected boolean myBackupTaken;
    protected boolean myCompressBackupFile;
    protected String myCompressBackupFileExtension;
    protected int myMaxFileCount;
    protected String myApplicationHome;

    public TruncatingFileAppender() {
        this.init();
    }

    public TruncatingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
        this.init();
    }

    public TruncatingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
        this.init();
    }

    public void setStartCutPercentage(String value) {
        try {
            this.myStartCutPercentage = this.convertToPercantage(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setStopCutPercentage(String value) {
        try {
            this.myStopCutPercentage = this.convertToPercantage(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setSearchBufferSize(int size) {
        if (size > 0) {
            this.mySearchBufferSize = size;
        }
    }

    public void setSampleSize(int size) {
        if (size > 0) {
            this.mySampleSize = size;
        }
    }

    public void setMaxLogFileCount(int count) {
        if (count > 0) {
            this.myMaxFileCount = count;
        }
    }

    public void setCompressBackupFile(boolean compressBackupFile) {
        this.myCompressBackupFile = compressBackupFile;
    }

    public void setApplicationHome(String applicationHome) {
        if (applicationHome != null && !applicationHome.isEmpty()) {
            this.myApplicationHome = applicationHome;
            GeneralUtils.setAppFolderName(this.myApplicationHome);
        }
    }

    public String getBackupFileType() {
        return this.myBackupFileType;
    }

    protected void init() {
        this.myStartCutPercentage = 10.0;
        this.myStopCutPercentage = 50.0;
        this.mySearchBufferSize = 200;
        this.mySampleSize = 10;
        this.myBackupFileType = ".bk";
        this.myMaxFileCount = 20;
        this.myCompressBackupFileExtension = ".zip";
        this.myApplicationHome = "Poseidon";
    }

    protected double convertToPercantage(String value) {
        double percentageValue = Double.parseDouble(value);
        if (percentageValue >= 0.0 && percentageValue <= 100.0) {
            double percentage = percentageValue <= 1.0 ? percentageValue : percentageValue / 100.0;
            return percentage;
        }
        throw new IllegalArgumentException();
    }

    protected void truncateFile() throws Exception {
        String tempFileName = "truncateFile" + System.currentTimeMillis() + ".tmp";
        File temp = new File(tempFileName);
        this.closeFile();
        File currentLog = new File(this.fileName);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            try {
                fileInputStream = new FileInputStream(currentLog);
                source = fileInputStream.getChannel();
                fileOutputStream = new FileOutputStream(temp);
                destination = fileOutputStream.getChannel();
                long startCutPosistion = this.calculateBreakpoint((FileChannel)source, this.myStartCutPercentage);
                ((FileChannel)source).transferTo(0L, startCutPosistion, (WritableByteChannel)((Object)destination));
                String breakText = this.getBreakText();
                ((FileChannel)destination).write(ByteBuffer.wrap(breakText.getBytes()));
                ((FileChannel)source).transferTo(this.calculateBreakpoint((FileChannel)source, this.myStopCutPercentage), ((FileChannel)source).size(), (WritableByteChannel)((Object)destination));
                if (((FileChannel)destination).size() >= ((FileChannel)source).size()) {
                    ((FileChannel)destination).truncate(startCutPosistion + (long)breakText.getBytes().length);
                }
            }
            catch (Exception e) {
                this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                if (destination != null) {
                    destination.close();
                }
                if (temp.exists() && !temp.delete()) {
                    temp.deleteOnExit();
                }
                throw e;
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        if (currentLog.delete()) {
            if (!temp.renameTo(currentLog)) {
                LogLog.error("Temp file renaming fails when trying to truncate log file.");
            }
        } else {
            if (temp.exists() && !temp.delete()) {
                temp.deleteOnExit();
            }
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
            throw new Exception("Cannot delete current log file and rename temporarily file to current log file.");
        }
        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
    }

    protected String getBreakText() {
        LoggingEvent event = new LoggingEvent(this.getClass().getName(), Logger.getLogger(this.getClass()), Level.toLevel("DEBUG"), "** THE LOG FILE IS TRUNCATED HERE **", null);
        return this.layout.format(event);
    }

    protected long calculateBreakpoint(FileChannel source, double percentage) throws Exception {
        long desiredBreakIndex = 0L;
        String eventSample = this.layout.format(this.mySampleEvent);
        String dateTimeReg = this.layout instanceof PatternLayout ? DATETIME_REG : DATETIME_REG_UTC;
        boolean isXML = false;
        if (eventSample.contains("log4j:event")) {
            isXML = true;
            eventSample = eventSample.substring(0, this.mySampleSize);
        } else {
            eventSample = DATETIME_EVENT_SAMPLE;
        }
        desiredBreakIndex = (long)((double)source.size() * percentage);
        ByteBuffer searchBuffer = ByteBuffer.allocate(this.mySearchBufferSize);
        long searchIndex = desiredBreakIndex;
        int foundBreakIndex = -1;
        while (foundBreakIndex == -1) {
            int readBytes = source.read(searchBuffer, searchIndex);
            String partOftheFile = new String(searchBuffer.array());
            if (!isXML) {
                partOftheFile = partOftheFile.replaceAll(dateTimeReg, eventSample);
            }
            foundBreakIndex = partOftheFile.indexOf(eventSample);
            if (partOftheFile.length() == 0) {
                throw new Exception();
            }
            if (foundBreakIndex != -1) continue;
            searchIndex += (long)readBytes;
            searchBuffer.clear();
        }
        return searchIndex + (long)foundBreakIndex;
    }

    @Override
    public void rollOver() {
        try {
            if (!this.myTruncatingHasFailed) {
                this.truncateFile();
            }
        }
        catch (Exception e) {
            this.myTruncatingHasFailed = true;
            LogLog.error("Cannot truncate file", e);
        }
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        if (this.mySampleEvent == null) {
            this.mySampleEvent = event;
        }
    }

    @Override
    protected OutputStreamWriter createWriter(OutputStream os) {
        this.myOutStream = (FileOutputStream)os;
        return super.createWriter(os);
    }

    @Override
    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        String tempFilename = fileName;
        if (System.getProperty("logfolder") != null) {
            File tempFile;
            String filePath;
            if (System.getProperty("logfolder").contains("java.io.tmpdir")) {
                filePath = String.valueOf(System.getProperty("java.io.tmpdir")) + fileName;
                tempFile = new File(filePath);
                tempFilename = tempFile.getPath();
            } else if (System.getProperty("logfolder").contains("user.home")) {
                filePath = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + fileName;
                tempFile = new File(filePath);
                tempFilename = tempFile.getPath();
            } else {
                tempFilename = System.getProperty("logfolder");
                tempFilename = tempFilename.endsWith("/") || tempFilename.endsWith("\\") ? String.valueOf(tempFilename) + fileName : String.valueOf(tempFilename) + System.getProperty("file.separator") + fileName;
            }
        }
        tempFilename = this.getLogPathForNotWritableFolder(fileName, tempFilename);
        FileLock lock = null;
        int counter = 1;
        int index = fileName.lastIndexOf(".");
        while (lock == null && counter < this.myMaxFileCount) {
            FileOutputStream fout = null;
            try {
                this.createParentFolder(tempFilename);
                if (this.isFileNotWritableInOtherOS(new File(tempFilename))) continue;
                fout = new FileOutputStream(tempFilename, true);
                lock = fout.getChannel().tryLock();
            }
            finally {
                if (lock == null) {
                    ++counter;
                    if (index != -1) {
                        StringBuilder fileNameBuilder = new StringBuilder(fileName);
                        tempFilename = fileNameBuilder.insert(index, "_" + counter).toString();
                    } else {
                        tempFilename = String.valueOf(fileName) + "_" + counter;
                    }
                } else {
                    lock.release();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
        if (!this.myBackupTaken) {
            this.backUpOldLogFile(tempFilename);
            this.myBackupTaken = true;
        }
        if (counter < this.myMaxFileCount) {
            super.setFile(tempFilename, append, bufferedIO, bufferSize);
            this.myOutStream.getChannel().tryLock(0x7FFFFFFFFFFFFFFEL, 1L, false);
        }
    }

    private boolean isFileNotWritableInOtherOS(File file) {
        File parentFile = file.getParentFile();
        return !GeneralUtils.isWindowsOS() && parentFile != null && parentFile.exists() && parentFile.canWrite() && file.exists() && !file.canWrite();
    }

    private String getLogPathForNotWritableFolder(String originalFileName, String tempFilename) {
        String localFileName = tempFilename;
        if (!GeneralUtils.isWindowsOS()) {
            boolean changePath = false;
            File parentFile = new File(tempFilename).getParentFile();
            if (parentFile == null) {
                parentFile = new File(System.getProperty("user.dir"));
            }
            if (!parentFile.exists()) {
                File grandFile = parentFile.getParentFile();
                if (grandFile == null) {
                    grandFile = new File(System.getProperty("user.dir"));
                }
                changePath = !grandFile.canWrite();
            } else {
                boolean bl = changePath = !parentFile.canWrite();
            }
            if (changePath) {
                localFileName = String.valueOf(GeneralUtils.getAppFolderPathFromUserHome()) + File.separator + "logs" + File.separator + new File(originalFileName).getName();
            }
        }
        return localFileName;
    }

    private void createParentFolder(String logPath) {
        File logFile = new File(logPath);
        if (logFile.getParentFile() != null && !logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
    }

    private void backUpOldLogFile(String logFilePathname) {
        File logFile = new File(logFilePathname);
        if (logFile == null || !logFile.exists() || logFile.length() == 0L) {
            return;
        }
        String pathnameWithoutExtension = PFileUtils.getFilePathnameWithoutExtension(logFile);
        File tempLogFile = new File(String.valueOf(pathnameWithoutExtension) + this.myBackupFileType);
        if (tempLogFile.exists()) {
            IOUtils.deleteFile(tempLogFile);
        }
        if (!logFile.renameTo(tempLogFile)) {
            LogLog.error("rename backup log file failed.");
            return;
        }
        this.increaseOldBackupFileIndex(pathnameWithoutExtension, 1);
        this.createBackupForLogFileInNewThread(this.createBackupFilePathname(pathnameWithoutExtension, 1), tempLogFile);
    }

    private void increaseOldBackupFileIndex(String pathnameWithoutExtension, int backupFileIndex) {
        File currentBackupFile = new File(this.createBackupFilePathname(pathnameWithoutExtension, backupFileIndex));
        if (currentBackupFile.exists() && currentBackupFile.length() > 0L) {
            int nextBackupFileIndex = backupFileIndex + 1;
            File nextBackupFile = new File(this.createBackupFilePathname(pathnameWithoutExtension, nextBackupFileIndex));
            if (nextBackupFile.exists()) {
                if (nextBackupFileIndex < this.getMaxBackupIndex()) {
                    this.increaseOldBackupFileIndex(pathnameWithoutExtension, nextBackupFileIndex);
                } else {
                    IOUtils.deleteFile(nextBackupFile);
                }
            }
            if (!currentBackupFile.renameTo(nextBackupFile)) {
                LogLog.error("rename backup log file failed.");
            }
        }
    }

    private void createBackupForLogFileInNewThread(final String backupFilePathname, final File logFile) {
        new Thread(){

            @Override
            public void run() {
                try {
                    if (TruncatingFileAppender.this.myCompressBackupFile) {
                        PFileUtils.zip(new File(backupFilePathname), logFile);
                        IOUtils.deleteFile(logFile);
                    } else {
                        logFile.renameTo(new File(backupFilePathname));
                    }
                }
                catch (IOException e) {
                    LogLog.error("backup log file error.", e);
                }
            }
        }.start();
    }

    public String createBackupFilePathname(String pathnameWithoutExtension, int backupFileIndex) {
        if (this.myCompressBackupFile) {
            return String.valueOf(pathnameWithoutExtension) + this.myBackupFileType + backupFileIndex + this.myCompressBackupFileExtension;
        }
        return String.valueOf(pathnameWithoutExtension) + this.myBackupFileType + backupFileIndex;
    }
}

