/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.probe;

import com.nokia.em.poseidon.util.probe.ProbeExecutionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Probe {
    public static final String DEFAULT_EXECUTION_ID = "defaultExecutionID";
    protected Type myType;
    protected String myName;
    protected String myDescription;
    protected List<ProbeExecutionInfo> myValues;
    protected Map<String, Long> myStartTimes;
    protected long myTotalExecutionTime;
    protected static AtomicInteger myUniqueIDCounter = new AtomicInteger(0);

    public Probe() {
        this(Type.ONE_EXECUTION, Probe.createUniqueID(), "");
    }

    public Probe(Type type, String name) {
        this(type, name, "");
    }

    public Probe(Type type, String name, String description) {
        this.myType = type;
        this.myName = name;
        this.myDescription = description;
        this.myTotalExecutionTime = 0L;
        this.myStartTimes = new HashMap<String, Long>();
        this.myValues = new ArrayList<ProbeExecutionInfo>();
    }

    public void start(long startTime, String executionID) {
        if (executionID == null || executionID.length() == 0 || this.myType == Type.ONE_EXECUTION) {
            this.myStartTimes.put(DEFAULT_EXECUTION_ID, startTime);
        } else {
            this.myStartTimes.put(executionID, startTime);
        }
    }

    public void stop(long endTime, String exeId, String comment) {
        String executionID = exeId;
        if (executionID == null || executionID.length() == 0 || this.myType == Type.ONE_EXECUTION) {
            executionID = DEFAULT_EXECUTION_ID;
        }
        if (!this.myStartTimes.containsKey(executionID)) {
            return;
        }
        long startTime = this.myStartTimes.get(executionID);
        if (startTime > 0L) {
            if (this.myType == Type.ONE_EXECUTION) {
                this.myValues.clear();
                this.myTotalExecutionTime = 0L;
            } else if (this.myType == Type.INCREMENTAL) {
                this.myValues.clear();
            }
            ProbeExecutionInfo info = new ProbeExecutionInfo(this.myStartTimes.get(executionID), endTime, comment);
            this.myValues.add(info);
            this.myTotalExecutionTime += info.getExecutionTime();
            this.myStartTimes.remove(executionID);
        }
    }

    public long getTotalExecutionTime() {
        return this.myTotalExecutionTime;
    }

    public static float convertMsToSeconds(long time) {
        return (float)time / 1000.0f;
    }

    public static float convertMsToMinutes(long time) {
        return (float)time / 1000.0f / 60.0f;
    }

    public boolean isStarted() {
        return this.myStartTimes.size() > 0;
    }

    public ProbeExecutionInfo getFirstValue() {
        if (this.myValues.size() > 0) {
            return this.myValues.get(0);
        }
        return new ProbeExecutionInfo(0L, 0L, "");
    }

    public List<ProbeExecutionInfo> getValues() {
        return this.myValues;
    }

    public int getExecutionCount() {
        return this.myValues.size();
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name.length() == 0 ? Probe.createUniqueID() : name;
    }

    public Type getType() {
        return this.myType;
    }

    public void setType(Type type) {
        this.myType = type;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Probe information" + eol);
        sb.append("Name: " + this.myName + eol);
        sb.append("Type: " + (Object)((Object)this.myType) + eol);
        sb.append("Description: " + this.myDescription + eol);
        if (this.myValues.size() > 0) {
            if (this.myType == Type.INCREMENTAL) {
                sb.append("Total execution time: " + this.getTotalExecutionTime() + eol);
            }
            sb.append("Measured values:" + eol);
            for (ProbeExecutionInfo value : this.myValues) {
                sb.append("  Execution time (ms): " + value.getExecutionTime());
                if (value.getComment() != null && value.getComment().length() > 0) {
                    sb.append(" [" + value.getComment() + "]");
                }
                sb.append(eol);
            }
        } else {
            sb.append("No measured values");
        }
        sb.append(eol);
        return sb.toString();
    }

    protected static String createUniqueID() {
        return "probe" + myUniqueIDCounter.incrementAndGet();
    }

    public static enum Type {
        ONE_EXECUTION("One execution"),
        MULTIPLE_EXECUTION("Multiple executions"),
        INCREMENTAL("Incremental");

        protected String myDescription;

        private Type(String desc) {
            this.myDescription = desc;
        }

        public String toString() {
            return this.myDescription;
        }
    }
}

