/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.probe;

import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeExecutionInfo;
import com.nokia.em.poseidon.util.probe.ProbeManagementListener;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.layout.PButtonRowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class ProbeDialog
extends JDialog {
    private static final String TIME_FORMAT = "HH:mm:ss:SSS";
    protected PComboBox myComboBox;
    protected JLabel myNameLabel;
    protected JLabel myTypeLabel;
    protected JLabel myDescLabel;
    protected JLabel myTimeLabel;
    protected JButton myTimesButton;

    public ProbeDialog(JFrame parent) {
        super(parent);
        this.init();
        this.buildUI();
    }

    private void init() {
        this.myNameLabel = PLabel.createValueText("");
        this.myTypeLabel = PLabel.createValueText("");
        this.myDescLabel = PLabel.createValueText("");
        this.myTimeLabel = PLabel.createValueText("");
        this.myComboBox = new PComboBox();
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProbeDialog.this.updateSelection();
            }
        });
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        ProbeManager.addListener(new ProbeManagementListener(){

            @Override
            public void probeAdded(Probe probe) {
                ProbeDialog.this.refreshProbeCombo();
            }

            @Override
            public void probeExecutionFinished(Probe probe) {
                ProbeDialog.this.refreshProbeCombo();
            }

            @Override
            public void probeRemoved(Probe probe) {
                ProbeDialog.this.refreshProbeCombo();
            }
        });
        this.myTimesButton = new JButton("Execution Times");
        this.myTimesButton.setEnabled(false);
        this.myTimesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbeDialog.this.showProbeTimesDialog();
            }
        });
    }

    private void buildUI() {
        this.setModal(true);
        this.setResizable(true);
        this.setTitle("Performance probes");
        this.setLocationRelativeTo(this.getParent());
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBorder(new EmptyBorder(0, 0, 0, 12));
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        constraints.anchor = 18;
        constraints.setTopInset(12);
        contentPanel.add((Component)PLabel.createSystemText("Select probe:"), constraints);
        constraints.nextColumn();
        constraints.weightx = 1.0;
        contentPanel.add((Component)this.myComboBox, constraints);
        constraints.setTopInset(3);
        constraints.weightx = 0.0;
        this.refreshProbeCombo();
        constraints.nextRow();
        contentPanel.add((Component)PLabel.createSystemText("Name:"), constraints);
        constraints.nextColumn();
        contentPanel.add((Component)this.myNameLabel, constraints);
        constraints.nextRow();
        contentPanel.add((Component)PLabel.createSystemText("Type:"), constraints);
        constraints.nextColumn();
        contentPanel.add((Component)this.myTypeLabel, constraints);
        constraints.nextRow();
        contentPanel.add((Component)PLabel.createSystemText("Description:"), constraints);
        constraints.nextColumn();
        contentPanel.add((Component)this.myDescLabel, constraints);
        constraints.nextRow();
        contentPanel.add((Component)PLabel.createSystemText("Execution time:"), constraints);
        constraints.nextColumn();
        contentPanel.add((Component)this.myTimeLabel, constraints);
        constraints.nextRow();
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        contentPanel.add((Component)this.myTimesButton, constraints);
        this.add((Component)contentPanel, "Center");
        this.updateSelection();
        JPanel buttonPanel = new JPanel(new PButtonRowLayout());
        JButton exportButton = new JButton("Export to file");
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbeDialog.this.exportToFile();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbeDialog.this.dispose();
            }
        });
        buttonPanel.add(exportButton);
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    protected void refreshProbeCombo() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProbeDialog.this.refreshProbeCombo();
                }
            });
        } else {
            this.myComboBox.removeAllItems();
            for (Probe probe : ProbeManager.getProbes()) {
                this.myComboBox.addItem(probe.getName());
            }
        }
    }

    protected void updateSelection() {
        if (this.myComboBox.getItemCount() > 0) {
            String item = (String)this.myComboBox.getSelectedItem();
            Probe probe = ProbeManager.getProbe(item);
            this.myNameLabel.setText(probe.getName());
            this.myTypeLabel.setText(probe.getType().toString());
            this.myDescLabel.setText(probe.getDescription());
            this.myTimeLabel.setText(String.valueOf(String.valueOf(Probe.convertMsToSeconds(probe.getTotalExecutionTime()))) + " s");
            int probeCount = probe.getValues().size();
            this.myTimesButton.setEnabled(probeCount > 0);
        }
    }

    protected void exportToFile() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Text files";
            }
        });
        int retVal = fc.showSaveDialog(this);
        if (retVal == 0) {
            try {
                PrintWriter pw = new PrintWriter(fc.getSelectedFile());
                pw.write(ProbeManager.printProbeInfo());
                pw.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    protected void showProbeTimesDialog() {
        Probe probe = ProbeManager.getProbe((String)this.myComboBox.getSelectedItem());
        int valueCount = probe.getValues().size();
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        JTable table = new JTable(valueCount, 4);
        table.setCellSelectionEnabled(false);
        table.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(600, 400));
        table.getColumnModel().getColumn(0).setHeaderValue("Start time");
        table.getColumnModel().getColumn(1).setHeaderValue("End time");
        table.getColumnModel().getColumn(2).setHeaderValue("Execution time");
        table.getColumnModel().getColumn(3).setHeaderValue("Comment");
        table.getColumnModel().getColumn(3).setPreferredWidth(250);
        int i = 0;
        while (i < valueCount) {
            ProbeExecutionInfo info = probe.getValues().get(i);
            table.setValueAt(formatter.format(new Date(info.getStartTime())), i, 0);
            table.setValueAt(formatter.format(new Date(info.getEndTime())), i, 1);
            table.setValueAt(String.valueOf(info.getExecutionTime()) + " ms", i, 2);
            table.setValueAt(info.getComment(), i, 3);
            ++i;
        }
        final JDialog executionTimeDialog = new JDialog((Dialog)this, "Execution Times");
        executionTimeDialog.add((Component)scrollPane, "Center");
        executionTimeDialog.setSize(600, 500);
        executionTimeDialog.setLocationRelativeTo(this);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                executionTimeDialog.dispose();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(closeButton);
        executionTimeDialog.add((Component)buttonPanel, "South");
        executionTimeDialog.setVisible(true);
    }
}

