/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.probe;

import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeManagementListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProbeManager {
    protected static Map<String, Probe> myProbes = new HashMap<String, Probe>();
    protected static Set<ProbeManagementListener> myListeners = new HashSet<ProbeManagementListener>();

    public static synchronized void addProbe(Probe.Type type, String name, String description) {
        if (name != null && name.length() > 0 && !myProbes.containsKey(name)) {
            Probe probe = new Probe();
            probe.setName(name);
            probe.setDescription(description);
            probe.setType(type);
            myProbes.put(name, probe);
            for (ProbeManagementListener listener : myListeners) {
                listener.probeAdded(probe);
            }
        }
    }

    public static synchronized void startProbe(String name, String executionID) {
        Probe probe = myProbes.get(name);
        if (probe == null) {
            ProbeManager.addProbe(Probe.Type.ONE_EXECUTION, name, name);
            probe = myProbes.get(name);
        }
        if (probe.isStarted() && (executionID == null || executionID.length() == 0)) {
            probe.stop(System.currentTimeMillis(), "defaultExecutionID", "");
        }
        probe.start(System.currentTimeMillis(), executionID);
    }

    public static synchronized void startProbe(String name) {
        ProbeManager.startProbe(name, "");
    }

    public static synchronized void stopProbe(String name, String executionID, String comment) {
        Probe probe = myProbes.get(name);
        if (probe != null && probe.isStarted()) {
            probe.stop(System.currentTimeMillis(), executionID, comment);
            for (ProbeManagementListener listener : myListeners) {
                listener.probeExecutionFinished(probe);
            }
        }
    }

    public static synchronized void stopProbe(String name, String comment) {
        ProbeManager.stopProbe(name, "", comment);
    }

    public static synchronized void stopProbe(String name) {
        ProbeManager.stopProbe(name, "", "");
    }

    public static synchronized void probeInterval(String name, String executionID, String comment) {
        ProbeManager.stopProbe(name, comment);
        ProbeManager.startProbe(name);
    }

    public static synchronized void probeInterval(String name, String comment) {
        ProbeManager.stopProbe(name, comment);
        ProbeManager.startProbe(name);
    }

    public static Probe getProbe(String name) {
        return myProbes.get(name);
    }

    public static synchronized void removeProbe(String name) {
        Probe probe = myProbes.get(name);
        myProbes.remove(name);
        for (ProbeManagementListener listener : myListeners) {
            listener.probeRemoved(probe);
        }
    }

    public static synchronized void removeAllProbes() {
        Iterator<Probe> iter = myProbes.values().iterator();
        while (iter.hasNext()) {
            Probe probe = iter.next();
            iter.remove();
            for (ProbeManagementListener listener : myListeners) {
                listener.probeRemoved(probe);
            }
        }
    }

    public static void addListener(ProbeManagementListener listener) {
        myListeners.add(listener);
    }

    public static void removeListener(ProbeManagementListener listener) {
        myListeners.remove(listener);
    }

    public static List<Probe> getProbes() {
        ArrayList<Probe> probeList = new ArrayList<Probe>();
        for (Probe probe : myProbes.values()) {
            probeList.add(probe);
        }
        return probeList;
    }

    public static synchronized String printProbeInfo() {
        String eol = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(eol);
        sb.append("Performance probes:");
        sb.append(eol);
        sb.append(eol);
        for (Probe probe : myProbes.values()) {
            sb.append(probe);
            sb.append(eol);
        }
        return sb.toString();
    }
}

