/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.progressoperation;

import com.nokia.em.poseidon.util.progressoperation.ProgressOperationCursorUI;
import com.nokia.em.poseidon.util.progressoperation.ProgressOperationUI;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;

public class ProgressOperation
implements InvocationHandler {
    protected static final Timer TheTimer = new Timer();
    protected int myDelay = 500;
    protected ProgressOperationUI myProgressUI;
    protected Object myTarget;
    protected Object myProxy;

    protected ProgressOperation(Object target, Class iface) {
        this.myTarget = target;
        this.myProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)this);
        this.myProgressUI = new ProgressOperationCursorUI();
    }

    public static Object createOperation(Object operation, Class iface) {
        return iface.cast(new ProgressOperation(operation, iface).getProxy());
    }

    public static ActionListener createOperation(ActionListener listener) {
        return (ActionListener)ProgressOperation.createOperation(listener, ActionListener.class);
    }

    public static Runnable createOperation(Runnable runnable) {
        return (Runnable)ProgressOperation.createOperation(runnable, Runnable.class);
    }

    public void setDelay(int delay) {
        this.myDelay = delay;
    }

    public void setUI(ProgressOperationUI ui) {
        this.myProgressUI = ui;
    }

    protected Object getProxy() {
        return this.myProxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ShowProgressTask task = new ShowProgressTask();
        try {
            TheTimer.schedule((TimerTask)task, this.myDelay);
            try {
                Object object = method.invoke(this.myTarget, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        finally {
            task.cancel();
            this.myProgressUI.hideProgress();
        }
    }

    protected class ShowProgressTask
    extends TimerTask {
        protected ShowProgressTask() {
        }

        @Override
        public void run() {
            ProgressOperation.this.myProgressUI.showProgress();
        }
    }
}

