/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.registry;

import com.nokia.em.poseidon.util.registry.RegistryListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class Registry<T> {
    protected Map<String, T> myItems = new HashMap<String, T>();
    protected Set<RegistryListener> myRegistryListeners = new CopyOnWriteArraySet<RegistryListener>();

    public synchronized void add(String name, T item) {
        this.myItems.put(name, item);
        this.notifyItemAdded(name, item);
    }

    public synchronized List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.myItems.keySet());
        return names;
    }

    public synchronized List<T> getAll() {
        ArrayList<T> objects = new ArrayList<T>();
        objects.addAll(this.myItems.values());
        return objects;
    }

    public synchronized T get(String name) {
        return this.myItems.get(name);
    }

    public synchronized void removeAll() {
        Object[] objectArray = this.myItems.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            this.remove((String)key);
            ++n2;
        }
    }

    public synchronized void remove(T item) {
        Iterator<String> iter = this.myItems.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!this.myItems.get(name).equals(item)) continue;
            T obj = this.myItems.get(name);
            iter.remove();
            this.notifyItemRemoved(name, obj);
        }
    }

    public synchronized void remove(String name) {
        this.remove(this.myItems.get(name));
    }

    public synchronized boolean contains(String name) {
        return this.myItems.containsKey(name);
    }

    public synchronized int count() {
        return this.myItems.size();
    }

    public synchronized String getName(Object item) {
        for (String key : this.myItems.keySet()) {
            T obj = this.myItems.get(key);
            if (!obj.equals(item)) continue;
            return key;
        }
        return null;
    }

    public void addRegistryListener(RegistryListener listener) {
        if (!this.myRegistryListeners.contains(listener)) {
            this.myRegistryListeners.add(listener);
        }
    }

    public void removeRegistryListener(RegistryListener listener) {
        this.myRegistryListeners.remove(listener);
    }

    protected void notifyItemAdded(String name, T item) {
        for (RegistryListener listener : this.myRegistryListeners) {
            listener.itemAdded(name, item);
        }
    }

    protected void notifyItemRemoved(String name, T item) {
        for (RegistryListener listener : this.myRegistryListeners) {
            listener.itemRemoved(name, item);
        }
    }
}

