/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.security;

import com.nokia.em.poseidon.util.security.Base64Impl;
import java.io.UnsupportedEncodingException;

public final class Base64 {
    private static final String PREFERRED_ENCODING = "UTF-8";

    private Base64() {
    }

    public static String encodeToString(String source, boolean breakLines) {
        byte[] temp = Base64.convertToBytes(source);
        return Base64.convertToString(Base64Impl.encode(temp, 0, temp.length, breakLines));
    }

    public static String encodeToString(byte[] source, boolean breakLines) {
        return Base64.convertToString(Base64Impl.encode(source, 0, source.length, breakLines));
    }

    public static byte[] encodeToBytes(String source, boolean breakLines) {
        byte[] temp = Base64.convertToBytes(source);
        return Base64Impl.encode(temp, 0, temp.length, breakLines);
    }

    public static byte[] encodeToBytes(byte[] source, boolean breakLines) {
        return Base64Impl.encode(source, 0, source.length, breakLines);
    }

    public static String decodeToString(String source) {
        byte[] bytes = Base64.convertToBytes(source);
        return Base64.convertToString(Base64Impl.decode(bytes, 0, bytes.length));
    }

    public static String decodeToString(byte[] source) {
        return Base64.convertToString(Base64Impl.decode(source, 0, source.length));
    }

    public static byte[] decodeToBytes(String source) {
        byte[] bytes = Base64.convertToBytes(source);
        return Base64Impl.decode(bytes, 0, bytes.length);
    }

    public static byte[] decodeToBytes(byte[] source) {
        return Base64Impl.decode(source, 0, source.length);
    }

    public static String encode(String str) {
        return Base64.encodeToString(str, true);
    }

    public static String encode(byte[] buf) {
        return Base64.encodeToString(buf, true);
    }

    public static String decode(String str) {
        return Base64.decodeToString(str);
    }

    private static byte[] convertToBytes(String source) {
        byte[] bytes;
        try {
            bytes = source.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = source.getBytes();
        }
        return bytes;
    }

    private static String convertToString(byte[] bytes) {
        try {
            return new String(bytes, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(bytes);
        }
    }
}

