/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.timer;

import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SwingIdleTracker
implements AWTEventListener,
ActionListener {
    public static final int SWING_TIMEOUT_EXPIRES_ID = 100;
    private transient long myLastModifiedTime;
    private Map<ActionListener, TimeOutStatus> myListeners;
    private TimerService myTimer;
    private ActionListener myExpiringListener;
    private static SwingIdleTracker myInstance;

    public static synchronized SwingIdleTracker getInstance() {
        if (myInstance == null) {
            myInstance = new SwingIdleTracker();
        }
        return myInstance;
    }

    protected SwingIdleTracker() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 131128L);
        this.myListeners = new ConcurrentHashMap<ActionListener, TimeOutStatus>();
        this.myTimer = TimerService.getInstance();
    }

    public void addTimeOutListener(ActionListener idleListener, long timeoutInSeconds) {
        if (this.myLastModifiedTime == 0L) {
            this.myLastModifiedTime = System.currentTimeMillis();
        }
        this.myListeners.put(idleListener, new TimeOutStatus(timeoutInSeconds * 1000L, this.myLastModifiedTime + timeoutInSeconds * 1000L));
        this.updateAndScheduleNext();
    }

    public void removeTimeOutListener(ActionListener idleListener) {
        this.myListeners.remove(idleListener);
    }

    private void updateAndScheduleNext() {
        this.myTimer.stopTimer(this);
        this.myExpiringListener = null;
        TimeOutStatus tempStatus = null;
        long shortestTimeout = Long.MAX_VALUE;
        for (ActionListener listener : this.myListeners.keySet()) {
            TimeOutStatus status = this.myListeners.get(listener);
            if (status == null) continue;
            if (status.getTimeOut() < shortestTimeout) {
                shortestTimeout = status.getTimeOut();
                this.myExpiringListener = listener;
                tempStatus = status;
            }
            status.setExpireTime(this.myLastModifiedTime + status.getTimeOut());
        }
        if (shortestTimeout < Long.MAX_VALUE && tempStatus != null) {
            long timerDelay = tempStatus.getExpireTime() - System.currentTimeMillis();
            this.myTimer.startTimer((ActionListener)this, timerDelay, 1);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.myLastModifiedTime = System.currentTimeMillis();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TimeOutStatus status;
        ActionListener listener = this.myExpiringListener;
        if (listener != null && this.myListeners.containsKey(listener) && (status = this.myListeners.get(listener)) != null && status.getExpireTime() - this.myLastModifiedTime >= status.getTimeOut() && status.getExpireTime() <= System.currentTimeMillis()) {
            listener.actionPerformed(new ActionEvent(this, 100, String.valueOf(status.getTimeOut())));
            this.myListeners.remove(listener);
        }
        this.updateAndScheduleNext();
    }

    static class TimeOutStatus {
        private long myTimeOut;
        private long myExpireTime;

        public TimeOutStatus(long timeOut, long expiresTime) {
            this.myTimeOut = timeOut;
            this.myExpireTime = expiresTime;
        }

        public long getTimeOut() {
            return this.myTimeOut;
        }

        public void setTimeOut(long timeOut) {
            this.myTimeOut = timeOut;
        }

        public long getExpireTime() {
            return this.myExpireTime;
        }

        public void setExpireTime(long expiresTime) {
            this.myExpireTime = expiresTime;
        }
    }
}

