/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.timer;

import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public final class TimerService {
    public static final String ACTION_COMMAND = "TIMER_SERVICE";
    public static final long MIN_INTERVAL = 20L;
    public static final int REPEAT_FOREVER = 0;
    static final long THREAD_IDLE_TIME = 2000L;
    private static int myIdGenerator = 1;
    private static final TimerService theInstance = new TimerService(1);
    protected boolean myDaemon;
    protected final int myId;
    protected boolean myShutdown;
    protected int myThreadIdGenerator = 0;
    protected final List<Timer> myTimers = new ArrayList<Timer>(10);
    protected TimerThread myTimerThread;
    protected final ActionEvent theActionEvent = new ActionEvent(TimerService.class, 1001, "TIMER_SERVICE");

    public static TimerService getInstance() {
        return theInstance;
    }

    static TimerService getNewInstance() {
        return new TimerService(++myIdGenerator);
    }

    private TimerService(int id) {
        this.myId = id;
    }

    public boolean isScheduled(ActionListener listener) {
        return this.isScheduled(new Dispatcher(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled(Runnable listener) {
        List<Timer> list = this.myTimers;
        synchronized (list) {
            return this.LOCK_findTimerIndex(listener) >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaemon(boolean daemon) {
        List<Timer> list = this.myTimers;
        synchronized (list) {
            this.myDaemon = daemon;
            if (this.myTimerThread != null && this.myTimerThread.isDaemon() != this.myDaemon) {
                this.myTimerThread.LOCK_wakeUp(false);
                if (!this.myTimers.isEmpty()) {
                    this.LOCK_createNewThread();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<Timer> list = this.myTimers;
        synchronized (list) {
            this.myShutdown = true;
            this.myTimers.clear();
            this.setDaemon(true);
        }
    }

    public void startTimer(ActionListener listener, long interval) {
        this.startTimer(System.currentTimeMillis(), listener, interval, false, 0, false);
    }

    public void startTimer(ActionListener listener, long interval, boolean dispatchOnEdt) {
        this.startTimer(System.currentTimeMillis(), listener, interval, dispatchOnEdt, 0, false);
    }

    public void startTimer(ActionListener listener, long interval, boolean dispatchOnEdt, int repeats) {
        this.startTimer(System.currentTimeMillis(), listener, interval, dispatchOnEdt, repeats, false);
    }

    public void startTimer(ActionListener listener, long interval, int repeats) {
        this.startTimer(System.currentTimeMillis(), listener, interval, false, repeats, false);
    }

    public void startTimer(long start, ActionListener listener, long interval) {
        this.startTimer(start, listener, interval, false, 0);
    }

    public void startTimer(long start, ActionListener listener, long interval, boolean dispatchOnEdt) {
        this.startTimer(start, listener, interval, dispatchOnEdt, 0);
    }

    public void startTimer(long start, ActionListener listener, long interval, boolean dispatchOnEdt, int repeats) {
        this.startTimer(start, listener, interval, dispatchOnEdt, repeats, false);
    }

    public void startTimer(long start, ActionListener listener, long interval, boolean dispatchOnEdt, int repeats, boolean coalesce) {
        this.startTimer(start, new Dispatcher(listener), interval, dispatchOnEdt, repeats, coalesce);
    }

    public void startTimer(long start, ActionListener listener, long interval, int repeats) {
        this.startTimer(start, listener, interval, false, repeats, false);
    }

    public void startTimer(long start, Runnable listener, long interval, boolean dispatchOnEdt, int repeats) {
        this.startTimer(start, listener, interval, dispatchOnEdt, repeats, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(long start, Runnable listener, long interval, boolean dispatchOnEdt, int repeats, boolean coalesce) {
        List<Timer> list = this.myTimers;
        synchronized (list) {
            this.LOCK_removeTimer(listener);
            this.myTimers.add(new Timer(listener, start, interval, repeats, dispatchOnEdt, coalesce));
            if (this.myTimerThread == null) {
                this.LOCK_createNewThread();
            } else {
                this.myTimerThread.LOCK_wakeUp(true);
            }
        }
    }

    public void startTimer(long start, Runnable listener, long interval, int repeats) {
        this.startTimer(start, listener, interval, false, repeats, false);
    }

    public void startTimer(Runnable listener, long interval) {
        this.startTimer(System.currentTimeMillis(), listener, interval, false, 0, false);
    }

    public void startTimer(Runnable listener, long interval, boolean dispatchOnEdt) {
        this.startTimer(System.currentTimeMillis(), listener, interval, dispatchOnEdt, 0, false);
    }

    public void startTimer(Runnable listener, long interval, boolean dispatchOnEdt, int repeats) {
        this.startTimer(System.currentTimeMillis(), listener, interval, dispatchOnEdt, repeats, false);
    }

    public void startTimer(Runnable listener, long interval, int repeats) {
        this.startTimer(System.currentTimeMillis(), listener, interval, false, repeats, false);
    }

    public void stopTimer(ActionListener listener) {
        this.stopTimer(new Dispatcher(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer(Runnable listener) {
        List<Timer> list = this.myTimers;
        synchronized (list) {
            this.LOCK_removeTimer(listener);
            if (this.myTimerThread != null && this.myTimers.isEmpty()) {
                this.myTimerThread.LOCK_wakeUp(true);
            }
        }
    }

    private void LOCK_createNewThread() {
        StringBuilder b = new StringBuilder(20);
        b.append("TimerService");
        if (this.myId > 1) {
            b.append('-').append(this.myId);
        }
        b.append("-Thread-").append(++this.myThreadIdGenerator);
        this.myTimerThread = new TimerThread(b.toString());
    }

    private int LOCK_findTimerIndex(Runnable listener) {
        if (listener != null) {
            int i = this.myTimers.size();
            while (--i >= 0) {
                if (!listener.equals(this.myTimers.get(i).getListener())) continue;
                return i;
            }
        }
        return -1;
    }

    private void LOCK_removeTimer(Runnable listener) {
        int index = this.LOCK_findTimerIndex(listener);
        if (index >= 0) {
            this.myTimers.remove(index);
        }
    }

    private final class Dispatcher
    implements Runnable {
        private final ActionListener myListener;

        public Dispatcher(ActionListener listener) {
            this.myListener = listener;
        }

        public boolean equals(Object obj) {
            return obj instanceof Dispatcher && this.myListener == ((Dispatcher)obj).myListener;
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }

        @Override
        public void run() {
            this.myListener.actionPerformed(TimerService.this.theActionEvent);
        }
    }

    public static final class Timer {
        protected final Runnable myListener;
        private final boolean myCoalesce;
        private final boolean myDispatchOnEdt;
        private final long myInterval;
        private long myNext;
        private int myRepeats;

        Timer(Runnable listener, long start, long interval, int repeats, boolean dispatchOnEdt, boolean coalesce) {
            this.myListener = listener;
            this.myCoalesce = coalesce;
            this.myInterval = Math.max(interval, 20L);
            this.myNext = start + this.myInterval;
            this.myRepeats = repeats;
            this.myDispatchOnEdt = dispatchOnEdt;
        }

        boolean dispatch(long now) {
            do {
                this.myNext += this.myInterval;
            } while (this.myCoalesce && this.myNext <= now);
            if (this.myDispatchOnEdt) {
                EventQueue.invokeLater(this.myListener);
            } else {
                ThreadPool.getInstance().execute(this.myListener);
            }
            if (this.myRepeats > 1) {
                --this.myRepeats;
                return true;
            }
            return this.myRepeats == 0;
        }

        Runnable getListener() {
            return this.myListener;
        }

        long getNext() {
            return this.myNext;
        }

        void setNext(long next) {
            this.myNext = next;
        }
    }

    private final class TimerThread
    extends Thread {
        private boolean myIdle;

        TimerThread(String name) {
            super(name);
            this.setPriority(5);
            super.setDaemon(TimerService.this.myDaemon);
            this.start();
        }

        public void LOCK_wakeUp(boolean idle) {
            this.myIdle = idle;
            TimerService.this.myTimers.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long min = 10L;
            ArrayList<Timer> timers = new ArrayList<Timer>(10);
            while (true) {
                Long sleepUntil = null;
                List<Timer> list = TimerService.this.myTimers;
                synchronized (list) {
                    long sleep;
                    if (TimerService.this.myTimerThread != this) {
                        break;
                    }
                    if (TimerService.this.myShutdown || !this.myIdle && TimerService.this.myTimers.isEmpty()) {
                        TimerService.this.myTimerThread = null;
                        break;
                    }
                    this.myIdle = false;
                    timers.addAll(TimerService.this.myTimers);
                    long now = System.currentTimeMillis();
                    long dispatchLimit = now + 10L;
                    for (Timer timer : timers) {
                        boolean repeat = true;
                        long next = timer.getNext();
                        while (repeat && next <= dispatchLimit && TimerService.this.myTimers.contains(timer)) {
                            repeat = timer.dispatch(dispatchLimit);
                            next = timer.getNext();
                        }
                        if (repeat) {
                            if (sleepUntil != null && next >= sleepUntil) continue;
                            sleepUntil = next;
                            continue;
                        }
                        TimerService.this.myTimers.remove(timer);
                    }
                    timers.clear();
                    if (sleepUntil == null || TimerService.this.myTimers.isEmpty()) {
                        this.myIdle = false;
                        sleep = 2000L;
                    } else {
                        sleep = sleepUntil - System.currentTimeMillis();
                    }
                    if (sleep > 0L) {
                        try {
                            TimerService.this.myTimers.wait(sleep + min);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

