/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.xml;

import com.nokia.em.poseidon.util.xml.ObjectLoadException;
import java.awt.GridBagConstraints;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.table.JTableHeader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectLoader {
    Logger myLogger = Logger.getLogger(this.getClass());
    private String myObjectPackage;
    private Map<String, Class<?>> myTags = new LinkedHashMap();
    private Map<MethodInfo, Method> myMethodCache = new HashMap<MethodInfo, Method>();

    public ObjectLoader(String objectPackage) {
        this.myObjectPackage = objectPackage;
    }

    public void registerSwingTags() {
        this.registerTag("Applet", JApplet.class);
        this.registerTag("Button", JButton.class);
        this.registerTag("ButtonGroup", ButtonGroup.class);
        this.registerTag("Checkbox", JCheckBox.class);
        this.registerTag("CheckBoxMenuItem", JCheckBoxMenuItem.class);
        this.registerTag("ComboBox", JComboBox.class);
        this.registerTag("Component", JComponent.class);
        this.registerTag("DesktopPane", JDesktopPane.class);
        this.registerTag("Dialog", JDialog.class);
        this.registerTag("EditorPane", JEditorPane.class);
        this.registerTag("FormattedTextField", JFormattedTextField.class);
        this.registerTag("Frame", JFrame.class);
        this.registerTag("GridBagConstraints", GridBagConstraints.class);
        this.registerTag("InternalFrame", JInternalFrame.class);
        this.registerTag("Label", JLabel.class);
        this.registerTag("List", JList.class);
        this.registerTag("Menu", JMenu.class);
        this.registerTag("Menubar", JMenuBar.class);
        this.registerTag("Menuitem", JMenuItem.class);
        this.registerTag("Panel", JPanel.class);
        this.registerTag("PasswordField", JPasswordField.class);
        this.registerTag("PopupMenu", JPopupMenu.class);
        this.registerTag("ProgressBar", JProgressBar.class);
        this.registerTag("RadioButton", JRadioButton.class);
        this.registerTag("RadioButtonMenuItem", JRadioButtonMenuItem.class);
        this.registerTag("OptionPane", JOptionPane.class);
        this.registerTag("ScrollPane", JScrollPane.class);
        this.registerTag("Separator", JSeparator.class);
        this.registerTag("Slider", JSlider.class);
        this.registerTag("Spinner", JSpinner.class);
        this.registerTag("SplitPane", JSplitPane.class);
        this.registerTag("TabbedPane", JTabbedPane.class);
        this.registerTag("Table", JTable.class);
        this.registerTag("TableHeader", JTableHeader.class);
        this.registerTag("TextArea", JTextArea.class);
        this.registerTag("TextField", JTextField.class);
        this.registerTag("TextPane", JTextPane.class);
        this.registerTag("ToggleButton", JToggleButton.class);
        this.registerTag("Tree", JTree.class);
        this.registerTag("Toolbar", JToolBar.class);
    }

    public void registerTag(String tagName, Class<?> clazz) {
        this.myTags.put(tagName.toLowerCase(), clazz);
    }

    public Object loadObject(URL docURL) throws ObjectLoadException {
        Object loaded = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(docURL.toString());
            Element elmt = doc.getDocumentElement();
            loaded = this.loadFromElement(elmt);
        }
        catch (Exception ex) {
            throw new ObjectLoadException("Could not load objects from package " + this.myObjectPackage, ex);
        }
        if (loaded == null) {
            throw new ObjectLoadException("Could not load objects from package " + this.myObjectPackage);
        }
        return loaded;
    }

    public Object loadFromElement(Node element) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Object object = this.createObject(element);
            NodeList children = element.getChildNodes();
            HashMap childObjects = new HashMap();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Object childObj;
                    block14: {
                        childObj = null;
                        try {
                            childObj = this.loadFromElement(child);
                        }
                        catch (ClassNotFoundException cex) {
                            if (!this.isTextElement(child)) break block14;
                            childObj = child.getFirstChild().getNodeValue().trim();
                        }
                    }
                    if (childObj != null) {
                        if (childObj instanceof ButtonGroup) {
                            this.loadButtonGroup(object, (ButtonGroup)childObj);
                        } else {
                            Method addMethod = this.getMethod(object.getClass(), "add", childObj.getClass());
                            if (addMethod != null) {
                                try {
                                    addMethod.invoke(object, childObj);
                                }
                                catch (Exception e) {
                                    this.myLogger.error(e.getMessage());
                                }
                            } else {
                                ArrayList<Object> list = (ArrayList<Object>)childObjects.get(child.getNodeName());
                                if (list == null) {
                                    list = new ArrayList<Object>();
                                }
                                list.add(childObj);
                                childObjects.put(child.getNodeName(), list);
                            }
                        }
                    }
                }
                ++i;
            }
            this.setObjectProperties(object, childObjects);
            this.setAttributes(element, object);
            return object;
        }
        catch (NoSuchMethodException ex) {
            this.myLogger.error(ex.getMessage());
            return null;
        }
    }

    private void loadButtonGroup(Object object, ButtonGroup group) {
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            Method addMethod = this.getMethod(object.getClass(), "add", button.getClass());
            if (addMethod == null) continue;
            try {
                addMethod.invoke(object, button);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        this.myMethodCache.clear();
        this.myTags.clear();
    }

    private void setAttributes(Node element, Object object) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes == null) {
            return;
        }
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            String value = attr.getValue().trim();
            try {
                this.setObjectProperty(object, name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private Object createObject(Node elmt) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> objClass = this.myTags.get(elmt.getNodeName().toLowerCase());
        if (objClass == null) {
            String elmntName = elmt.getNodeName();
            elmntName = String.valueOf(elmntName.substring(0, 1).toUpperCase()) + elmntName.substring(1);
            objClass = Class.forName(String.valueOf(this.myObjectPackage) + "." + elmntName);
        }
        Constructor<?> constr = null;
        String[] params = null;
        if (this.isTextElement(elmt)) {
            Node child = elmt.getFirstChild();
            try {
                constr = objClass.getConstructor(String.class);
                params = new String[]{child.getNodeValue().trim()};
            }
            catch (NoSuchMethodException e) {
                constr = objClass.getConstructor(new Class[0]);
            }
        } else {
            constr = objClass.getConstructor(new Class[0]);
        }
        return constr.newInstance(params);
    }

    private boolean isTextElement(Node element) {
        Node child = element.getFirstChild();
        return child != null && child.getNodeType() == 3 && element.getChildNodes().getLength() == 1;
    }

    private void setObjectProperties(Object obj, Map<String, List<?>> childObjects) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Map.Entry<String, List<?>> entry2 = null;
        for (Map.Entry<String, List<?>> entry2 : childObjects.entrySet()) {
            String propName = entry2.getKey();
            List<?> objs = entry2.getValue();
            if (objs.size() == 1) {
                try {
                    this.setObjectProperty(obj, propName, objs.get(0));
                }
                catch (NoSuchMethodException ex) {
                    try {
                        this.setListProperty(obj, propName, objs);
                    }
                    catch (NoSuchMethodException nex) {
                        this.myLogger.error(nex);
                    }
                }
                catch (IllegalArgumentException exc) {
                    try {
                        this.setListProperty(obj, propName, objs);
                    }
                    catch (NoSuchMethodException nex) {
                        this.myLogger.error(nex);
                    }
                }
                continue;
            }
            this.setListProperty(obj, propName, objs);
        }
    }

    private void setListProperty(Object object, String propertyName, List value) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String setterName = propertyName.endsWith("y") ? String.valueOf(propertyName.substring(0, propertyName.length() - 1)) + "ies" : String.valueOf(propertyName) + "s";
        this.setObjectProperty(object, setterName, value);
    }

    private void setObjectProperty(Object obj, String name, Object value) throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method setter;
        Class<?> objClass = obj.getClass();
        Method getter = this.getGetter(objClass, name, null);
        Class<?> valueType = null;
        if (getter != null) {
            valueType = getter.getReturnType();
        }
        if ((setter = this.getSetter(objClass, name, valueType != null ? valueType : value.getClass())) == null) {
            throw new NoSuchMethodException("No setter method found for property " + name + " in class " + objClass);
        }
        if (valueType != null && valueType.isAssignableFrom(value.getClass())) {
            setter.invoke(obj, value);
        } else if (setter.getParameterTypes().length == 1 && setter.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
            setter.invoke(obj, value);
        } else if (valueType != null && valueType.isPrimitive()) {
            setter.invoke(obj, ObjectLoader.getObjectValue(valueType, value));
        } else if (valueType != null) {
            Class<?> constrClass = value.getClass();
            Object prop = valueType.getConstructor(constrClass).newInstance(value);
            setter.invoke(obj, prop);
        }
    }

    private static Object getObjectValue(Class<?> valueType, Object value) {
        if (valueType.equals(Integer.TYPE)) {
            return new Integer(value.toString());
        }
        if (valueType.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value.toString());
        }
        if (valueType.equals(Character.TYPE)) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (valueType.equals(Byte.TYPE)) {
            return new Byte(value.toString());
        }
        if (valueType.equals(Short.TYPE)) {
            return new Short(value.toString());
        }
        if (valueType.equals(Long.TYPE)) {
            return new Long(value.toString());
        }
        if (valueType.equals(Float.TYPE)) {
            return new Float(value.toString());
        }
        if (valueType.equals(Double.TYPE)) {
            return new Double(value.toString());
        }
        return null;
    }

    private Method getMethod(Class<?> clazz, String name, Class<?> parameterType) {
        MethodInfo methodInfo = new MethodInfo(clazz, name, parameterType);
        Method cachedMethod = this.myMethodCache.get(methodInfo);
        if (cachedMethod != null) {
            return cachedMethod;
        }
        try {
            Method method = clazz.getMethod(name, parameterType);
            this.myMethodCache.put(methodInfo, method);
            return method;
        }
        catch (NoSuchMethodException method) {
        }
        catch (SecurityException method) {
            // empty catch block
        }
        Method[] methods = clazz.getMethods();
        Method nameMatch = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase(name)) {
                nameMatch = method;
                if (this.methodHasMatchingParameter(method, parameterType)) {
                    this.myMethodCache.put(methodInfo, method);
                    return method;
                }
            }
            ++n2;
        }
        this.myMethodCache.put(methodInfo, nameMatch);
        return nameMatch;
    }

    private boolean methodHasMatchingParameter(Method method, Class<?> parameterType) {
        return parameterType == null || method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(parameterType);
    }

    private Method getGetter(Class<?> clazz, String name, Class<?> parameterType) {
        StringBuilder builder = new StringBuilder(name);
        char firstChar = Character.toUpperCase(builder.charAt(0));
        builder.delete(0, 1);
        builder.insert(0, firstChar);
        builder.insert(0, "get");
        Method getter = this.getMethod(clazz, builder.toString(), parameterType);
        if (getter != null) {
            return getter;
        }
        builder.replace(0, 3, "is");
        return this.getMethod(clazz, builder.toString(), parameterType);
    }

    private Method getSetter(Class<?> clazz, String name, Class<?> parameterType) {
        StringBuilder builder = new StringBuilder(name);
        char firstChar = Character.toUpperCase(builder.charAt(0));
        builder.delete(0, 1);
        builder.insert(0, firstChar);
        builder.insert(0, "set");
        return this.getMethod(clazz, builder.toString(), parameterType);
    }

    private static class MethodInfo {
        Class<?> myClazz;
        String myName;
        Class<?> myParamType;

        public MethodInfo(Class<?> clazz, String name, Class<?> parameterType) {
            this.myClazz = clazz;
            this.myName = name;
            this.myParamType = parameterType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myClazz == null ? 0 : this.myClazz.hashCode());
            result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
            result = 31 * result + (this.myParamType == null ? 0 : this.myParamType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodInfo other = (MethodInfo)obj;
            if (this.myClazz == null ? other.myClazz != null : !this.myClazz.equals(other.myClazz)) {
                return false;
            }
            if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
                return false;
            }
            return !(this.myParamType == null ? other.myParamType != null : !this.myParamType.equals(other.myParamType));
        }
    }
}

