/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.xml;

import com.nokia.em.poseidon.util.file.PFileOutputStream;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public final class XmlUtils
implements ErrorHandler {
    private static final String DEFAULT_ENCODING = "ISO-8859-15";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final int ONE_BYTE = 1;
    private static XmlUtils theInstance;
    private boolean myErrorOccurred = false;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public static XmlUtils getInstance() {
        if (theInstance != null) {
            return theInstance;
        }
        theInstance = new XmlUtils();
        return theInstance;
    }

    private XmlUtils() {
    }

    public Document parseDoc(InputStream stream) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
            docBF.setNamespaceAware(true);
            docBF.setValidating(false);
            DocumentBuilder docBuilder = docBF.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (systemId.indexOf(".dtd") > 0) {
                        return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                    }
                    return null;
                }
            });
            doc = docBuilder.parse(stream);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            this.myLogger.error("Failed to parse file <" + stream + "> to xml document.", e);
        }
        return doc;
    }

    public Document parseDoc(String document, String schemaLocation) {
        InputSource i = new InputSource(new ByteArrayInputStream(document.getBytes()));
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        docBF.setNamespaceAware(true);
        docBF.setValidating(true);
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBF.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            docBF.setAttribute(JAXP_SCHEMA_SOURCE, schemaLocation);
            docBuilder = docBF.newDocumentBuilder();
            docBuilder.setErrorHandler(this);
            doc = docBuilder.parse(i);
        }
        catch (Exception x) {
            this.myLogger.error("Could not parse document: " + document + " error: " + x);
            doc = null;
        }
        if (this.myErrorOccurred) {
            doc = null;
        }
        this.myErrorOccurred = false;
        return doc;
    }

    public Document createDoc() {
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilder = docBF.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (Exception x) {
            this.myLogger.error(" error: " + x);
            doc = null;
        }
        return doc;
    }

    public String getAttributeValue(Node node, String attributeName) {
        if (node.hasAttributes()) {
            NamedNodeMap map = node.getAttributes();
            Node attribute = null;
            if (map != null) {
                attribute = map.getNamedItem(attributeName);
            }
            if (attribute != null) {
                return attribute.getNodeValue();
            }
        }
        return null;
    }

    public Node makeNode(Document doc, Node parentNode, String strElement, String strValue) {
        Node node = parentNode.appendChild(doc.createElement(strElement));
        node.appendChild(doc.createTextNode(strValue));
        return node;
    }

    public String getNodeValue(Node nodeParent, String strNodeName) {
        NodeList children = nodeParent.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = children.item(i);
            if (n.getNodeName().equalsIgnoreCase(strNodeName) && n.hasChildNodes()) {
                String retVal = n.getFirstChild().getNodeValue();
                return retVal;
            }
            ++i;
        }
        return "";
    }

    public Node getNode(Node parentNode, String strNodeName) {
        NodeList children = parentNode.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node n = children.item(i);
            if (n.getNodeName().equalsIgnoreCase(strNodeName)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public static String getValue(Node node, String key) {
        String value = node.getTextContent().trim();
        return XmlUtils.getValue(value, key);
    }

    public static String getValue(String values, String key) {
        if (values != null) {
            String[] entries;
            String[] stringArray = entries = values.split(";");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                String[] keyValuePair = entry.split("=");
                if (keyValuePair.length > 1 && keyValuePair[0].equals(key)) {
                    return keyValuePair[1];
                }
                ++n2;
            }
        }
        return "";
    }

    @Override
    public void warning(SAXParseException exception) {
        if (!this.myErrorOccurred) {
            this.myLogger.warn("Warning when parsing message: " + exception);
            this.myErrorOccurred = true;
        }
    }

    @Override
    public void error(SAXParseException exception) {
        if (!this.myErrorOccurred) {
            this.myLogger.error("Error parsing message: " + exception);
            this.myErrorOccurred = true;
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        if (!this.myErrorOccurred) {
            this.myLogger.error("Fatal error parsing message: " + exception);
            this.myErrorOccurred = true;
        }
    }

    public Node makeEmptyNode(Document doc, Node parentNode, String strNodeName) {
        Node newNode = parentNode.appendChild(doc.createElement(strNodeName.trim()));
        return newNode;
    }

    public void writeDocToStream(OutputStream output, Document doc) throws TransformerException, IOException {
        Transformer transformer = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamResult myResult = new StreamResult(output);
        transformer = tFactory.newTransformer();
        transformer.setOutputProperty("encoding", DEFAULT_ENCODING);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, myResult);
        output.flush();
    }

    public void writeDocToFile(File destFile, Document docTobeWritten) throws TransformerException, IOException {
        try (PFileOutputStream outStream = null;){
            DiskSpaceChecker.checkDiskSpaceException(destFile, 1L);
            outStream = new PFileOutputStream(destFile);
            this.writeDocToStream(outStream, docTobeWritten);
        }
    }

    public static String encode(String toEncode) {
        String result = toEncode.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        return result.replace("'", "&apos;");
    }
}

