/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.api.scripting;

import java.util.ArrayList;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.runtime.ECMAErrors;

public abstract class NashornException
extends RuntimeException {
    private final String fileName;
    private final int line;
    private final int column;
    public static final String ENGINE_SCRIPT_SOURCE_NAME = "nashorn:engine/resources/engine.js";

    protected NashornException(String msg, String fileName, int line, int column) {
        this(msg, null, fileName, line, column);
    }

    protected NashornException(String msg, Throwable cause, String fileName, int line, int column) {
        super(msg, cause == null ? null : cause);
        this.fileName = fileName;
        this.line = line;
        this.column = column;
    }

    protected NashornException(String msg, Throwable cause) {
        super(msg, cause == null ? null : cause);
        this.column = -1;
        for (StackTraceElement ste : this.getStackTrace()) {
            if (!ECMAErrors.isScriptFrame(ste)) continue;
            this.fileName = ste.getFileName();
            this.line = ste.getLineNumber();
            return;
        }
        this.fileName = null;
        this.line = 0;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.line;
    }

    public final int getColumnNumber() {
        return this.column;
    }

    public static StackTraceElement[] getScriptFrames(Throwable exception) {
        StackTraceElement[] frames = exception.getStackTrace();
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>();
        for (StackTraceElement st : frames) {
            if (!ECMAErrors.isScriptFrame(st)) continue;
            String className = "<" + st.getFileName() + ">";
            String methodName = st.getMethodName();
            if (methodName.equals(CompilerConstants.RUN_SCRIPT.symbolName())) {
                methodName = "<program>";
            }
            filtered.add(new StackTraceElement(className, methodName, st.getFileName(), st.getLineNumber()));
        }
        return filtered.toArray(new StackTraceElement[filtered.size()]);
    }

    public static String getScriptStackString(Throwable exception) {
        StackTraceElement[] frames;
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement st : frames = NashornException.getScriptFrames(exception)) {
            buf.append("\tat ");
            buf.append(st.getMethodName());
            buf.append(" (");
            buf.append(st.getFileName());
            buf.append(':');
            buf.append(st.getLineNumber());
            buf.append(")\n");
        }
        int len = buf.length();
        if (len > 0) {
            assert (buf.charAt(len - 1) == '\n');
            buf.deleteCharAt(len - 1);
        }
        return buf.toString();
    }
}

