/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import jdk.nashorn.internal.codegen.CodeGenerator;
import jdk.nashorn.internal.codegen.Condition;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.UnaryNode;

final class BranchOptimizer {
    private final CodeGenerator codegen;
    private final MethodEmitter method;

    BranchOptimizer(CodeGenerator codegen, MethodEmitter method) {
        this.codegen = codegen;
        this.method = method;
    }

    void execute(Expression node, Label label, boolean state) {
        this.branchOptimizer(node, label, state);
    }

    private void branchOptimizer(UnaryNode unaryNode, Label label, boolean state) {
        Expression rhs = unaryNode.rhs();
        switch (unaryNode.tokenType()) {
            case NOT: {
                this.branchOptimizer(rhs, label, !state);
                return;
            }
        }
        if (unaryNode.getType().isBoolean()) {
            this.branchOptimizer(rhs, label, state);
            return;
        }
        this.codegen.load(unaryNode, Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }

    private void branchOptimizer(BinaryNode binaryNode, Label label, boolean state) {
        Expression lhs = binaryNode.lhs();
        Expression rhs = binaryNode.rhs();
        switch (binaryNode.tokenType()) {
            case AND: {
                if (state) {
                    Label skip = new Label("skip");
                    this.branchOptimizer(lhs, skip, false);
                    this.branchOptimizer(rhs, label, true);
                    this.method.label(skip);
                } else {
                    this.branchOptimizer(lhs, label, false);
                    this.branchOptimizer(rhs, label, false);
                }
                return;
            }
            case OR: {
                if (state) {
                    this.branchOptimizer(lhs, label, true);
                    this.branchOptimizer(rhs, label, true);
                } else {
                    Label skip = new Label("skip");
                    this.branchOptimizer(lhs, skip, true);
                    this.branchOptimizer(rhs, label, false);
                    this.method.label(skip);
                }
                return;
            }
            case EQ: 
            case EQ_STRICT: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.EQ : Condition.NE, true, label);
                return;
            }
            case NE: 
            case NE_STRICT: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.NE : Condition.EQ, true, label);
                return;
            }
            case GE: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.GE : Condition.LT, !state, label);
                return;
            }
            case GT: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.GT : Condition.LE, !state, label);
                return;
            }
            case LE: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.LE : Condition.GT, state, label);
                return;
            }
            case LT: {
                this.codegen.loadBinaryOperands(lhs, rhs, Type.widest(lhs.getType(), rhs.getType()));
                this.method.conditionalJump(state ? Condition.LT : Condition.GE, state, label);
                return;
            }
        }
        this.codegen.load(binaryNode, Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }

    private void branchOptimizer(Expression node, Label label, boolean state) {
        if (!(node instanceof TernaryNode)) {
            if (node instanceof BinaryNode) {
                this.branchOptimizer((BinaryNode)node, label, state);
                return;
            }
            if (node instanceof UnaryNode) {
                this.branchOptimizer((UnaryNode)node, label, state);
                return;
            }
        }
        this.codegen.load(node, Type.BOOLEAN);
        if (state) {
            this.method.ifne(label);
        } else {
            this.method.ifeq(label);
        }
    }
}

