/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.FunctionCall;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyKey;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class IdentNode
extends Expression
implements PropertyKey,
FunctionCall {
    private static final int PROPERTY_NAME = 1;
    private static final int INITIALIZED_HERE = 2;
    private static final int FUNCTION = 4;
    private static final int FUTURESTRICT_NAME = 8;
    private final String name;
    private final Type callSiteType;
    private final int flags;

    public IdentNode(long token, int finish, String name) {
        super(token, finish);
        this.name = name.intern();
        this.callSiteType = null;
        this.flags = 0;
    }

    private IdentNode(IdentNode identNode, String name, Type callSiteType, int flags) {
        super(identNode);
        this.name = name;
        this.callSiteType = callSiteType;
        this.flags = flags;
    }

    public IdentNode(IdentNode identNode) {
        super(identNode);
        this.name = identNode.getName();
        this.callSiteType = null;
        this.flags = identNode.flags;
    }

    @Override
    public Type getType() {
        return this.callSiteType == null ? super.getType() : this.callSiteType;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    private boolean hasCallSiteType() {
        return this.callSiteType != null;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterIdentNode(this)) {
            return visitor.leaveIdentNode(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.hasCallSiteType()) {
            sb.append('{');
            String desc = this.getType().getDescriptor();
            sb.append(desc.charAt(desc.length() - 1) == ';' ? Character.valueOf('O') : this.getType().getDescriptor());
            sb.append('}');
        }
        sb.append(this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public boolean isLocal() {
        return !this.getSymbol().isScope();
    }

    public boolean isPropertyName() {
        return (this.flags & 1) != 0;
    }

    public IdentNode setIsPropertyName() {
        if (this.isPropertyName()) {
            return this;
        }
        return new IdentNode(this, this.name, this.callSiteType, this.flags | 1);
    }

    public boolean isFutureStrictName() {
        return (this.flags & 8) != 0;
    }

    public IdentNode setIsFutureStrictName() {
        if (this.isFutureStrictName()) {
            return this;
        }
        return new IdentNode(this, this.name, this.callSiteType, this.flags | 8);
    }

    public boolean isInitializedHere() {
        return (this.flags & 2) != 0;
    }

    public IdentNode setIsInitializedHere() {
        if (this.isInitializedHere()) {
            return this;
        }
        return new IdentNode(this, this.name, this.callSiteType, this.flags | 2);
    }

    public boolean isSpecialIdentity() {
        return this.name.equals(CompilerConstants.__DIR__.symbolName()) || this.name.equals(CompilerConstants.__FILE__.symbolName()) || this.name.equals(CompilerConstants.__LINE__.symbolName());
    }

    @Override
    public boolean isFunction() {
        return (this.flags & 4) != 0;
    }

    public IdentNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new IdentNode(this, this.name, this.callSiteType, this.flags | 4);
    }
}

