/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.TreeSet;
import jdk.nashorn.internal.runtime.CompiledFunction;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptFunctionData;

final class CompiledFunctions
extends TreeSet<CompiledFunction> {
    private CompiledFunction generic;

    CompiledFunctions() {
    }

    CompiledFunction best(MethodType type) {
        for (CompiledFunction next : this) {
            if (!next.typeCompatible(type)) continue;
            return next;
        }
        return this.generic();
    }

    boolean needsCallee() {
        return ScriptFunctionData.needsCallee(this.mostGeneric().getInvoker());
    }

    CompiledFunction mostGeneric() {
        return (CompiledFunction)this.last();
    }

    CompiledFunction generic() {
        CompiledFunction gen = this.generic;
        if (gen == null) {
            gen = this.generic = CompiledFunctions.makeGeneric(this.mostGeneric());
        }
        return gen;
    }

    private static CompiledFunction makeGeneric(CompiledFunction func) {
        MethodHandle invoker = CompiledFunctions.composeGenericMethod(func.getInvoker());
        MethodHandle constructor = func.hasConstructor() ? CompiledFunctions.composeGenericMethod(func.getConstructor()) : null;
        return new CompiledFunction(invoker.type(), invoker, constructor);
    }

    private static MethodHandle composeGenericMethod(MethodHandle mh) {
        MethodType type = mh.type();
        boolean isVarArg = ScriptFunctionData.isVarArg(mh);
        int paramCount = isVarArg ? type.parameterCount() - 1 : type.parameterCount();
        MethodType newType = MethodType.genericMethodType(paramCount, isVarArg);
        if (ScriptFunctionData.needsCallee(mh)) {
            newType = newType.changeParameterType(0, ScriptFunction.class);
        }
        return type.equals((Object)newType) ? mh : mh.asType(newType);
    }

    boolean isLessSpecificThan(MethodType type) {
        return this.best(type).moreGenericThan(type);
    }
}

