/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.LogWriter;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.PoseidonStarter;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.logging.TruncatingFileAppender;
import com.nokia.widgets.util.SystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.fusesource.jansi.AnsiConsole;

public class CoreAssetToolApplication {
    private static final int LOG_SEARCH_BUFFER_SIZE = 1000;
    private static final int LOG_SAMPLE_SIZE = 10;
    private static final int LOG_MAX_FILE_COUNT = 100;
    private static final int LOG_MAX_BACKUPS = 3;
    private static final String LOG_CUT_STOP = "50";
    private static final String LOG_CUT_START = "10";
    private static final String LOG_SIZE = "10MB";
    private static final String LOG_FILENAME = "Tool.log";
    private static final String LOG_PATTERN = "%d{yyyy-MM-dd'T'HH:mm:ss.SSS'Z'}{UTC} [%t] [%c] [%p] %m%n%n";
    private static final String ARG_DEBUG = "debug";
    private static final String ARG_NOLOG = "nolog";
    private static final String ARG_OP = "op";
    private static final String ARG_OUTPUT = "output";
    private static final String LANGUAGE_EN = "en";
    private static final String COUNTRY_US = "US";
    private static final String USER_LANGUAGE = "user.language";
    private static final String USER_COUNTRY = "user.country";
    private static final String ACCEPT_UNSECURE_CONN = "acceptUnsecureConn";
    private static final String ACCEPT_ALL_CERTS = "acceptAllCerts";
    private static final String HTTPS_PROTOCOLS = "https.protocols";
    private static final String HTTPS_CIPHER_SUITES = "https.cipherSuites";
    private static final String SUPPORTED_TLS_VERSIONS = "TLSv1.2,TLSv1";
    private static final String SUPPORTED_CIPHER_SUITES = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384,TLS_DHE_RSA_WITH_AES_256_CBC_SHA256,TLS_DHE_RSA_WITH_AES_256_CBC_SHA,TLS_RSA_WITH_AES_256_GCM_SHA384,TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_RSA_WITH_AES_256_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_GCM_SHA256,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256,TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA,SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA,SSL_RSA_WITH_RC4_128_SHA";

    public static void main(String[] args) {
        new CoreAssetToolApplication(args);
    }

    public CoreAssetToolApplication(String[] args) {
        PCmdLineParams params = new PCmdLineParams(args);
        this.initLogger(params);
        Logger.getLogger(this.getClass()).info((Object)Arrays.toString(args));
        System.setProperty(HTTPS_PROTOCOLS, com.nokia.em.poseidon.comm.http.Tools.getSupportedProtocols((String)SUPPORTED_TLS_VERSIONS));
        System.setProperty(HTTPS_CIPHER_SUITES, com.nokia.em.poseidon.comm.http.Tools.getSupportedCipherSuites((String)SUPPORTED_CIPHER_SUITES));
        System.setProperty(USER_COUNTRY, COUNTRY_US);
        System.setProperty(USER_LANGUAGE, LANGUAGE_EN);
        AnsiConsole.systemInstall();
        this.initLogWriter(params);
        OperationResult result = new OperationResult();
        try {
            PoseidonStarter.init((PCmdLineParams)params);
            PoseidonRuntime.getRuntime().getParameters().storeParamValues(ACCEPT_ALL_CERTS, null);
            PoseidonRuntime.getRuntime().getParameters().storeParamValues(ACCEPT_UNSECURE_CONN, null);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Problem occurred while initializing Poseidon", (Throwable)e);
        }
        if (!SystemUtils.isAfterJava16()) {
            Console.warn("Java runtime version 7 or newer recommended");
        }
        String op = "tool";
        try {
            if (args != null) {
                op = params.getFirstValue(ARG_OP);
                Operations operation = Operations.valueOf(op.toUpperCase());
                if (operation.getTool() != null) {
                    result = CoreAssetToolApplication.getToolImpl(op).execute(null, params);
                } else {
                    Console.error("Operation " + op + " not supported");
                    result.setExitCode(2);
                }
            } else {
                Console.error("Missing operation");
                result.setExitCode(2);
            }
        }
        catch (Exception e) {
            Console.error("Failed to launch " + op, e);
            result.setExitCode(2);
        }
        this.checkFileSystem();
        int exitCode = result.getExitCode();
        Console.info(this.getOperationsFinishedText(exitCode));
        System.exit(exitCode);
    }

    private void checkFileSystem() {
        block6: {
            File file = null;
            File tempFile = null;
            try {
                try {
                    file = File.createTempFile("cli", ".tmp", new File(System.getProperty("user.dir")));
                    tempFile = File.createTempFile("cli", ".tmp");
                    if (file.getUsableSpace() < 0x100000L || tempFile.getUsableSpace() < 0x100000L) {
                        Console.warn("The file system has very low available disk space");
                    }
                }
                catch (Exception e) {
                    Console.warn("The tool doesn't have write access to the working directory and/or default temporary folder", e);
                    Console.warn("If you encounter any problems, check tool's access rights");
                    Tools.deleteFile((File)file);
                    Tools.deleteFile(tempFile);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Tools.deleteFile(file);
                Tools.deleteFile(tempFile);
                throw throwable;
            }
            Tools.deleteFile((File)file);
            Tools.deleteFile((File)tempFile);
        }
    }

    private void initLogger(PCmdLineParams params) {
        if (params.isDefined(ARG_NOLOG)) {
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        } else {
            TruncatingFileAppender appender = new TruncatingFileAppender();
            appender.setFile(LOG_FILENAME);
            appender.setLayout((Layout)new EnhancedPatternLayout(LOG_PATTERN));
            appender.setMaxFileSize(LOG_SIZE);
            appender.setStartCutPercentage(LOG_CUT_START);
            appender.setStopCutPercentage(LOG_CUT_STOP);
            appender.setMaxBackupIndex(3);
            appender.setSearchBufferSize(1000);
            appender.setSampleSize(10);
            appender.setMaxLogFileCount(100);
            appender.activateOptions();
            Logger.getRootLogger().setLevel(params.isDefined(ARG_DEBUG) ? Level.ALL : Level.DEBUG);
            Logger.getRootLogger().addAppender((Appender)appender);
        }
    }

    private void initLogWriter(PCmdLineParams params) {
        PoseidonRuntime.getRuntime().addObject((Object)new LogWriter(params.getFirstValue(ARG_OUTPUT), false));
    }

    private String getOperationsFinishedText(int exitCode) {
        return "Operations finished " + (exitCode == 0 ? "successfully" : "with error code " + exitCode);
    }

    public static ToolImpl getToolImpl(String tool) {
        String className = "";
        try {
            className = Operations.valueOf(tool.toUpperCase()).getTool();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String output = PoseidonRuntime.getRuntime().getParameters().getFirstValue(ARG_OUTPUT);
        if (output == null) {
            output = "";
        }
        try {
            return (ToolImpl)Class.forName("com.nokia.em.bts.coreasset.application.tools." + className).getConstructor(output.getClass()).newInstance(output);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<String> getSupportedTools() {
        ArrayList<String> tools = new ArrayList<String>();
        tools.add(Operations.BATCH.toString().toLowerCase());
        tools.add(Operations.BLOCK.toString().toLowerCase());
        tools.add(Operations.BLOCKCELL.toString().toLowerCase());
        tools.add(Operations.BLOCKUNIT.toString().toLowerCase());
        tools.add(Operations.CALIBRATETILT.toString().toLowerCase());
        tools.add(Operations.CHANGESECURITY.toString().toLowerCase());
        tools.add(Operations.CHANGERADPARAMS.toString().toLowerCase());
        tools.add(Operations.CHECKALARMS.toString().toLowerCase());
        tools.add(Operations.CHECKLINKSTATUS.toString().toLowerCase());
        tools.add(Operations.COLLECTFILES.toString().toLowerCase());
        tools.add(Operations.COMMISSIONING.toString().toLowerCase());
        tools.add(Operations.CONFIGURETILT.toString().toLowerCase());
        tools.add(Operations.GETACTIVEALARMS.toString().toLowerCase());
        tools.add(Operations.GETALARMHISTORY.toString().toLowerCase());
        tools.add(Operations.GETCONFIG.toString().toLowerCase());
        tools.add(Operations.GETGPSSTATUS.toString().toLowerCase());
        tools.add(Operations.GETSUPPORTPOWER.toString().toLowerCase());
        tools.add(Operations.GETSWVERSIONS.toString().toLowerCase());
        tools.add(Operations.GETTILTS.toString().toLowerCase());
        tools.add(Operations.IPTEST.toString().toLowerCase());
        tools.add(Operations.RESET.toString().toLowerCase());
        tools.add(Operations.RESETCELL.toString().toLowerCase());
        tools.add(Operations.RESETUNIT.toString().toLowerCase());
        tools.add(Operations.RFTEST.toString().toLowerCase());
        tools.add(Operations.SETMECHANICALTILT.toString().toLowerCase());
        tools.add(Operations.SETTILT.toString().toLowerCase());
        tools.add(Operations.SETTILTRANGE.toString().toLowerCase());
        tools.add(Operations.SWUPDATE.toString().toLowerCase());
        tools.add(Operations.UNBLOCK.toString().toLowerCase());
        tools.add(Operations.UNBLOCKCELL.toString().toLowerCase());
        tools.add(Operations.UNBLOCKUNIT.toString().toLowerCase());
        tools.add(Operations.GETACNONOP.toString().toLowerCase());
        tools.add(Operations.SETACNONOP.toString().toLowerCase());
        tools.add(Operations.CHANGENTP.toString().toLowerCase());
        tools.add(Operations.GETRADPARAMS.toString().toLowerCase());
        return tools;
    }

    static enum Operations {
        RESET("ResetImpl"),
        RESETUNIT("ResetUnitImpl"),
        RESETCELL("ResetCellImpl"),
        BLOCKCELL("BlockCellImpl"),
        UNBLOCKCELL("UnblockCellImpl"),
        COLLECTFILES("FileCollectorImpl"),
        SWUPDATE("SWUpdateImpl"),
        COMMISSIONING("CommissioningImpl"),
        BLOCK("BlockImpl"),
        UNBLOCK("UnblockImpl"),
        CHANGESECURITY("EthernetSecurityImpl"),
        BATCH("BatchImpl"),
        CHECKALARMS("CheckAlarmsImpl"),
        CHECKLINKSTATUS("TransmissionStatusImpl"),
        GETSUPPORTPOWER("RFMaximumOutputPowerImpl"),
        GETSWVERSIONS("GetSwVersions"),
        GETCONFIG("GetCommissioningFile"),
        GETALARMHISTORY("GetAlarmHistory"),
        GETGPSSTATUS("GetGPSStatus"),
        GETACTIVEALARMS("CheckAlarmsImpl"),
        CHANGERADPARAMS("ChangeRADParamsImpl"),
        GETRADPARAMS("GetRADParamsImpl"),
        BLOCKUNIT("BlockUnitImpl"),
        UNBLOCKUNIT("UnblockUnitImpl"),
        REMOTE("RemoteImpl"),
        CONSOLE("ConsoleImpl"),
        RFTEST("RFTestImpl"),
        IPTEST("IPTestImpl"),
        CALIBRATETILT("CalibrateTiltImpl"),
        CONFIGURETILT("ConfigureTiltImpl"),
        SETTILT("SetTiltImpl"),
        SETTILTRANGE("SetTiltRangeImpl"),
        GETTILTS("GetTiltsImpl"),
        SETMECHANICALTILT("SetMechanicalTiltImpl"),
        ACBARRING("ACBarringImpl"),
        SETVSWR("SetVSWRThresholdImpl"),
        STARTTUNING("StartVSWRTuningImpl"),
        STOPTUNING("StopVSWRTuningImpl"),
        TESTMODEL("TestModelImpl"),
        BLOCKFAULTS("BlockFaultsImpl"),
        GETACNONOP("GetNonOpBackhaulImpl"),
        SETACNONOP("SetNonOpBackhaulImpl"),
        CHANGENTP("ChangeNTPAddrImpl"),
        RFMONITORING("RFMonitoringImpl"),
        ROLLBACKTOPASSIVESW("RollbackToPassiveSWImpl"),
        SSHSERVICE("SshServiceImpl");

        private String myTool;

        private Operations(String tool) {
            this.myTool = tool;
        }

        public String getTool() {
            return this.myTool;
        }
    }
}

