/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.telnet;

import com.nokia.em.bts.coreasset.application.telnet.OperationTelnetClient;
import com.nokia.em.bts.coreasset.application.telnet.OperationTelnetListener;
import com.nokia.em.bts.coreasset.application.telnet.TelnetException;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;

public class OperationTelnetClientImpl
implements OperationTelnetClient {
    private TelnetOutputStream myTelnetOutputStream;
    private TelnetInputStream myTelnetInputStream;
    private Socket mySocket;
    private boolean read;
    private StringBuffer myReceivedMessage = new StringBuffer();
    private final Logger myLogger;
    private String sentMessage = "";
    private MessageTimerListener myMessageListener;
    private List<OperationTelnetListener> myListeners = new ArrayList<OperationTelnetListener>();

    public OperationTelnetClientImpl() {
        this.myMessageListener = new MessageTimerListener();
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public void open(String serverAddress) throws TelnetException {
        this.open(serverAddress, 23);
    }

    @Override
    public void open(String serverAddress, int serverPort) throws TelnetException {
        try {
            this.mySocket = new Socket(serverAddress, serverPort);
            this.myTelnetOutputStream = new TelnetOutputStream(this.mySocket.getOutputStream(), false);
            this.myTelnetInputStream = new TelnetInputStream(this.mySocket.getInputStream(), false);
            if (!this.read) {
                this.read();
            }
        }
        catch (UnknownHostException e) {
            this.myLogger.debug((Object)"Failed to create Socket or TelnetOutputStream, Unknown host");
            throw new TelnetException("Failed to open Telnet connection.");
        }
        catch (IOException e) {
            this.myLogger.debug((Object)"Failed to create Socket or TelnetOutputStream, IOException");
            throw new TelnetException("Failed to open Telnet connection.");
        }
    }

    @Override
    public void close() throws TelnetException {
        this.read = false;
        if (this.myTelnetOutputStream != null) {
            try {
                this.myLogger.debug((Object)"Closing Telnet connection.");
                this.myTelnetOutputStream.close();
                this.myTelnetInputStream.close();
                this.mySocket.close();
                this.myListeners.clear();
            }
            catch (IOException e) {
                this.myLogger.debug((Object)"Failed to close Telnet connection");
                throw new TelnetException("Failed to close Telnet connection.");
            }
        }
    }

    @Override
    public void send(String command) throws TelnetException {
        this.sentMessage = command;
        if (this.myTelnetOutputStream != null) {
            try {
                this.myLogger.debug((Object)("SENT to Telnet: " + command));
                this.myTelnetOutputStream.write(command.getBytes());
                this.myTelnetOutputStream.write(10);
                this.myTelnetOutputStream.flush();
            }
            catch (IOException e) {
                this.myLogger.debug((Object)("Failed to write command " + command + "to TelnetOutputStream"));
                throw new TelnetException("Failed to send command.");
            }
        }
    }

    private void read() {
        this.read = true;
        Thread readThread = new Thread("TelnetClientRead"){

            @Override
            public void run() {
                OperationTelnetClientImpl.this.myReceivedMessage.setLength(0);
                while (OperationTelnetClientImpl.this.read) {
                    try {
                        char character = '\u0000';
                        if (OperationTelnetClientImpl.this.myTelnetInputStream != null && OperationTelnetClientImpl.this.myTelnetInputStream.available() > 0) {
                            character = (char)OperationTelnetClientImpl.this.myTelnetInputStream.read();
                        }
                        if (character <= '\u0000') continue;
                        TimerService.getInstance().startTimer((ActionListener)OperationTelnetClientImpl.this.myMessageListener, 1000L);
                        OperationTelnetClientImpl.this.myReceivedMessage.append(character);
                    }
                    catch (IOException e) {
                        OperationTelnetClientImpl.this.myLogger.debug((Object)"Failure in read.", (Throwable)e);
                    }
                }
            }
        };
        readThread.start();
    }

    @Override
    public void addTelnetListener(OperationTelnetListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeTelnetListener(OperationTelnetListener listener) {
        if (this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    @Override
    public String getPCIPAddress() {
        return this.mySocket.getLocalAddress().getHostAddress();
    }

    @Override
    public boolean isConnected() {
        return this.mySocket.isConnected();
    }

    class MessageTimerListener
    implements ActionListener {
        MessageTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TimerService.getInstance().stopTimer((ActionListener)OperationTelnetClientImpl.this.myMessageListener);
            String message = OperationTelnetClientImpl.this.myReceivedMessage.toString();
            if (message != null && !message.equals("")) {
                message = message.trim();
                if (!OperationTelnetClientImpl.this.sentMessage.equals(message)) {
                    OperationTelnetClientImpl.this.myLogger.debug((Object)("RECEIVED from Telnet: " + message));
                    try {
                        for (OperationTelnetListener listener : OperationTelnetClientImpl.this.myListeners) {
                            listener.messageReceived(message);
                        }
                    }
                    catch (Exception e) {
                        OperationTelnetClientImpl.this.myLogger.debug((Object)"Exception while informing listeners", (Throwable)e);
                    }
                    OperationTelnetClientImpl.this.myReceivedMessage.setLength(0);
                } else {
                    OperationTelnetClientImpl.this.myLogger.debug((Object)("RECEIVED just echo from Telnet: " + message));
                }
            }
        }
    }
}

