/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.BatchResults;
import com.nokia.em.bts.coreasset.application.tools.BatchSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchImpl
extends ToolImpl {
    private static final String N_A = "N/A";
    private List<BatchResults> myResults = new ArrayList<BatchResults>();

    public BatchImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Batch";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "Batch";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((BatchResults)result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    @Override
    public String getShortResult() {
        return N_A;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new BatchSingle();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        this.generateToolColumnsTo(table);
    }

    private void generateToolColumnsTo(ToolSummaryTable table) {
        for (BatchResults result : this.myResults) {
            this.generateToolColumns(table, result.getTools());
        }
    }

    private void generateToolColumns(ToolSummaryTable table, Map<String, String> tools) {
        for (Map.Entry<String, String> entry : tools.entrySet()) {
            String tool = entry.getKey();
            if (table.hasColumn(tool)) continue;
            table.addColumn(tool);
        }
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (BatchResults br : this.myResults) {
            this.generateRow(table, br);
        }
    }

    private void generateRow(ToolSummaryTable table, BatchResults results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, BatchResults results) {
        values.add(results.getOperationalState());
        for (Map.Entry<String, String> entry : results.getTools().entrySet()) {
            values.add(entry.getValue());
        }
    }
}

