/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.BatchImpl;
import com.nokia.em.bts.coreasset.application.tools.BatchOperation;
import com.nokia.em.bts.coreasset.application.tools.BatchResults;
import com.nokia.em.bts.coreasset.application.tools.ConsoleImpl;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RemoteImpl;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchSingle
extends ToolBase {
    private static final String COMMENT_PREFIX = "#";
    private static final String RESULT_UNKNOWN = "Unknown";
    private static final String ARG_BATCH_FILE = "batchfile";
    private List<BatchOperation> myOperations;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        BatchResults result = new BatchResults(btsInformation.getBTSAddress());
        String batchFile = args.getFirstValue(ARG_BATCH_FILE);
        if (batchFile == null || !new File(batchFile).exists()) {
            Console.error("Invalid or Missing parameter batchfile");
            result.setExitCode(3);
            return result;
        }
        this.myOperations = this.readOperations(args.getFirstValue(ARG_BATCH_FILE));
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        String address = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        if (this.myOperations.size() == 0) {
            Console.error("No tools found for " + address + ". Check batch file.");
            result.setOK(false);
            result.setExitCode(35);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(address, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            connectionInfo.setSite(this.buildHWModel(connectionInfo.getConnection()));
            result.setOperationalState(this.getOperationalStateText(connectionInfo.getSite()));
            LinkedHashMap<String, String> tools = new LinkedHashMap<String, String>();
            int exitCode = 0;
            for (BatchOperation operation : this.myOperations) {
                ToolImpl tool = operation.getTool();
                operation.addParams(args);
                if (tool != null) {
                    if (tool instanceof BatchImpl || tool instanceof ConsoleImpl || tool instanceof RemoteImpl) {
                        tools.put(tool.getName(), tool.getShortResult());
                        continue;
                    }
                    if (connectionInfo.getConnection().isBTSConnected()) {
                        int toolExitCode = tool.execute(connectionInfo, operation.getParams()).getExitCode();
                        if (toolExitCode != 0) {
                            exitCode = this.myOperations.size() > 1 ? 1 : toolExitCode;
                        }
                        tools.put(tool.getName(), tool.getShortResult());
                        continue;
                    }
                    Console.error("Connection lost to " + address + ". Failed to run " + tool.getName() + " Tool.");
                    tools.put(tool.getName(), RESULT_UNKNOWN);
                    exitCode = 1;
                    continue;
                }
                Console.error("Failed to run unsupported tool (" + operation.getTool() + ") to " + address);
                int n = exitCode = this.myOperations.size() > 1 ? 1 : 33;
            }
            this.disconnect(connectionInfo, disconnect);
            result.setTools(tools);
            result.setExitCode(exitCode);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private List<BatchOperation> readOperations(String batchFile) {
        ArrayList<BatchOperation> operations = new ArrayList<BatchOperation>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(batchFile));
            boolean operationsOk = true;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(COMMENT_PREFIX)) continue;
                try {
                    operations.add(new BatchOperation(line));
                }
                catch (Exception ex) {
                    Console.error("Failed to read a batch operation from " + batchFile + ", please check content of line: " + line, ex);
                    operationsOk = false;
                }
            }
            ArrayList<BatchOperation> arrayList = operationsOk ? operations : new ArrayList<BatchOperation>();
            return arrayList;
        }
        catch (Exception e) {
            Console.error("Failed to read batch operations from " + batchFile + ": " + e.getMessage() + ". Check content.", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new ArrayList<BatchOperation>();
    }

    @Override
    protected String getDefaultConnectionType() {
        for (BatchOperation operation : this.myOperations) {
            ToolBase singleTool = operation.getTool().getNewSingleTool();
            if (!"write".equals(singleTool.getDefaultConnectionType())) continue;
            return "write";
        }
        return "read-only";
    }
}

