/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.CommissioningResults;
import com.nokia.em.bts.coreasset.application.tools.CommissioningSingle;
import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLHeader;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLLogEntry;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BlockFaultsSingle
extends CommissioningSingle {
    private static final String OPERATION_UPDATE = "update";
    private static final String IN_USE_VALUE_NO = "no";
    private static final String IN_USE_VALUE_YES = "yes";
    private static final String CLASS_BTSSCL = "BTSSCL";
    private static final String CLASS_FMCADM = "FMCADM";
    private static final String CLASS_FMCADM_WITH_PREFIX = "com.nokia.srbts.mnl:FMCADM";
    private static final String ACTION_CREATED = "created";
    private static final String AL_TOGG_SUPP_LIST = "alToggSuppList";
    private static final String IN_USE_FALSE = "false";
    private static final String IN_USE_TRUE = "true";
    private static final String ARG_HW_RESOURCE = "resource";
    private static final String ARG_FAULT_ID = "id";
    private static final String ARG_IN_USE = "inuse";
    private static final String ARG_FAULT_NAME = "name";
    private static final String ARG_FAULT_COUNT = "count";
    private static final String ARG_CONDITION_TIME = "condition";
    private static final String ARG_CLEARANCE_TIME = "clearance";
    private String myAddress;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        String hwresource = args.getFirstValue(ARG_HW_RESOURCE);
        if (hwresource == null) {
            return this.getInvalidParameterFeedbackResult(result, "Missing HW resource");
        }
        String name = args.getFirstValue(ARG_FAULT_NAME);
        if (name == null) {
            return this.getInvalidParameterFeedbackResult(result, "Missing fault name");
        }
        int id = 0;
        try {
            id = Integer.valueOf(args.getFirstValue(ARG_FAULT_ID));
        }
        catch (Exception e) {
            return this.getInvalidParameterFeedbackResult(result, "Invalid or missing fault id");
        }
        String faultName = String.valueOf(hwresource) + "_" + id + "_" + name;
        int alToggAmount = 0;
        try {
            alToggAmount = Integer.valueOf(args.getFirstValue(ARG_FAULT_COUNT));
        }
        catch (Exception e) {
            return this.getInvalidParameterFeedbackResult(result, "Invalid or missing fault count");
        }
        int alToggConditonTime = 0;
        try {
            alToggConditonTime = Integer.valueOf(args.getFirstValue(ARG_CONDITION_TIME));
        }
        catch (Exception e) {
            return this.getInvalidParameterFeedbackResult(result, "Invalid or missing condition time");
        }
        int alToggClearenceTime = 0;
        try {
            alToggClearenceTime = Integer.valueOf(args.getFirstValue(ARG_CLEARANCE_TIME));
        }
        catch (Exception e) {
            return this.getInvalidParameterFeedbackResult(result, "Invalid or missing clearance time");
        }
        String inUse = this.getInUse(args.getFirstValue(ARG_IN_USE));
        if (inUse == null) {
            return this.getInvalidParameterFeedbackResult(result, "Invalid or missing usage");
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connectionInfo.getConnection());
            RAMLFile scf = null;
            try {
                scf = new RAMLFile(this.getBTSSCF(connectionInfo, (ScenarioManager)scenarioManager));
            }
            catch (Exception e) {
                Console.error("Failed to get configuration from " + this.myAddress, e);
                result.setOK(false);
                result.setFeedback("Missing configuration");
                result.setExitCode(108);
                this.disconnect(connectionInfo, disconnect);
                return result;
            }
            RAMLManagedObject btsScl = null;
            try {
                List btsSclList = ((RAMLCMData)scf.getCMData().get(0)).getMOsByClass(CLASS_BTSSCL);
                if (btsSclList.size() == 0) {
                    btsSclList = ((RAMLCMData)scf.getCMData().get(0)).getMOsByClass(CLASS_FMCADM);
                }
                btsScl = (RAMLManagedObject)btsSclList.get(0);
            }
            catch (Exception e) {
                Console.error("Failed to find BTSSCL from " + this.myAddress, e);
                result.setOK(false);
                result.setFeedback("Missing BTSSCL");
                result.setExitCode(110);
                this.disconnect(connectionInfo, disconnect);
                return result;
            }
            boolean isLTE = !site.getNetworkType().toUpperCase().contains("WCDMA");
            int fileType = isLTE ? 97 : 96;
            RAMLFile raml = this.getRAML(btsScl, faultName, alToggAmount, alToggConditonTime, alToggClearenceTime, inUse);
            File file = new File(this.createSCFFileName(isLTE, site.getId()));
            String path = file.getAbsolutePath();
            try {
                raml.writeTo(path);
                if (connectionInfo.isGzippedCommissioningFileNeeded()) {
                    File f2 = Tools.gZip((File)file);
                    if (f2 != null) {
                        path = f2.getAbsolutePath();
                        if (!file.delete()) {
                            file.deleteOnExit();
                        }
                    } else {
                        path = file.getAbsolutePath();
                    }
                } else {
                    path = file.getAbsolutePath();
                }
            }
            catch (Exception e) {
                Console.error("Failed to create configuration for " + this.myAddress, e);
                result.setOK(false);
                result.setFeedback("Failed to create configuration");
                result.setExitCode(109);
                this.disconnect(connectionInfo, disconnect);
                return result;
            }
            CommissioningResults commResult = new CommissioningResults(this.myAddress);
            this.sendSCF(path, (ScenarioManager)scenarioManager, fileType, commResult);
            if (!this.myDebug) {
                Tools.deleteFile((File)new File(path));
            }
            if (this.myTimeouted) {
                result.setOK(false);
                result.setFeedback("Timeout");
                result.setExitCode(8);
            } else if (commResult.isCommissioningOK()) {
                this.activate(commResult, (ScenarioManager)scenarioManager, fileType);
                if (commResult.getExitCode() != 0) {
                    result.setFeedback(commResult.getFeedback());
                    result.setExitCode(commResult.getExitCode());
                    result.setOK(false);
                }
                if (!this.myTimeouted && this.myWaitForReset) {
                    this.waitForReset(connectionInfo);
                    if (!this.myTimeouted) {
                        BTSConnection connection = this.reconnect(username, password, credentials);
                        if (c != null) {
                            c.setConnection(connection);
                        }
                    } else {
                        Console.error("Reset timeout in " + this.myAddress);
                        result.setFeedback("Reset timeout");
                        result.setExitCode(8);
                        result.setOK(false);
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private String getInUse(String value) {
        if (IN_USE_VALUE_YES.equalsIgnoreCase(value)) {
            return IN_USE_TRUE;
        }
        if (IN_USE_VALUE_NO.equalsIgnoreCase(value)) {
            return IN_USE_FALSE;
        }
        return null;
    }

    private RAMLFile getRAML(RAMLManagedObject oriMo, String faultName, int alToggAmount, int alToggConditonTime, int alToggClearenceTime, String inUse) {
        RAMLFile raml = this.getRAMLFile();
        RAMLCMData cmData = this.getCMData();
        RAMLManagedObject mo = new RAMLManagedObject(oriMo.getMOClass(), oriMo.getDistName(), OPERATION_UPDATE, oriMo.getVersion(), cmData);
        RAMLList toggleList = oriMo.getList(AL_TOGG_SUPP_LIST);
        if (toggleList != null) {
            RAMLItem removeItem = null;
            for (Object obj : toggleList.getListObjects()) {
                RAMLItem toggleItem;
                String oriFaultName;
                if (!(obj instanceof RAMLItem) || !faultName.equals(oriFaultName = (toggleItem = (RAMLItem)obj).getParameter("faultName").getValue())) continue;
                removeItem = toggleItem;
            }
            if (removeItem != null) {
                toggleList.remove(removeItem);
            }
            toggleList.add((Object)this.getItem(faultName, alToggAmount, alToggConditonTime, alToggClearenceTime, inUse));
            mo.addList(toggleList);
        } else {
            mo.addList((RAMLList)this.getList(faultName, alToggAmount, alToggConditonTime, alToggClearenceTime, inUse));
            cmData.addMO(mo);
        }
        raml.addCMData(cmData);
        return raml;
    }

    private RAMLFile getRAMLFile() {
        RAMLFile raml = new RAMLFile();
        raml.setAttribute("xmlns", "raml21.xsd");
        raml.setAttribute("version", "2.1");
        return raml;
    }

    private RAMLCMData getCMData() {
        RAMLCMData cmData = new RAMLCMData();
        cmData.setAttribute("type", "plan");
        cmData.setAttribute(ARG_FAULT_ID, String.valueOf(0xC0000000L));
        cmData.setAttribute("scope", "all");
        cmData.setHeader(this.getHeader());
        return cmData;
    }

    private RAMLHeader getHeader() {
        RAMLHeader header = new RAMLHeader();
        header.addLog(this.getLogEntry());
        return header;
    }

    private RAMLLogEntry getLogEntry() {
        RAMLLogEntry log = new RAMLLogEntry();
        log.setAction(ACTION_CREATED);
        log.setAppInfo("Block Toggling Faults Tool");
        log.setAppVersion("2.1");
        log.setDateTime(new Date().toString());
        log.setUser("UICA");
        return log;
    }

    private RAMLItemList getList(String faultName, int alToggAmount, int alToggConditonTime, int alToggClearenceTime, String inUse) {
        RAMLItemList list = new RAMLItemList();
        list.setName(AL_TOGG_SUPP_LIST);
        list.add(this.getItem(faultName, alToggAmount, alToggConditonTime, alToggClearenceTime, inUse));
        return list;
    }

    private RAMLItem getItem(String faultName, int alToggAmount, int alToggConditonTime, int alToggClearenceTime, String inUse) {
        RAMLItem item = new RAMLItem();
        item.addParameter(new RAMLParameter("alToggAmount", alToggAmount));
        item.addParameter(new RAMLParameter("alToggClearenceTime", alToggClearenceTime));
        item.addParameter(new RAMLParameter("alToggConditonTime", alToggConditonTime));
        item.addParameter(new RAMLParameter("faultName", faultName));
        item.addParameter(new RAMLParameter("inUse", inUse));
        return item;
    }

    @Override
    protected String getAddress() {
        return this.myAddress;
    }
}

