/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltAdapter;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CalibrateTiltSingle
extends ToolBase {
    private static final String ARG_IDS = "id";
    private static final String NODE_ID = "_id";
    private static final String NODE_ANTENNA_TILTING_STATE = "AntennaTiltingState";
    private static final String NODEVALUE_STATE_IDLE = "idle";
    private static final String UNIT_TYPE_TILT = "tilt";
    private String myAddress;
    private List<Integer> myTiltIds = null;
    private ScenarioManagerImpl myScenarioManager;
    private boolean myTimeouted;
    private boolean myTiltOk;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        try {
            this.myTiltIds = this.getTiltIdsFrom(args.getFirstValue(ARG_IDS));
        }
        catch (NumberFormatException nfe) {
            Console.error("Invalid tilt id");
            result.setOK(false);
            result.setFeedback("Invalid tilt id");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(96);
            } else {
                this.myScenarioManager = new ScenarioManagerImpl(connection);
                int total = 0;
                int success = 0;
                List units = site.getCabinet().getUnits();
                for (Unit unit : units) {
                    Boolean ok = this.calibrate(unit, connection);
                    if (ok == null) continue;
                    ++total;
                    if (!ok.booleanValue()) continue;
                    ++success;
                }
                if (total != success) {
                    result.setOK(false);
                    result.setFeedback(String.valueOf(success) + "/" + total + " calibrated");
                    result.setExitCode(94);
                } else if (total == 0) {
                    Console.error("No tilts found");
                    result.setOK(false);
                    result.setFeedback("No tilts found");
                    result.setExitCode(95);
                } else {
                    result.setFeedback(String.valueOf(success) + "/" + total + " calibrated");
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean calibrate(Unit unit, BTSConnection connection) {
        if (!unit.getUnitType().equalsIgnoreCase(UNIT_TYPE_TILT)) {
            return null;
        }
        if (this.myTiltIds != null && !this.myTiltIds.contains(unit.getId())) {
            return null;
        }
        this.myTimeouted = true;
        this.myTiltOk = true;
        TiltStateListener tiltStateListener = new TiltStateListener(unit);
        connection.subscribeNotification((BTSNotificationListener)tiltStateListener);
        TiltListener tiltListener = new TiltListener(unit);
        Thread t = new Thread((AntennaTiltListener)tiltListener, unit){
            private final /* synthetic */ AntennaTiltListener val$tiltListener;
            private final /* synthetic */ Unit val$unit;
            {
                this.val$tiltListener = antennaTiltListener;
                this.val$unit = unit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this.val$tiltListener;
                synchronized (object) {
                    try {
                        CalibrateTiltSingle.this.myScenarioManager.getAntennaTiltCalibrateScenario(this.val$tiltListener, this.val$unit.getId(), 0).execute();
                        this.val$tiltListener.wait();
                    }
                    catch (Exception e) {
                        Console.error("Tilt " + this.val$unit.getId() + " calibrate not started in " + CalibrateTiltSingle.this.myAddress, e);
                        CalibrateTiltSingle.this.myTiltOk = false;
                    }
                }
                if (CalibrateTiltSingle.this.myTiltOk) {
                    CalibrateTiltSingle.this.myTimeouted = true;
                    object = this.val$unit;
                    synchronized (object) {
                        try {
                            this.val$unit.wait(240000 + CalibrateTiltSingle.this.myTimeout);
                            if (CalibrateTiltSingle.this.myTimeouted) {
                                Console.error("Tilt " + this.val$unit.getId() + " calibrate timeout in " + CalibrateTiltSingle.this.myAddress);
                                CalibrateTiltSingle.this.myTiltOk = false;
                            } else {
                                Console.info("Tilt " + this.val$unit.getId() + " calibrate finished in " + CalibrateTiltSingle.this.myAddress);
                            }
                        }
                        catch (InterruptedException e) {
                            Console.error("Tilt " + this.val$unit.getId() + " calibrate failed in " + CalibrateTiltSingle.this.myAddress, e);
                            CalibrateTiltSingle.this.myTiltOk = false;
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.notify();
                }
            }
        };
        t.start();
        Thread thread = t;
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        connection.unsubscribeNotification((BTSNotificationListener)tiltStateListener);
        return this.myTiltOk;
    }

    private List<Integer> getTiltIdsFrom(String ids) throws NumberFormatException {
        if (ids == null) {
            return null;
        }
        ArrayList<Integer> l = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens()) {
            l.add(Integer.valueOf(st.nextToken()));
        }
        return l;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class TiltListener
    extends AntennaTiltAdapter {
        private final Unit myUnit;

        private TiltListener(Unit unit) {
            this.myUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calibrateAccepted() {
            Console.info("Tilt " + this.myUnit.getId() + " calibrate started in " + CalibrateTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                CalibrateTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void calibrateFailed(int reason) {
            Console.error("Tilt " + this.myUnit.getId() + " calibrate not started in " + CalibrateTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                CalibrateTiltSingle.this.myTiltOk = false;
                CalibrateTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class TiltStateListener
    implements BTSNotificationListener {
        private final Unit myUnit;

        private TiltStateListener(Unit unit) {
            this.myUnit = unit;
        }

        public void btsNotificationReceived(BTSMessage message) {
            DataChangeNotif notif;
            if (message instanceof DataChangeNotif && (notif = (DataChangeNotif)message).getConfigObjectType() == 10) {
                this.checkTiltStateFrom(notif);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTiltStateFrom(DataChangeNotif notif) {
            NodeList list = notif.getConfigObjectData();
            boolean idOK = false;
            boolean stateOK = false;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.hasChildNodes()) {
                    String name = node.getNodeName();
                    String value = node.getFirstChild().getNodeValue();
                    if (CalibrateTiltSingle.NODE_ID.equalsIgnoreCase(name) && value.equalsIgnoreCase(String.valueOf(this.myUnit.getId()))) {
                        idOK = true;
                    } else if (CalibrateTiltSingle.NODE_ANTENNA_TILTING_STATE.equalsIgnoreCase(name) && CalibrateTiltSingle.NODEVALUE_STATE_IDLE.equalsIgnoreCase(value)) {
                        stateOK = true;
                    }
                }
                ++i;
            }
            if (idOK && stateOK) {
                Unit unit = this.myUnit;
                synchronized (unit) {
                    CalibrateTiltSingle.this.myTimeouted = false;
                    this.myUnit.notify();
                }
            }
        }
    }
}

