/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.XMLUtils;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.RAMLRequest;
import com.nokia.em.bts.rp.master.message.RAMLResponse;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.Map;
import org.w3c.dom.Node;

public class ChangeNTPAddrSingle
extends ToolBase {
    private static final String STATUS = "\"status\">";
    private static final String DETAILS = "\"details\">";
    private static final String ARG_NTP_SERVERS = "ntpServers";
    private String myAddress;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        String ntpServerIP = args.getFirstValue(ARG_NTP_SERVERS);
        String[] ntpServerIPs = null;
        if (ntpServerIP != null) {
            ntpServerIPs = ntpServerIP.split(",");
        }
        if (ntpServerIPs == null || ntpServerIPs.length == 0) {
            Console.error("No valid addresses given");
            result.setOK(false);
            result.setFeedback("No valid addresses given");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            Console.info("Changing NTP addresses started in " + this.myAddress);
            int seqnum = connection.createScenario();
            connection.sendToBTS((BTSMessage)new RAMLRequest(seqnum, XMLUtils.createRamlMessage(this.createRAMLObject(ntpServerIPs, connectionInfo), "Change NTP Address Tool")));
            BTSMessage response = connection.receiveFromBTS(seqnum, (long)this.myTimeout);
            if (response instanceof RAMLResponse) {
                RAMLResponse ramlresponse = (RAMLResponse)response;
                if (this.isStatusOK(ramlresponse)) {
                    Console.info("Successfully changed NTP addresses in " + this.myAddress);
                    result.setOK(true);
                    result.setFeedback("Successful");
                } else {
                    String detailsInfo = this.getDetails(ramlresponse);
                    Console.error("Failed to change NTP addresses (" + detailsInfo + ") in " + this.myAddress);
                    result.setOK(false);
                    result.setFeedback(detailsInfo);
                    result.setExitCode(117);
                }
            } else if (response instanceof Timeout) {
                Console.error("Failed to change NTP addresses (timeout) in " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Timeout");
                result.setExitCode(8);
            } else if (response == null) {
                Console.error("Failed to change NTP addresses in " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed");
                result.setExitCode(117);
            } else {
                Console.error("Failed to change NTP addresses (invalid response) in " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Invalid response");
                result.setExitCode(117);
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private boolean isStatusOK(RAMLResponse response) {
        String content = Tools.xmlToString((Node)response.getRAMLResponse());
        int index = content.indexOf(STATUS);
        if (index > 0) {
            return content.substring(index + STATUS.length(), index + STATUS.length() + 1).equalsIgnoreCase("O");
        }
        return false;
    }

    private String getDetails(RAMLResponse response) {
        String content = Tools.xmlToString((Node)response.getRAMLResponse());
        int index = content.indexOf(DETAILS);
        if (index > 0) {
            String s = content.substring(index + DETAILS.length());
            return s.substring(0, s.indexOf("<"));
        }
        return "";
    }

    private RAMLManagedObject createRAMLObject(String[] ntpServerIPs, ConnectionInformation connectionInfo) {
        try {
            RAMLManagedObject ramlObject = null;
            if (connectionInfo.getProduct().getAdptVersionMap().size() == 0) {
                ramlObject = new RAMLManagedObject("FTM-1/IPNO-1/INTP-1", "INTP", "update", null);
                ramlObject.setVersion(connectionInfo.getProduct().getReleaseVersion().replace(".", ""));
            } else {
                ramlObject = new RAMLManagedObject("FTM-1/IPNO-1/INTP-1", "INTP", "update", null);
                ramlObject.setAttribute("class", "NOKLTE:INTP");
                ramlObject.setVersion(connectionInfo.getProduct().getAdptVersionMap().get("NOKLTE"));
            }
            RAMLParameterList parameterList = new RAMLParameterList();
            parameterList.setName(ARG_NTP_SERVERS);
            String[] stringArray = ntpServerIPs;
            int n = ntpServerIPs.length;
            int n2 = 0;
            while (n2 < n) {
                String ntpServer = stringArray[n2];
                parameterList.add((Object)new RAMLParameter("", ntpServer));
                ++n2;
            }
            ramlObject.addList((RAMLList)parameterList);
            return ramlObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

