/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.ChangeRADParamsSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RADParamResults;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChangeRADParamsImpl
extends ToolImpl {
    private static final String COLUMN_CHANGED = "Changed";
    private List<RADParamResults> myResults = new ArrayList<RADParamResults>();

    public ChangeRADParamsImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Change RAD Params";
    }

    @Override
    public String getVersion() {
        return "4.1";
    }

    @Override
    public String getFilePrefix() {
        return "ChangeRADParams";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((RADParamResults)result);
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new ChangeRADParamsSingle();
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.getResultText(this.myResults.get(0));
        }
        return "No results";
    }

    private String getResultText(RADParamResults result) {
        int total = 0;
        int ok = 0;
        for (Map.Entry<String, Boolean> entry : result.getResults().entrySet()) {
            ++total;
            if (!entry.getValue().booleanValue()) continue;
            ++ok;
        }
        return String.valueOf(ok) + "/" + total + " changed";
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_CHANGED);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (RADParamResults results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, RADParamResults results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, RADParamResults results) {
        values.add(results.getOperationalState());
        values.add(this.getResultText(results));
    }
}

