/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RADParamResults;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsAdapter;
import com.nokia.em.bts.coreasset.scenario.techlogfiles.RadParamsListener;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class ChangeRADParamsSingle
extends ToolBase {
    private static final String DEFAULT_BTSSWSC = "";
    private static final Long DEFAULT_PARAM_VALUE = 0L;
    private static final String ARG_PARAMS = "params";
    private static final String ARG_RESET_TO_DEFAULTS = "defaults";
    private static final String ARG_PERMANENT = "permanent";
    private static final String ARG_OVER_RESET = "overreset";
    private int myRadSettingType;
    private Map<String, Map<Long, Long>> myRADParamsMap;
    private String myBtsSwSc;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.parseCommonParamsFrom(args);
        RADParamResults result = new RADParamResults();
        this.parseRADSettingTypeFrom(args, result);
        if (result.getExitCode() != 0) {
            return result;
        }
        this.parseRADParamsFrom(args.getFirstValue(ARG_PARAMS), result);
        if (result.getExitCode() != 0) {
            return result;
        }
        if (!this.isFactoryDefault() && this.myRADParamsMap.size() == 0) {
            Console.error("Missing -params. Cannot continue.");
            result.setExitCode(3);
            return result;
        }
        return this.connectAndDoBusiness(c, btsInformation, args, result);
    }

    protected OperationResult connectAndDoBusiness(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args, OperationResult result) {
        boolean disconnect = false;
        ConnectionInformation connectionInfo = c;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            this.doBusiness(connectionInfo, btsInformation, args, result);
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationResult doBusiness(ConnectionInformation connectionInfo, BTSInformation btsInformation, PCmdLineParams args, OperationResult result) {
        final RADParamResults rADParamResults = (RADParamResults)result;
        Site site = connectionInfo.getSite();
        if (site == null) {
            site = this.buildHWModel(connectionInfo.getConnection());
        }
        rADParamResults.setOperationalState(this.getOperationalStateText(site));
        rADParamResults.setAddress(connectionInfo.getAddress());
        final String address = btsInformation.getBTSAddress();
        RadParamsAdapter listener = new RadParamsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paramsSet(int r) {
                switch (r) {
                    case 86: {
                        Console.error(String.valueOf(ChangeRADParamsSingle.this.getOperationText()) + " failed (out of range) to " + address);
                        rADParamResults.addResult(ChangeRADParamsSingle.this.myBtsSwSc, false);
                        rADParamResults.setExitCode(65);
                        break;
                    }
                    case 68: {
                        Console.error(String.valueOf(ChangeRADParamsSingle.this.getOperationText()) + " failed (timeout) to " + address);
                        rADParamResults.addResult(ChangeRADParamsSingle.this.myBtsSwSc, false);
                        rADParamResults.setExitCode(8);
                        break;
                    }
                    case 28: {
                        Console.error(String.valueOf(ChangeRADParamsSingle.this.getOperationText()) + " failed (invalid message) to " + address);
                        rADParamResults.addResult(ChangeRADParamsSingle.this.myBtsSwSc, false);
                        rADParamResults.setExitCode(65);
                        break;
                    }
                    case 36: {
                        Console.info(String.valueOf(ChangeRADParamsSingle.this.getOperationText()) + " successful to " + address);
                        rADParamResults.addResult(ChangeRADParamsSingle.this.myBtsSwSc, true);
                        break;
                    }
                    default: {
                        Console.error(String.valueOf(ChangeRADParamsSingle.this.getOperationText()) + " failed (unknown reason) to " + address);
                        rADParamResults.addResult(ChangeRADParamsSingle.this.myBtsSwSc, false);
                        rADParamResults.setExitCode(65);
                    }
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    ((Object)((Object)this)).notify();
                }
            }
        };
        if (this.isFactoryDefault() && this.myRADParamsMap.size() == 0) {
            this.myBtsSwSc = "Reset to factory defaults";
            RadParamsAdapter radParamsAdapter = listener;
            synchronized (radParamsAdapter) {
                new ScenarioManagerImpl(connectionInfo.getConnection()).getRadParamsResetScenario((RadParamsListener)listener, DEFAULT_BTSSWSC).execute();
                try {
                    listener.wait(this.myTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Iterator<String> iterator = this.myRADParamsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            this.myBtsSwSc = key = iterator.next();
            RadParamsAdapter radParamsAdapter = listener;
            synchronized (radParamsAdapter) {
                new ScenarioManagerImpl(connectionInfo.getConnection()).getRadParamsSetScenario((RadParamsListener)listener, this.myBtsSwSc, this.myRadSettingType, this.myRADParamsMap.get(this.myBtsSwSc)).execute();
                try {
                    listener.wait(this.myTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return rADParamResults;
    }

    private String getOperationText() {
        return this.isFactoryDefault() ? "Reset to factory defaults" : "RAD param change for " + this.myBtsSwSc;
    }

    private boolean isFactoryDefault() {
        return this.myRadSettingType == 1;
    }

    private void parseRADSettingTypeFrom(PCmdLineParams args, OperationResult result) {
        HashMap<String, Integer> radSettingTypes = new HashMap<String, Integer>();
        if (args.isDefined(ARG_RESET_TO_DEFAULTS)) {
            radSettingTypes.put(ARG_RESET_TO_DEFAULTS, 1);
        }
        if (args.isDefined(ARG_PERMANENT)) {
            radSettingTypes.put(ARG_PERMANENT, 3);
        }
        if (args.isDefined(ARG_OVER_RESET)) {
            radSettingTypes.put(ARG_OVER_RESET, 4);
        }
        if (radSettingTypes.size() == 0) {
            this.myRadSettingType = 2;
        } else if (radSettingTypes.size() == 1) {
            this.myRadSettingType = (Integer)radSettingTypes.values().iterator().next();
        } else {
            Console.error("Invalid options, more than one of these options (-defaults, -permanent, -overreset) is used.");
            result.setExitCode(64);
        }
    }

    private void parseRADParamsFrom(String values, OperationResult result) {
        this.myRADParamsMap = new HashMap<String, Map<Long, Long>>();
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreTokens()) {
                String[] s = st.nextToken().split(":");
                if (s.length == 2) {
                    try {
                        this.addRADParameter(Long.valueOf(s[0]), DEFAULT_PARAM_VALUE, s[1]);
                    }
                    catch (NumberFormatException nfe) {
                        Console.error("Invalid format for -params, parameter:component expected.");
                        result.setExitCode(64);
                    }
                    continue;
                }
                if (s.length == 3) {
                    try {
                        this.addRADParameter(Long.valueOf(s[0]), Long.valueOf(s[1]), s[2]);
                    }
                    catch (NumberFormatException nfe) {
                        Console.error("Invalid format for -params, parameter:value:component expected.");
                        result.setExitCode(64);
                    }
                    continue;
                }
                Console.error("Invalid format for -params, parameter:value:component or parameter:component expected.");
                result.setExitCode(64);
            }
        }
    }

    private void addRADParameter(Long parameter, Long value, String component) {
        Map<Long, Long> parameterValueMap = this.myRADParamsMap.get(component);
        if (parameterValueMap == null) {
            parameterValueMap = new HashMap<Long, Long>();
            this.myRADParamsMap.put(component, parameterValueMap);
        }
        parameterValueMap.put(parameter, value);
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

