/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.AlarmChecker;
import com.nokia.em.bts.coreasset.application.tools.AlarmCheckingResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.StringUtils;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckAlarmsImpl
extends ToolImpl {
    private static final String COLUMN_RESULT = "Result";
    private static final String PARAM_DISPLAY_NAME = "display_name";
    private static final String PARAM_IF_NONE_FOUND = "if_none_found";
    private static final String PARAM_REPORT_NAME = "report_name";
    private static final String WARNING = "Warning";
    private static final String CRITICAL = "Critical";
    private static final String MAJOR = "Major";
    private static final String MINOR = "Minor";
    private static final String COLUMN_DESCRIPTION = "Description";
    private static final String COLUMN_TIME = "Time";
    private static final String COLUMN_SEVERITY = "Severity";
    private static final String COLUMN_DETAIL = "Detail";
    private static final String COLUMN_ALARM = "Alarm";
    protected static final String ARG_ALARMFILE = "alarmfile";
    private static final int OBSERVATION_TIME_LENGTH = 19;
    private SimpleDateFormat myAlarmTimeFormat = new SimpleDateFormat("yyyyMMddHHmmssZ");
    private SimpleDateFormat myNewAlarmTimeFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
    private SimpleDateFormat myPriorAlarmTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
    private Map<String, AlarmCheckingResult> myResults;
    private String myOKText = null;
    private String myFoundAlarmsText = null;
    protected PCmdLineParams myBatchParams = new PCmdLineParams();

    public CheckAlarmsImpl(String outdir) {
        super(outdir);
        this.myResults = new HashMap<String, AlarmCheckingResult>();
    }

    @Override
    public String getName() {
        return this.getToolName(" ");
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    @Override
    public String getFilePrefix() {
        return this.getToolName("");
    }

    private String getToolName(String separator) {
        String value;
        String toolName = "Active" + separator + "Alarms";
        List<String> alarmDefinitionFiles = this.getCmdParams(ARG_ALARMFILE);
        if (alarmDefinitionFiles != null && alarmDefinitionFiles.size() == 1 && (value = this.getParameterValueFrom(alarmDefinitionFiles.get(0), PARAM_DISPLAY_NAME)) != null) {
            toolName = value.replaceAll(" ", separator);
        }
        return toolName;
    }

    @Override
    public OperationResult execute(ConnectionInformation connectionInfo, PCmdLineParams args) {
        this.myBatchParams = args;
        return super.execute(connectionInfo, args);
    }

    private String getParameterValueFrom(String filename, String parameter) {
        try {
            List<String> lines = CheckAlarmsImpl.parseTxtConfigFile(filename);
            for (String line : lines) {
                if (!line.startsWith(parameter)) continue;
                return line.substring(line.indexOf("=") + 1);
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).error((Object)("Failed to get " + parameter + " value from " + filename), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getResults() {
        ArrayList<String[]> toolResults = new ArrayList<String[]>();
        for (AlarmCheckingResult result : this.myResults.values()) {
            toolResults.addAll(this.checkReceivedAlarms(result));
        }
        String[] columnNames = new String[]{"Site", "Site Status", COLUMN_RESULT, COLUMN_ALARM, COLUMN_DETAIL, COLUMN_SEVERITY, COLUMN_TIME, COLUMN_DESCRIPTION};
        return this.formatSummaryTable(toolResults, columnNames);
    }

    @Override
    public String getShortResult() {
        try {
            List<Alarm> alarms = this.myResults.get(this.myResults.keySet().iterator().next()).getAlarmList();
            int alarmcount = alarms.size();
            if (alarmcount == 0) {
                return this.getOKText();
            }
            return String.valueOf(alarmcount) + TextFormattingUtils.getPlural(" alarm", alarmcount);
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    protected String formatSummaryTable(List<String[]> toolResults, String[] columnNames) {
        String[][] summaries = new String[toolResults.size()][];
        int i = 0;
        while (i < toolResults.size()) {
            summaries[i] = toolResults.get(i);
            ++i;
        }
        return TextFormattingUtils.formatTableToText(summaries, columnNames);
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new AlarmChecker();
    }

    @Override
    protected void updateResults(OperationResult result) {
        String address = result.getAddress();
        AlarmCheckingResult alarmresult = (AlarmCheckingResult)result;
        List<Alarm> specifiedAlarms = this.findSpecifiedAlarms(alarmresult.getAlarmList());
        alarmresult.setAlarmList(specifiedAlarms);
        this.myResults.put(address, alarmresult);
        if (alarmresult.isConnected()) {
            int alarmcount = specifiedAlarms.size();
            Console.info("Successfully got " + alarmcount + " " + TextFormattingUtils.getPlural(this.getFoundAlarmsText(), alarmcount) + " from " + address);
            if (alarmcount > 0 && this.getCmdParams(ARG_ALARMFILE) != null) {
                result.setExitCode(37);
            }
        } else {
            Console.error("Failed to get alarms from " + address);
        }
    }

    private List<String[]> checkReceivedAlarms(AlarmCheckingResult result) {
        String[] resultInTable;
        ArrayList<String[]> alarmSummaries = new ArrayList<String[]>();
        for (Alarm alarm : result.getAlarmList()) {
            alarmSummaries.add(this.addAlarmToSummary(alarm));
        }
        if (!result.isOK()) {
            resultInTable = new String[]{result.getAddress(), result.getOperationalState()};
            alarmSummaries.add(resultInTable);
        } else if (alarmSummaries.isEmpty()) {
            resultInTable = new String[]{result.getAddress(), result.getOperationalState(), this.getOKText()};
            alarmSummaries.add(resultInTable);
        } else {
            String[] firstRow = (String[])alarmSummaries.get(0);
            firstRow[0] = result.getAddress();
            firstRow[1] = result.getOperationalState();
            firstRow[2] = "Not OK";
        }
        return alarmSummaries;
    }

    private List<Alarm> findSpecifiedAlarms(List<Alarm> alarmList) {
        List<String> alarmsToBeChecked = this.getSearchedAlarmList(this.getCmdParams(ARG_ALARMFILE));
        boolean alarmSearchListNotDefined = this.getCmdParams(ARG_ALARMFILE) == null;
        ArrayList<Alarm> alarmSummaries = new ArrayList<Alarm>();
        if (alarmList != null) {
            for (Alarm alarm : alarmList) {
                if (!alarmSearchListNotDefined && !alarmsToBeChecked.contains(String.valueOf(alarm.getAlarmNumber())) && !alarmsToBeChecked.contains(String.valueOf(alarm.getAlarmDetailNbr())) && !alarmsToBeChecked.contains(this.getAlarmNumberFromTypeOfPluginUnit(alarm))) continue;
                alarmSummaries.add(alarm);
            }
        }
        return alarmSummaries;
    }

    private String getAlarmNumberFromTypeOfPluginUnit(Alarm alarm) {
        try {
            if (StringUtils.isValid(alarm.getTypeOfPlugInUnit()) && alarm.getTypeOfPlugInUnit().length() > 4) {
                return alarm.getTypeOfPlugInUnit().substring(0, 4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String getFoundAlarmsText() {
        if (this.myFoundAlarmsText == null) {
            String value;
            this.myFoundAlarmsText = COLUMN_ALARM;
            List<String> alarmDefinitionFiles = this.getCmdParams(ARG_ALARMFILE);
            if (alarmDefinitionFiles != null && alarmDefinitionFiles.size() == 1 && (value = this.getParameterValueFrom(alarmDefinitionFiles.get(0), PARAM_REPORT_NAME)) != null) {
                this.myFoundAlarmsText = value;
            }
        }
        return this.myFoundAlarmsText;
    }

    private String getOKText() {
        if (this.myOKText == null) {
            String value;
            this.myOKText = "OK";
            List<String> alarmDefinitionFiles = this.getCmdParams(ARG_ALARMFILE);
            if (alarmDefinitionFiles != null && alarmDefinitionFiles.size() == 1 && (value = this.getParameterValueFrom(alarmDefinitionFiles.get(0), PARAM_IF_NONE_FOUND)) != null) {
                this.myOKText = value;
            }
        }
        return this.myOKText;
    }

    protected List<String> getSearchedAlarmList(List<String> alarmDefinitionFiles) {
        ArrayList<String> searchedAlarms = new ArrayList<String>();
        try {
            if (alarmDefinitionFiles != null) {
                for (String file : alarmDefinitionFiles) {
                    searchedAlarms.addAll(this.parseAlarmNumbers(CheckAlarmsImpl.parseTxtConfigFile(file)));
                }
            }
        }
        catch (IOException e1) {
            Console.error("Cannot find alarm definition file " + e1.getMessage(), e1);
        }
        return searchedAlarms;
    }

    private List<String> parseAlarmNumbers(List<String> parseTxtConfigFile) {
        ArrayList<String> plainAlarms = new ArrayList<String>();
        for (String row : parseTxtConfigFile) {
            plainAlarms.add(TextUtils.parseVersionNumber((String)row));
        }
        return plainAlarms;
    }

    protected List<String> getCmdParams(String key) {
        return this.myBatchParams.getValues(key);
    }

    protected String[] addAlarmToSummary(Alarm alarm) {
        String[] resultInTable = new String[8];
        resultInTable[3] = TextFormattingUtils.getAlarmCode(alarm);
        String alarmNumberFromTypeOfPluginUnit = this.getAlarmNumberFromTypeOfPluginUnit(alarm);
        resultInTable[4] = alarmNumberFromTypeOfPluginUnit.isEmpty() ? this.getAlarmDetailsNumber(alarm) : alarmNumberFromTypeOfPluginUnit;
        resultInTable[5] = this.convertSeverity(alarm.getSeverity());
        resultInTable[6] = this.convertTimeStamp(alarm.getObservationTime());
        resultInTable[7] = alarm.getAlarmDetail();
        return resultInTable;
    }

    protected String getAlarmDetailsNumber(Alarm alarm) {
        int detailsNumber = alarm.getAlarmDetailNbr();
        if (detailsNumber == 0) {
            return String.valueOf(alarm.getReportedNumber());
        }
        return String.valueOf(detailsNumber);
    }

    protected String convertTimeStamp(String observationTime) {
        try {
            Date date;
            if (observationTime.length() > 19) {
                try {
                    date = this.myPriorAlarmTimeFormat.parse(observationTime);
                }
                catch (Exception e) {
                    date = this.myNewAlarmTimeFormat.parse(observationTime);
                }
            } else {
                date = this.myAlarmTimeFormat.parse(observationTime);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return TextFormattingUtils.applyLongTimeZoneFormat(c);
        }
        catch (ParseException e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to convert time stamp", (Throwable)e);
            return observationTime;
        }
    }

    protected String convertSeverity(int severity) {
        switch (severity) {
            case 16: {
                return MINOR;
            }
            case 17: {
                return MAJOR;
            }
            case 18: {
                return CRITICAL;
            }
        }
        return WARNING;
    }
}

