/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.CommissioningResults;
import com.nokia.em.bts.coreasset.application.tools.CommissioningSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class CommissioningImpl
extends ToolImpl {
    public static final String VERSION = "4.14";
    private static final String COLUMN_COMMISSIONED = "Commissioned";
    private List<CommissioningResults> myResults = new ArrayList<CommissioningResults>();

    public CommissioningImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Commissioning";
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String getFilePrefix() {
        return "Commissioning";
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_COMMISSIONED);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (CommissioningResults results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, CommissioningResults results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, CommissioningResults results) {
        values.add(results.getOperationalState());
        values.add(results.isOK() ? "OK" : results.getFeedback());
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            CommissioningResults results = this.myResults.get(0);
            return results.isOK() ? "OK" : results.getFeedback();
        }
        return "No results";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new CommissioningSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((CommissioningResults)result);
    }
}

