/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.util.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommissioningParameter {
    private String myManagedObjectName = null;
    private String myDistNameSuffix = null;
    private String myInstanceId = null;
    private String myListName = null;
    private String myName = null;
    private String myValue = null;
    private String myOldValue = null;
    private Set<String> myUpdatedManagedObjectNames = new TreeSet<String>();
    private Type myType;
    private Operation myOperation;
    private List<Item> myItems = new ArrayList<Item>();
    private List<CommissioningParameter> myScalarParameters = new ArrayList<CommissioningParameter>();
    private static final String MANAGEDOBJECT = "managedObject";
    private static final String INSTANCEID = "instanceId";
    private static final String LISTNAME = "listName";
    private static final String OPERATION = "operation";
    private static final String LIST = "list";
    private static final String P = "p";
    private static final String ITEM = "item";
    private static final String MATCHES = "matches";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String OLDVALUE = "oldValue";
    private static final String EMPTY_VALUE = "EMPTY_JAVA_STRING";

    public CommissioningParameter(String parameter) throws Exception {
        StringTokenizer st;
        this.myType = Type.PARAMETER;
        String p = parameter;
        if (p.endsWith(":")) {
            p = p.concat(EMPTY_VALUE);
        }
        if ((st = new StringTokenizer(p, ":")).countTokens() > 2) {
            String distNameSuffix = st.nextToken();
            this.extractManagedObjectAndSuffix(distNameSuffix);
        }
        if (st.countTokens() < 2) {
            throw new IllegalArgumentException("Invalid parameter format");
        }
        if (st.countTokens() == 4) {
            this.setInstanceId(st.nextToken());
            this.setListName(st.nextToken());
        }
        if (st.countTokens() == 3) {
            this.setInstanceId(st.nextToken());
        }
        this.setName(st.nextToken());
        this.setValue(st.nextToken());
    }

    private void extractManagedObjectAndSuffix(String moParam) {
        if (moParam.contains("/")) {
            this.setManagedObjectName(moParam.substring(moParam.lastIndexOf("/") + 1));
            this.setDistNameSuffix(moParam);
        } else {
            this.setManagedObjectName(moParam);
            this.setDistNameSuffix(moParam);
        }
    }

    public CommissioningParameter(Element e, String file) throws Exception {
        String nodeName = e.getNodeName();
        if (P.equalsIgnoreCase(nodeName)) {
            this.myType = Type.PARAMETER;
            NodeList n = e.getElementsByTagName(MANAGEDOBJECT);
            if (n.getLength() > 0 && n.item(0).hasChildNodes()) {
                this.extractManagedObjectAndSuffix(n.item(0).getFirstChild().getNodeValue());
            }
            if ((n = e.getElementsByTagName(INSTANCEID)).getLength() > 0 && n.item(0).hasChildNodes()) {
                this.setInstanceId(n.item(0).getFirstChild().getNodeValue());
            }
            if ((n = e.getElementsByTagName(LISTNAME)).getLength() > 0 && n.item(0).hasChildNodes()) {
                this.setListName(n.item(0).getFirstChild().getNodeValue());
            }
            try {
                this.setName(e.getElementsByTagName(NAME).item(0).getFirstChild().getNodeValue());
                this.setValue(e.getElementsByTagName(VALUE).item(0).getFirstChild().getNodeValue());
            }
            catch (NullPointerException npe) {
                this.setName(XMLUtils.getAttributeValue(e, NAME));
                this.extractManagedObjectAndSuffix(XMLUtils.getAttributeValue(e, MANAGEDOBJECT));
                this.setInstanceId(XMLUtils.getAttributeValue(e, INSTANCEID));
                this.setListName(XMLUtils.getAttributeValue(e, LISTNAME));
                this.setOperation(XMLUtils.getAttributeValue(e, OPERATION));
                this.setValue(e.hasChildNodes() ? e.getFirstChild().getNodeValue() : "");
            }
        } else if (LIST.equalsIgnoreCase(nodeName)) {
            this.myType = Type.ITEMLIST;
            this.setName(XMLUtils.getAttributeValue(e, NAME));
            this.extractManagedObjectAndSuffix(XMLUtils.getAttributeValue(e, MANAGEDOBJECT));
            this.setInstanceId(XMLUtils.getAttributeValue(e, INSTANCEID));
            NodeList itemList = e.getElementsByTagName(ITEM);
            Boolean hasMatches = null;
            int i = 0;
            while (i < itemList.getLength()) {
                try {
                    Item item = new Item(itemList.item(i), this.getName());
                    this.myItems.add(item);
                    if (hasMatches != null && !item.getMatches().isEmpty() ^ hasMatches) {
                        throw new IllegalArgumentException("parameter file contained an item list (" + this.getName() + ") that has both old and new items");
                    }
                    hasMatches = !item.getMatches().isEmpty();
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("failed to create list (" + this.getName() + ") item from " + file + " (" + e2.getMessage() + ")");
                }
                ++i;
            }
            NodeList pList = e.getChildNodes();
            Boolean isNewParam = null;
            int i2 = 0;
            while (i2 < pList.getLength()) {
                Node n = pList.item(i2);
                if (n.getNodeName().equalsIgnoreCase(P)) {
                    if (this.myItems.size() > 0) {
                        throw new IllegalArgumentException("parameter file contained a list (" + this.getName() + ") that has both items and scalar parameters");
                    }
                    try {
                        String oldValue = XMLUtils.getAttributeValue(n, OLDVALUE);
                        if (isNewParam != null && oldValue == null ^ isNewParam) {
                            throw new IllegalArgumentException("parameter file contained a scalar list (" + this.getName() + ") that has both old and new parameters");
                        }
                        isNewParam = oldValue == null;
                        this.myScalarParameters.add(new CommissioningParameter(oldValue, n.getFirstChild().getNodeValue(), true));
                        this.myType = Type.SCALARLIST;
                    }
                    catch (Exception e2) {
                        throw new IllegalArgumentException("failed to create scalar list parameter from " + file + " (" + e2.getMessage() + ")");
                    }
                }
                ++i2;
            }
            if (hasMatches != null) {
                this.setOldValue(hasMatches != false ? "" : null);
            }
            if (isNewParam != null) {
                this.setOldValue(isNewParam != false ? null : "");
            }
        } else {
            throw new IllegalArgumentException("unrecognized parameter file element " + nodeName);
        }
    }

    public CommissioningParameter(String name, String value) {
        this(name, value, false);
    }

    public CommissioningParameter(String s, String value, boolean scalar) {
        if (scalar) {
            this.setOldValue(s);
            this.setValue(value);
        } else {
            this.setName(s);
            this.setValue(value);
        }
    }

    public boolean isDelete() {
        return this.myOperation == Operation.DELETE;
    }

    public boolean isUpdate() {
        return this.myOperation == Operation.UPDATE;
    }

    public boolean isCreate() {
        return this.myOperation == Operation.CREATE;
    }

    public boolean isParameter() {
        return this.myType == Type.PARAMETER;
    }

    public boolean isItemList() {
        return this.myType == Type.ITEMLIST;
    }

    public boolean isScalarList() {
        return this.myType == Type.SCALARLIST;
    }

    public void addUpdatedManagedObjectName(String s) {
        this.myUpdatedManagedObjectNames.add(s);
    }

    public Set<String> getUpdatedManagedObjectNames() {
        return this.myUpdatedManagedObjectNames;
    }

    public String getUpdatedManagedObjectNamesString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.myUpdatedManagedObjectNames) {
            sb.append(s).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String getManagedObjectName() {
        return this.myManagedObjectName;
    }

    public void setManagedObjectName(String managedObjectName) {
        this.myManagedObjectName = managedObjectName;
    }

    public String getDistNameSuffix() {
        return this.myDistNameSuffix;
    }

    public void setDistNameSuffix(String distNameSuffix) {
        this.myDistNameSuffix = distNameSuffix;
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    public void setInstanceId(String instanceId) {
        this.myInstanceId = instanceId;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String value) {
        this.myValue = EMPTY_VALUE.equals(value) ? "" : value;
    }

    public String getOldValue() {
        return this.myOldValue;
    }

    public boolean hasOldValue() {
        return this.myOldValue != null;
    }

    public void setOldValue(String oldValue) {
        this.myOldValue = oldValue;
    }

    public String getListName() {
        return this.myListName;
    }

    public void setListName(String listName) {
        this.myListName = listName;
    }

    public void setOperation(String operation) {
        this.myOperation = Operation.CREATE.toString().equalsIgnoreCase(operation) ? Operation.CREATE : (Operation.DELETE.toString().equalsIgnoreCase(operation) ? Operation.DELETE : Operation.UPDATE);
    }

    public List<Item> getItems() {
        return this.myItems;
    }

    public List<CommissioningParameter> getScalarParameters() {
        return this.myScalarParameters;
    }

    public class Item {
        private List<CommissioningParameter> myMatches = new ArrayList<CommissioningParameter>();
        private List<CommissioningParameter> myUpdates = new ArrayList<CommissioningParameter>();

        private Item(Node item, String listName) throws Exception {
            NodeList nl = ((Element)item).getElementsByTagName(CommissioningParameter.MATCHES);
            if (nl.getLength() > 0) {
                NodeList matches = ((Element)nl.item(0)).getElementsByTagName(CommissioningParameter.P);
                int i = 0;
                while (i < matches.getLength()) {
                    try {
                        Node n = matches.item(i);
                        this.myMatches.add(new CommissioningParameter(XMLUtils.getAttributeValue(n, CommissioningParameter.NAME), n.getFirstChild().getNodeValue()));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("failed to read 'matches' parameter for list " + listName + " (" + e.getMessage() + ")");
                    }
                    ++i;
                }
                if (this.myMatches.size() == 0) {
                    throw new IllegalArgumentException("'matches' element was defined but didn't contain any valid parameters");
                }
            }
            nl = ((Element)item).getElementsByTagName(CommissioningParameter.P);
            int i = 0;
            while (i < nl.getLength()) {
                try {
                    Node n = nl.item(i);
                    this.myUpdates.add(new CommissioningParameter(XMLUtils.getAttributeValue(n, CommissioningParameter.NAME), n.getFirstChild().getNodeValue()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to read updated item parameter for list " + listName + " (" + e.getMessage() + ")");
                }
                ++i;
            }
            if (this.myUpdates.size() == 0) {
                throw new IllegalArgumentException("didn't contain any valid update parameters");
            }
        }

        public List<CommissioningParameter> getMatches() {
            return this.myMatches;
        }

        public List<CommissioningParameter> getUpdates() {
            return this.myUpdates;
        }
    }

    private static enum Operation {
        UPDATE,
        DELETE,
        CREATE;

    }

    private static enum Type {
        PARAMETER,
        ITEMLIST,
        SCALARLIST;

    }
}

