/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.CommissioningParameter;
import com.nokia.em.bts.coreasset.application.tools.CommissioningResults;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.HwModelUtil;
import com.nokia.em.bts.coreasset.application.util.ProductInfo;
import com.nokia.em.bts.coreasset.application.util.RP3LinkModel;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.scenario.ScenarioManager;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.fileoperation.FileActivationListener;
import com.nokia.em.bts.coreasset.scenario.fileoperation.SendFileToBTSListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoAdapter;
import com.nokia.em.bts.rp.master.connection.ConnectionInfoListener;
import com.nokia.em.bts.rp.master.tool.Tools;
import com.nokia.em.poseidon.frameworks.raml.RAMLCMData;
import com.nokia.em.poseidon.frameworks.raml.RAMLExtension;
import com.nokia.em.poseidon.frameworks.raml.RAMLFile;
import com.nokia.em.poseidon.frameworks.raml.RAMLHeader;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLList;
import com.nokia.em.poseidon.frameworks.raml.RAMLLogEntry;
import com.nokia.em.poseidon.frameworks.raml.RAMLManagedObject;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaDataFile;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommissioningSingle
extends ToolBase {
    private static final String COLON = ":";
    private static final String SER_NUM = "serNum";
    private static final String PROD_CODE = "prodCode";
    private static final String SMOD_PORT = "sModPort";
    private static final String DETECTED_SMOD_PORT = "DetectedSmodPort";
    private static final String DETECTED_SMOD_ID = "detectedSmodId";
    private static final String SMOD_ID = "sModId";
    private static final String BBMOD_ID = "bbModId";
    private static final String VARIANT_X = "x";
    private static final String PLUG_IN_UNIT = "Plug.In.Unit";
    private static final String PLUG_IN_UNIT_TRUE = "true";
    private static final String LINK_MASTER_ID = "LinkMasterID";
    private static final String PRIMARY_CONNECTION_NONE = "None";
    private static final String CONNECTION_LIST = "connectionList";
    private static final String DASH_IF = "-IF";
    private static final String PRIMARY_CONNECTION = "primaryConnection";
    private static final String UNIT_TYPE_FR = "FR";
    private static final String UNIT_LIST = "unitList";
    private static final String ARG_DELTAFILE = "deltafile";
    private static final String ARG_AC = "ac";
    private static final String ARG_FULLFILE = "fullfile";
    private static final String ARG_WAITFORRESET = "waitforreset";
    private static final String AND = " and ";
    private static final String VALIDATIONRESULTS_PREFIX = "validationresults_";
    private static final int RECONNECT_RETRY_COUNT = 4;
    private static final String FULL_FILE_EXTENSION = "_full.xml";
    private static final String CL = "cl";
    private static final String CL_JAR = "cl.jar";
    private static final String USER = "UICA";
    private static final String TXT_EXTENSION = ".txt";
    private static final String XML_EXTENSION = ".xml";
    private static final String PROD_CODE_PLANNED = "prodCodePlanned";
    private static final String TECHNOLOGY = "technology";
    private static final String EUTRA = "EUTRA";
    private static final String UTRAN = "UTRAN";
    private static final String LINKID = "linkId";
    private static final String POSITIONINCHAIN = "positionInChain";
    private static final String MRBTS = "MRBTS";
    private static final String FTM = "FTM";
    private static final String DISTNAME = "distName";
    private static final String BTSEXTENSIONS = "BTSExtensions";
    private static final String TRANSPORTEXTENSIONS = "transportExtensions";
    private static final String SCFSCOPE = "scfScope";
    private static final String FULL = "full";
    private static final String DELTA = "DELTA";
    private static final String CREATED = "created";
    private static final String RMOD = "RMOD";
    private static final String SMOD = "SMOD";
    private static final String BBMOD = "BBMOD";
    private static final String UPDATE = "update";
    private static final String CLASS = "class";
    private static final String CDNL_BTS = "CDNL_BTS";
    private static final String POSITION_IN_CHAIN = "PositionInChain";
    private static final String FSM = "FSM";
    private static final String CORE_FSM = "CORE_FSM";
    private static final String FR = "FR";
    private static final String CORE_FR = "CORE_FR";
    private static final String FSP = "FSP";
    private static final String LINKMASTERID = "LinkMasterID";
    protected static final String WCDMA = "WCDMA";
    private static final String DASH = "-";
    private static final String UNDERSCORE = "_";
    private static final String CL_PATH = "." + FS + ".." + FS + ".." + FS;
    private static final String ARG_PARAMETER = "parameter";
    private static final String ARG_PARAMETER_FILE = "parameterfile";
    private static final String ARG_VALIDATE = "validate";
    private static final String UNIT_TYPE_FSP = "FSP";
    private static final String UNIT_TYPE_FSM = "FSM";
    private static final String UNIT_NAME = "unitName";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String VARIANT = "variant";
    protected static final String SCOPE = "scope";
    protected static final String PLAN = "plan";
    protected static final String ALL = "all";
    protected static final String TYPE = "type";
    protected static final String ID = "id";
    protected static final long BTSSM_GENERAL_PLAN_ID = 0xC0000000L;
    protected boolean myTimeouted = true;
    private boolean myActivationreceived = false;
    private String myCLPath;
    private String myAddress;
    protected boolean myWaitForReset = false;
    private int myBtsId = 0;

    @Override
    protected void reset() {
        this.myTimeouted = true;
        this.myWaitForReset = false;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.myTimeout = 240000;
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        this.myWaitForReset = args.isDefined(ARG_WAITFORRESET);
        String fullfile = args.getFirstValue(ARG_FULLFILE);
        String deltafile = args.getFirstValue(ARG_DELTAFILE);
        if (deltafile == null) {
            deltafile = args.getFirstValue(ARG_AC);
        }
        String parameters = args.getFirstValue(ARG_PARAMETER);
        String parameterFile = args.getFirstValue(ARG_PARAMETER_FILE);
        this.myCLPath = args.getFirstValue(ARG_VALIDATE);
        List<Object> params = new ArrayList();
        boolean parametersOk = true;
        if (parameters != null) {
            StringTokenizer st = new StringTokenizer(parameters, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                try {
                    params.add(new CommissioningParameter(s));
                }
                catch (Exception e) {
                    Console.error("Invalid parameter format: " + s);
                    parametersOk = false;
                }
            }
        }
        if (parameterFile != null) {
            params = this.readParams(parameterFile);
        }
        CommissioningResults result = new CommissioningResults(this.myAddress);
        if (fullfile == null && deltafile == null && (params == null || params.isEmpty()) || !parametersOk) {
            Console.error("No valid parameters or file given");
            result.setFeedback("Invalid parameters");
            result.setOK(false);
            result.setExitCode(24);
            return result;
        }
        if (!this.isCLPathValid(this.myCLPath)) {
            Console.error("Cannot locate BTSSM for validation");
            result.setFeedback("Invalid validation path");
            result.setOK(false);
            result.setExitCode(23);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(30);
            } else {
                ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connectionInfo.getConnection());
                String techType = site.getNetworkType();
                this.myBtsId = site.getId();
                boolean isLTE = !techType.toUpperCase().contains(WCDMA);
                int fileType = isLTE ? 97 : 96;
                String path = null;
                path = fullfile != null ? this.createFile(connectionInfo, fullfile, site, isLTE, true) : (deltafile != null ? this.createFile(connectionInfo, deltafile, site, isLTE, false) : this.createDeltaFile(params, connectionInfo, (ScenarioManager)scenarioManager, isLTE));
                if (path == null) {
                    result.setOK(false);
                    result.setExitCode(26);
                    result.setFeedback("Failed to create SCF");
                    this.disconnect(connectionInfo, disconnect);
                    return result;
                }
                if (path.length() == 0) {
                    result.setCommissioningOK(false);
                    result.setFeedback("No changes");
                    result.setExitCode(31);
                    this.disconnect(connectionInfo, disconnect);
                    return result;
                }
                this.sendSCF(path, (ScenarioManager)scenarioManager, fileType, result);
                if (!(this.myDebug || path.equalsIgnoreCase(fullfile) || path.equalsIgnoreCase(deltafile))) {
                    Tools.deleteFile((File)new File(path));
                }
                if (this.myTimeouted) {
                    result.setCommissioningOK(false);
                    result.setFeedback("Timeout");
                    result.setExitCode(8);
                } else if (result.isCommissioningOK()) {
                    this.activate(result, (ScenarioManager)scenarioManager, fileType);
                    if (!this.myTimeouted && this.myWaitForReset) {
                        this.waitForReset(connectionInfo);
                        if (!this.myTimeouted) {
                            BTSConnection connection = this.reconnect(username, password, credentials);
                            if (c != null) {
                                c.setConnection(connection);
                            }
                        } else {
                            Console.error("Reset timeout in " + this.myAddress);
                            result.setFeedback("Reset timeout");
                            result.setExitCode(8);
                            result.setActivationOK(false);
                        }
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    protected BTSConnection reconnect(String username, String password, Map<String, String> credentials) {
        ConnectionInformation connectionInfo;
        Console.info("Reset started in " + this.myAddress);
        Console.info("Reconnecting in 3 minutes to " + this.myAddress + "...");
        try {
            Thread.sleep(180000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = 0;
        while (!(connectionInfo = this.connect(this.myAddress, username, password, credentials)).isConnected() && count++ < 4) {
        }
        if (connectionInfo.isConnected()) {
            Console.info("Reset finished in " + this.myAddress);
        } else {
            Console.info("Reconnection timeout in " + this.myAddress);
        }
        return connectionInfo.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForReset(ConnectionInformation connectionInfo) {
        ConnectionInfoAdapter connListener = new ConnectionInfoAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void btsDisconnected() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    CommissioningSingle.this.myTimeouted = false;
                    ((Object)((Object)this)).notify();
                }
            }
        };
        connectionInfo.getConnection().addConnectionInfoListener((ConnectionInfoListener)connListener);
        this.myTimeouted = true;
        Console.info("Waiting 5 minutes for reset in " + this.myAddress);
        ConnectionInfoAdapter connectionInfoAdapter = connListener;
        synchronized (connectionInfoAdapter) {
            try {
                connListener.wait(300000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        connectionInfo.getConnection().removeConnectionInfoListener((ConnectionInfoListener)connListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(CommissioningResults result, ScenarioManager scenarioManager, int fileType) {
        FListener activationListener;
        this.myTimeouted = true;
        FListener fListener = activationListener = new FListener(result);
        synchronized (fListener) {
            if (!this.myActivationreceived) {
                try {
                    if (this.myVerbose) {
                        Console.debug("Activating SCF in " + this.myAddress);
                    }
                    scenarioManager.getFileActivationScenario((FileActivationListener)activationListener, fileType, 0xC0000000L).execute();
                    activationListener.wait(this.myTimeout);
                    if (this.myTimeouted) {
                        Console.error("Activation timeout with " + this.myAddress);
                        result.setFeedback("Activation timeout");
                        result.setExitCode(28);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSCF(String path, ScenarioManager scenarioManager, int fileType, CommissioningResults result) {
        FileSendingListener fileListener;
        FileSendingListener fileSendingListener = fileListener = new FileSendingListener(result);
        synchronized (fileSendingListener) {
            try {
                if (this.myVerbose) {
                    Console.debug("Sending SCF to " + this.myAddress);
                }
                scenarioManager.getSendFileToBTSScenario((SendFileToBTSListener)fileListener, fileType, path, true).execute();
                fileListener.wait(300000L);
                if (this.myTimeouted) {
                    Console.error(String.valueOf(this.getToolName()) + " timeout with " + this.myAddress);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String createFile(ConnectionInformation c, String scf, Site site, boolean isLTE, boolean modify) {
        String path = new File(scf).getAbsolutePath();
        RAMLFile raml = null;
        try {
            raml = new RAMLFile(scf);
        }
        catch (Exception e) {
            Console.error("Failed to load SCF " + scf, e);
        }
        if (raml != null) {
            File f;
            block19: {
                block20: {
                    try {
                        RAMLManagedObject mrbtsMO;
                        RAMLExtension extension;
                        RAMLCMData cmData = (RAMLCMData)raml.getCMData().get(0);
                        if (modify) {
                            cmData.setAttribute(TYPE, PLAN);
                            cmData.setAttribute(ID, String.valueOf(0xC0000000L));
                            cmData.setAttribute(SCOPE, ALL);
                        }
                        if (modify && cmData.getMOsByClass(MRBTS).size() > 0 && (extension = (mrbtsMO = (RAMLManagedObject)cmData.getMOsByClass(MRBTS).get(0)).getExtension(BTSEXTENSIONS)) == null) {
                            extension = new RAMLExtension();
                            extension.setName(BTSEXTENSIONS);
                            extension.setParameter(new RAMLParameter(SCOPE, FULL));
                            mrbtsMO.addExtension(extension);
                        }
                    }
                    catch (Exception e) {
                        Console.error("Failed to modify SCF for " + this.myAddress, e);
                    }
                    f = new File(this.createSCFFileName(isLTE, this.myBtsId));
                    raml.writeTo(f.getAbsolutePath());
                    if (this.myCLPath == null) break block19;
                    if (!this.myCLPath.endsWith(XML_EXTENSION)) break block20;
                    if (!this.validateWithMetadata(raml)) {
                        if (!f.delete()) {
                            f.deleteOnExit();
                        }
                        return null;
                    }
                    break block19;
                }
                if (this.validateWithCL(f)) break block19;
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                return null;
            }
            try {
                if (c.isGzippedCommissioningFileNeeded()) {
                    File f2 = Tools.gZip((File)f);
                    if (f2 != null) {
                        path = f2.getAbsolutePath();
                        if (!f.delete()) {
                            f.deleteOnExit();
                        }
                    } else {
                        path = f.getAbsolutePath();
                    }
                } else {
                    path = f.getAbsolutePath();
                }
            }
            catch (Exception e) {
                Console.error("Failed to create temporary SCF for " + this.myAddress, e);
            }
        }
        return path;
    }

    private String getFSMSerialNumber(Site site, int fsmId) {
        try {
            List units = site.getCabinet().getUnits();
            for (Unit unit : units) {
                if (!unit.getUnitType().equalsIgnoreCase("FSM") || unit.getNumber() != fsmId) continue;
                for (Unit containedUnit : unit.getContainedUnits()) {
                    if (!containedUnit.getUnitType().equalsIgnoreCase(CORE_FSM)) continue;
                    return containedUnit.getSerialNro();
                }
                return unit.getSerialNro();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to get serial number for system module from siteconf", (Throwable)e);
        }
        return "";
    }

    private int getUnitNumberFor(Unit unit) {
        if ("FR".equalsIgnoreCase(unit.getUnitType())) {
            String pos = unit.getCustomAttributeValue(POSITION_IN_CHAIN);
            if (pos == null) {
                return 1;
            }
            return Integer.valueOf(pos);
        }
        return unit.getNumber();
    }

    private String getPrimaryConnectionFor(Unit unit, Site site) {
        if ("FR".equalsIgnoreCase(unit.getUnitType())) {
            return SMOD + site.getUnit(Integer.valueOf(unit.getCustomAttributeValue("LinkMasterID")).intValue()).getNumber() + DASH_IF + unit.getNumber();
        }
        return PRIMARY_CONNECTION_NONE;
    }

    private List<Unit> getUnitsWithType(Site site, String unitType) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit unit : site.getCabinet().getUnits()) {
            if (!unit.getUnitType().equalsIgnoreCase(unitType)) continue;
            if (unitType.equals("FSP") && PLUG_IN_UNIT_TRUE.equalsIgnoreCase(unit.getCustomAttributeValue(PLUG_IN_UNIT))) {
                units.add(unit);
                continue;
            }
            if (unitType.equals("FSM") && !unit.getVariant().equalsIgnoreCase(VARIANT_X)) {
                units.add(unit);
                continue;
            }
            if (!unitType.equals("FR")) continue;
            units.add(unit);
        }
        return units;
    }

    private boolean validateWithMetadata(RAMLFile raml) {
        if (this.myVerbose) {
            Console.debug("Started to validate SCF for " + this.myAddress);
        }
        try {
            StringTokenizer st = new StringTokenizer(this.myCLPath, ",");
            while (st.hasMoreTokens()) {
                raml.addMetaData(new RAMLMetaDataFile(st.nextToken()));
            }
            RAMLValidationContext context = new RAMLValidationContext("cli");
            raml.validate(context);
            if (context.getResults().size() > 0) {
                String s = VALIDATIONRESULTS_PREFIX + this.myAddress + XML_EXTENSION;
                context.writeToFile(new File(s));
                Console.error("SCF validation failed for " + this.myAddress + ". Check " + s + " for details.");
                return false;
            }
        }
        catch (Exception e) {
            Console.error("Failed to validate SCF for " + this.myAddress, e);
            return false;
        }
        if (this.myVerbose) {
            Console.debug("Successfully validated SCF for " + this.myAddress);
        }
        return true;
    }

    private boolean validateWithCL(File scf) {
        File validationResultFile;
        block18: {
            if (this.myVerbose) {
                Console.debug("Started to validate SCF for " + this.myAddress);
            }
            if (this.myCLPath.endsWith(FS)) {
                this.myCLPath = this.myCLPath.substring(0, this.myCLPath.length() - 1);
            }
            if (!new File(String.valueOf(this.myCLPath) + FS + CL + FS + CL_JAR).exists()) {
                Logger.getLogger(this.getClass()).fatal((Object)("Cannot find " + this.myCLPath + FS + CL + FS + CL_JAR));
                if (this.myCLPath.equals(CL_PATH)) {
                    Console.error("Cannot validate SCF for " + this.myAddress + ". Check path.");
                    return false;
                }
                this.myCLPath = CL_PATH;
                if (!new File(String.valueOf(this.myCLPath) + FS + CL + FS + CL_JAR).exists()) {
                    Console.error("Cannot validate SCF for " + this.myAddress + ". Check path.");
                    return false;
                }
            }
            try {
                StringBuffer errorText;
                block19: {
                    File streamResultFile;
                    String validationResults = String.valueOf(System.getProperty("user.dir")) + FS + VALIDATIONRESULTS_PREFIX + this.myAddress + XML_EXTENSION;
                    String streamResults = "error_" + this.myAddress + TXT_EXTENSION;
                    validationResultFile = new File(validationResults);
                    if (validationResultFile.exists()) {
                        validationResultFile.delete();
                    }
                    if ((streamResultFile = new File(streamResults)).exists()) {
                        streamResultFile.delete();
                    }
                    Process p = Runtime.getRuntime().exec("java -Djava.awt.headless=true -cp ." + FS + CL + FS + "cl.jar com.nokia.em.poseidon.PoseidonStarter -nogui -confFile ." + FS + CL + FS + "CLConf.xml -planfile \"" + scf.getAbsolutePath() + "\" -feedbackfile " + validationResults, null, new File(new File(this.myCLPath).getAbsolutePath()));
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String line = null;
                    StringBuffer errorStream = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        errorStream.append(line).append(System.getProperty("line.separator"));
                    }
                    p.waitFor();
                    if (p.exitValue() == 0) break block18;
                    errorText = new StringBuffer("SCF validation failed for " + this.myAddress + ". Check ");
                    if (errorStream.toString().length() > 0) {
                        try {
                            FileWriter fw = new FileWriter(streamResults);
                            fw.write(errorStream.toString());
                            fw.close();
                            errorText.append(streamResults);
                            if (validationResultFile.exists()) {
                                errorText.append(AND);
                            }
                        }
                        catch (Exception e) {
                            if (validationResultFile.exists()) break block19;
                            errorText = new StringBuffer("SCF validation failed for " + this.myAddress + ". Check tool's log file");
                        }
                    }
                }
                if (validationResultFile.exists()) {
                    errorText.append(validationResultFile.getName());
                }
                errorText.append(" for details.");
                Console.error(errorText.toString());
                return false;
            }
            catch (Exception e) {
                Console.error("Failed to validate SCF for " + this.myAddress, e);
                return false;
            }
        }
        if (validationResultFile.exists() && !validationResultFile.delete()) {
            validationResultFile.deleteOnExit();
        }
        if (this.myVerbose) {
            Console.debug("Successfully validated SCF for " + this.myAddress);
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String createDeltaFile(List<CommissioningParameter> params, ConnectionInformation c, ScenarioManager s, boolean isLTE) {
        RAMLFile trsRaml;
        File trsscf;
        RAMLFile raml;
        File btsscf = this.getBTSSCF(c, s);
        if (btsscf == null) {
            Console.error("Failed to get BTS SCF from " + this.myAddress);
            return null;
        }
        if (this.myVerbose) {
            Console.debug("Successfully got BTS SCF from " + this.myAddress);
        }
        try {
            try {
                raml = new RAMLFile(btsscf);
            }
            catch (Exception e) {
                Console.error("Failed to create BTS RAML model from " + this.myAddress, e);
                if (!this.myDebug && !btsscf.delete()) {
                    btsscf.deleteOnExit();
                }
                return null;
            }
        }
        finally {
            if (!this.myDebug && !btsscf.delete()) {
                btsscf.deleteOnExit();
            }
        }
        if (raml.getCMData().isEmpty()) {
            Console.error("Failed to get BTS cmData from " + c.getAddress());
            return null;
        }
        if (this.myVerbose) {
            Console.info("Getting TRS SCF from " + this.myAddress);
        }
        if ((trsscf = this.getTRSXMLFile(c.getConnection(), c.getTRSAddress())) == null) {
            Console.error("Failed to get TRS SCF from " + c.getAddress());
            return null;
        }
        if (this.myVerbose) {
            Console.debug("Successfully got TRS SCF from " + this.myAddress);
        }
        try {
            try {
                trsRaml = new RAMLFile(trsscf);
            }
            catch (Exception e) {
                Console.error("Failed to create TRS RAML model from " + this.myAddress, e);
                if (!this.myDebug && !trsscf.delete()) {
                    trsscf.deleteOnExit();
                }
                return null;
            }
        }
        finally {
            if (!this.myDebug && !trsscf.delete()) {
                trsscf.deleteOnExit();
            }
        }
        if (trsRaml.getCMData().isEmpty()) {
            Console.error("Failed to get TRS cmData from " + c.getAddress());
            return null;
        }
        if (this.myVerbose) {
            Console.debug("Starting to create delta SCF for " + this.myAddress);
        }
        try {
            RAMLCMData cmData = (RAMLCMData)raml.getCMData().get(0);
            List trsManagedObjects = ((RAMLCMData)trsRaml.getCMData().get(0)).getMOs();
            for (RAMLManagedObject trsManagedObject : trsManagedObjects) {
                if (cmData.getMO(trsManagedObject.getDistName(), trsManagedObject.getOperation()) != null) continue;
                cmData.addMO(trsManagedObject);
            }
            cmData.setAttribute(TYPE, PLAN);
            cmData.setAttribute(ID, String.valueOf(0xC0000000L));
            cmData.setAttribute(SCOPE, ALL);
            RAMLHeader header = cmData.getHeader();
            if (header == null) {
                header = new RAMLHeader();
                cmData.setHeader(header);
            }
            this.updateHeader(header);
            TreeSet<String> keepManagedObjects = new TreeSet<String>();
            boolean trs = false;
            boolean parametersOk = true;
            List managedObjects = ((RAMLCMData)raml.getCMData().get(0)).getMOs();
            int count = 0;
            for (RAMLManagedObject managedObject : managedObjects) {
                String name;
                String className = managedObject.getAttribute(CLASS);
                if (className.contains(COLON)) {
                    className = className.split(COLON)[1];
                }
                String distName2 = managedObject.getAttribute(DISTNAME);
                TreeSet<String> keepParameters = new TreeSet<String>();
                TreeSet<String> keepLists = new TreeSet<String>();
                for (CommissioningParameter param : params) {
                    RAMLList list;
                    name = param.getManagedObjectName();
                    String distNameSuffix = param.getDistNameSuffix();
                    String id = param.getInstanceId();
                    String listName = param.getListName();
                    String paramName = param.getName();
                    String paramValue = param.getValue();
                    if (name != null && (!name.equalsIgnoreCase(className) || id != null && (distName2 == null || !distName2.toUpperCase().endsWith(String.valueOf(distNameSuffix.toUpperCase()) + DASH + id.toUpperCase())))) continue;
                    if (param.isParameter()) {
                        RAMLParameter parameter = managedObject.getParameter(paramName);
                        if (parameter != null) {
                            parameter.setValue(paramValue);
                            managedObject.setOperation(UPDATE);
                            ++count;
                            keepManagedObjects.add(distName2);
                            keepParameters.add(paramName);
                            param.addUpdatedManagedObjectName(className);
                            if (distName2.contains(FTM)) {
                                trs = true;
                            }
                            if (this.myVerbose) {
                                Console.debug("Updated " + paramName + " value in " + distName2 + " to " + paramValue + " for " + this.myAddress);
                            }
                        }
                        if (listName == null) continue;
                        RAMLList list2 = managedObject.getList(listName);
                        if (list2 instanceof RAMLItemList) {
                            List items = ((RAMLItemList)list2).getAllItems();
                            for (RAMLItem rAMLItem : items) {
                                parameter = rAMLItem.getParameter(paramName);
                                if (parameter == null) continue;
                                parameter.setValue(paramValue);
                                managedObject.setOperation(UPDATE);
                                ++count;
                                keepManagedObjects.add(distName2);
                                keepLists.add(listName);
                                param.addUpdatedManagedObjectName(className);
                                if (distName2.contains(FTM)) {
                                    trs = true;
                                }
                                if (!this.myVerbose) continue;
                                Console.debug("Updated " + paramName + " value in " + distName2 + " to " + paramValue + " for " + this.myAddress);
                            }
                            continue;
                        }
                        if (list2 == null) continue;
                        Console.error("Parameter " + paramName + " had list name " + listName + " defined but it is a scalar list in " + c.getAddress());
                        parametersOk = false;
                        continue;
                    }
                    if (param.isItemList()) {
                        list = managedObject.getList(paramName);
                        if (list instanceof RAMLItemList) {
                            RAMLItemList itemList = (RAMLItemList)list;
                            boolean changed = false;
                            if (param.hasOldValue()) {
                                for (CommissioningParameter.Item item : param.getItems()) {
                                    for (Iterator<Object> ramlItem : itemList.getAllItems()) {
                                        RAMLParameter rp;
                                        boolean doesMatch = true;
                                        for (CommissioningParameter match : item.getMatches()) {
                                            rp = ramlItem.getParameter(match.getName());
                                            if (rp != null && rp.getValue().equalsIgnoreCase(match.getValue())) continue;
                                            doesMatch = false;
                                            break;
                                        }
                                        if (!doesMatch) continue;
                                        for (CommissioningParameter update : item.getUpdates()) {
                                            rp = ramlItem.getParameter(update.getName());
                                            if (rp == null) continue;
                                            rp.setValue(update.getValue());
                                            changed = true;
                                            if (!this.myVerbose) continue;
                                            Console.debug("Updated " + rp.getName() + " value in " + itemList.getName() + " in " + distName2 + " to " + update.getValue() + " for " + this.myAddress);
                                        }
                                    }
                                }
                            } else {
                                Iterator<Object> ramlItem;
                                ArrayList arrayList = new ArrayList(itemList.getAllItems());
                                for (RAMLItem rAMLItem : arrayList) {
                                    itemList.remove(rAMLItem);
                                }
                                ramlItem = param.getItems().iterator();
                                while (ramlItem.hasNext()) {
                                    CommissioningParameter.Item item = (CommissioningParameter.Item)ramlItem.next();
                                    RAMLItem ramlItem2 = new RAMLItem();
                                    for (CommissioningParameter p : item.getUpdates()) {
                                        ramlItem2.addParameter(new RAMLParameter(p.getName(), p.getValue()));
                                    }
                                    itemList.add(ramlItem2);
                                }
                                changed = true;
                                if (this.myVerbose) {
                                    Console.debug("Updated all " + itemList.getName() + " values in " + distName2 + " for " + this.myAddress);
                                }
                            }
                            if (!changed) continue;
                            managedObject.setOperation(UPDATE);
                            ++count;
                            keepManagedObjects.add(distName2);
                            keepLists.add(list.getName());
                            if (!distName2.contains(FTM)) continue;
                            trs = true;
                            continue;
                        }
                        if (list == null) continue;
                        Console.error("Cannot update scalar list " + paramName + " with list items in " + c.getAddress() + " for " + this.myAddress);
                        parametersOk = false;
                        continue;
                    }
                    if (!param.isScalarList()) continue;
                    list = managedObject.getList(paramName);
                    if (list instanceof RAMLParameterList) {
                        RAMLParameterList paramList = (RAMLParameterList)list;
                        boolean changed = false;
                        if (param.hasOldValue()) {
                            for (CommissioningParameter commissioningParameter : param.getScalarParameters()) {
                                List ramlParams = paramList.getListObjects();
                                for (RAMLParameter ramlParam : ramlParams) {
                                    if (!commissioningParameter.getOldValue().equalsIgnoreCase(ramlParam.getValue())) continue;
                                    ramlParam.setValue(commissioningParameter.getValue());
                                    changed = true;
                                    if (!this.myVerbose) continue;
                                    Console.debug("Replaced old scalar list value " + commissioningParameter.getOldValue() + " with " + commissioningParameter.getValue() + " in " + paramName + " for " + this.myAddress);
                                }
                            }
                        } else {
                            List list3 = paramList.getParameters();
                            for (RAMLParameter rAMLParameter : list3) {
                                paramList.remove((Object)rAMLParameter);
                            }
                            for (CommissioningParameter commissioningParameter : param.getScalarParameters()) {
                                paramList.add((Object)new RAMLParameter(commissioningParameter.getName(), commissioningParameter.getValue()));
                            }
                            changed = true;
                            if (this.myVerbose) {
                                Console.debug("Replaced all scalar list values in " + paramName + " for " + this.myAddress);
                            }
                        }
                        if (!changed) continue;
                        managedObject.setOperation(UPDATE);
                        ++count;
                        keepManagedObjects.add(distName2);
                        keepLists.add(list.getName());
                        continue;
                    }
                    if (list == null) continue;
                    Console.error("Cannot update item list " + paramName + " with scalar parameters in " + c.getAddress() + " for " + this.myAddress);
                    parametersOk = false;
                }
                for (CommissioningParameter param : params) {
                    if (param.getUpdatedManagedObjectNames().size() <= 1) continue;
                    Console.error("Parameter " + param.getName() + " found from more than one type of managedObject (" + param.getUpdatedManagedObjectNamesString() + ") in " + this.myAddress);
                    parametersOk = false;
                }
                if (this.myCLPath != null) {
                    if (this.myCLPath.endsWith(XML_EXTENSION)) {
                        if (!this.validateWithMetadata(raml)) {
                            return null;
                        }
                    } else {
                        File f = new File(String.valueOf(this.myAddress) + FULL_FILE_EXTENSION);
                        raml.writeTo(f.getName());
                        boolean ok = this.validateWithCL(f);
                        if (!f.delete()) {
                            f.deleteOnExit();
                        }
                        if (!ok) {
                            return null;
                        }
                    }
                }
                for (RAMLParameter parameter : managedObject.getParameters()) {
                    name = parameter.getName();
                    if (keepParameters.contains(name)) continue;
                    managedObject.removeParameter(name);
                }
                for (RAMLList list : managedObject.getLists()) {
                    name = list.getName();
                    if (keepLists.contains(name)) continue;
                    managedObject.removeList(name);
                }
            }
            if (!parametersOk) {
                return null;
            }
            for (RAMLManagedObject managedObject : managedObjects) {
                String distName = managedObject.getDistName();
                if (MRBTS.equals(managedObject.getAttribute(CLASS))) {
                    try {
                        this.myBtsId = Integer.valueOf(distName.substring(distName.lastIndexOf(DASH) + 1));
                    }
                    catch (Exception distName2) {}
                } else if (FTM.equals(managedObject.getAttribute(CLASS)) && trs) {
                    keepManagedObjects.add(distName);
                    if (managedObject.getExtension(TRANSPORTEXTENSIONS) == null) {
                        RAMLExtension extension = new RAMLExtension();
                        extension.setName(TRANSPORTEXTENSIONS);
                        extension.setParameter(new RAMLParameter(SCFSCOPE, DELTA));
                        managedObject.addExtension(extension);
                        managedObject.setOperation(UPDATE);
                        if (this.myVerbose) {
                            Console.debug("transportExtensions created for " + this.myAddress);
                        }
                    }
                }
                if (keepManagedObjects.contains(distName)) continue;
                cmData.removeMO(managedObject);
            }
            if (cmData.getMOs().size() == 0) {
                Console.info("No changes to " + this.myAddress + ", skipped.");
                return "";
            }
            File f = new File(this.createSCFFileName(isLTE, this.myBtsId));
            raml.writeTo(f.getAbsolutePath());
            if (this.myVerbose) {
                Console.debug("Successfully created delta SCF with " + count + " changes for " + this.myAddress);
            }
            if (c.isGzippedCommissioningFileNeeded()) {
                File f2 = Tools.gZip((File)f);
                if (f2 != null) {
                    if (!f.delete()) {
                        f.deleteOnExit();
                    }
                    return f2.getAbsolutePath();
                }
                return f.getAbsolutePath();
            }
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            Console.error("Failed to create delta SCF for " + this.myAddress, e);
            return null;
        }
    }

    protected String createSCFFileName(boolean isLTE, int btsId) {
        File addressFolder = new File("commission_" + this.myAddress);
        if (!addressFolder.exists() && !addressFolder.mkdir()) {
            Console.error("Failed to create folder: " + addressFolder);
        }
        addressFolder.deleteOnExit();
        return String.valueOf(addressFolder.getName()) + FS + CDNL_BTS + (isLTE ? "A" : "C") + UNDERSCORE + btsId + UNDERSCORE + 0xC0000000L + XML_EXTENSION;
    }

    private void updateHeader(RAMLHeader header) {
        while (header.getLogs().size() > 0) {
            header.removeLog((RAMLLogEntry)header.getLogs().get(0));
        }
        RAMLLogEntry logEntry = new RAMLLogEntry();
        logEntry.setAppInfo(String.valueOf(this.getToolName()) + " Tool");
        logEntry.setAppVersion("4.14");
        logEntry.setUser(USER);
        logEntry.setDateTime(new Date().toString());
        logEntry.setAction(CREATED);
        header.addLog(logEntry);
    }

    private String getFRSerialNumber(Site site, int linkId, int positionInChain, int sModId) {
        List units = site.getCabinet().getUnits();
        for (Unit unit : units) {
            try {
                if (!unit.getUnitType().equalsIgnoreCase("FR") || Integer.valueOf(unit.getCustomAttributeValue(POSITION_IN_CHAIN)) != positionInChain || site.getUnit(Integer.valueOf(unit.getCustomAttributeValue("LinkMasterID")).intValue()).getNumber() != sModId || unit.getNumber() != linkId) continue;
                for (Unit containedUnit : unit.getContainedUnits()) {
                    if (!containedUnit.getUnitType().equalsIgnoreCase(CORE_FR)) continue;
                    return containedUnit.getSerialNro();
                }
                return unit.getSerialNro();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to get serial number for radio module from siteconf", (Throwable)e);
            }
        }
        Logger.getLogger(this.getClass()).error((Object)("Failed to get serial number for radio module " + linkId + " from siteconf"));
        return "";
    }

    private String getFRProductCode(Site site, RP3LinkModel model, ConnectionInformation conn) {
        Unit unit;
        block7: {
            block6: {
                try {
                    unit = null;
                    if (ProductInfo.isSmallCell(conn.getProduct())) {
                        for (Unit u : site.getCabinet().getUnits()) {
                            if (!"FR".equals(u.getUnitType()) || u.getNumber() != model.getInterfaceNumber()) continue;
                            return u.getProductCode();
                        }
                        break block6;
                    }
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
            unit = this.isAfterRL70(conn) ? HwModelUtil.findUnitByRP3LinkModelNewThanLN70(site, "FR", model) : HwModelUtil.findUnitByRP3LinkModelOlderThanLN70(site, "FR", model);
            if (unit != null) break block7;
            Logger.getLogger(this.getClass()).error((Object)("Failed to get product code for radio module " + model.getInterfaceNumber() + " from siteconf"));
            return "";
        }
        Logger.getLogger(this.getClass()).error((Object)("Failed to get product code for radio module " + model.getInterfaceNumber() + " from siteconf"));
        return unit.getProductCode();
    }

    private String getFSMProductCode(Site site, int fsmId) {
        try {
            List units = site.getCabinet().getUnits();
            for (Unit unit : units) {
                if (!unit.getUnitType().equalsIgnoreCase("FSM") || unit.getNumber() != fsmId) continue;
                return unit.getProductCode();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)"Failed to parse FSM productCode", (Throwable)e);
        }
        Logger.getLogger(this.getClass()).error((Object)("Failed to get product code for system module " + fsmId + " from siteconf"));
        return "";
    }

    private String getFSPProductCode(Site site, int id, int port) {
        List units = site.getCabinet().getUnits();
        for (Unit unit : units) {
            if (!unit.getUnitType().equalsIgnoreCase("FSP")) continue;
            try {
                String smodPort;
                String smodId = this.getSmodId(site, unit);
                if (smodId == null || (smodPort = this.getSmodPort(unit)) == null || id != Integer.valueOf(smodId) || port != Integer.valueOf(smodPort)) continue;
                return unit.getProductCode();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to parse FSP productCode", (Throwable)e);
            }
        }
        Logger.getLogger(this.getClass()).error((Object)("Failed to get product code for BBMOD-" + id + " from siteconf"));
        return "";
    }

    private String getSmodPort(Unit unit) {
        String smodPort = unit.getCustomAttributeValue(DETECTED_SMOD_PORT);
        if (smodPort == null) {
            smodPort = unit.getCustomAttributeValue(SMOD_PORT);
        }
        return smodPort;
    }

    private String getSmodId(Site site, Unit unit) {
        String smodId = unit.getCustomAttributeValue(SMOD_ID);
        if (smodId == null && (smodId = unit.getCustomAttributeValue(DETECTED_SMOD_ID)) != null) {
            smodId = String.valueOf(site.getUnit(Integer.valueOf(smodId).intValue()).getNumber());
        }
        return smodId;
    }

    private boolean isCLPathValid(String s) {
        if (s == null || s.toUpperCase().endsWith(".XML")) {
            return true;
        }
        String path = s;
        if (path.endsWith(FS)) {
            path = path.substring(0, path.length() - 1);
        }
        if (new File(String.valueOf(path) + FS + CL + FS + CL_JAR).exists()) {
            return true;
        }
        Logger.getLogger(this.getClass()).fatal((Object)("Cannot find " + path + FS + CL + FS + CL_JAR));
        if (!path.equals(CL_PATH)) {
            if (new File(String.valueOf(CL_PATH) + FS + CL + FS + CL_JAR).exists()) {
                return true;
            }
            Logger.getLogger(this.getClass()).fatal((Object)("Cannot find " + path + FS + CL + FS + CL_JAR));
        }
        return false;
    }

    private List<CommissioningParameter> readParams(String file) {
        ArrayList<CommissioningParameter> l = new ArrayList<CommissioningParameter>();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList parameters = doc.getDocumentElement().getChildNodes();
            boolean parametersOk = true;
            int i = 0;
            while (i < parameters.getLength()) {
                try {
                    l.add(new CommissioningParameter((Element)parameters.item(i), file));
                }
                catch (ClassCastException classCastException) {
                }
                catch (Exception ex) {
                    Console.error("Failed to read a parameter from " + file + ": " + ex.getMessage() + ". Check content.", ex);
                    parametersOk = false;
                }
                ++i;
            }
            return parametersOk ? l : null;
        }
        catch (Exception e) {
            Console.error("Failed to read parameters from " + file, e);
            return null;
        }
    }

    protected String getToolName() {
        return "Commissioning";
    }

    protected String getAddress() {
        return this.myAddress;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class FListener
    implements FileActivationListener {
        private final CommissioningResults myCommResult;

        private FListener(CommissioningResults result) {
            this.myCommResult = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileActivationSucceeded(int resetCoverage, String operationFeedback) {
            if (resetCoverage != 91 && resetCoverage != 90) {
                CommissioningSingle.this.myWaitForReset = false;
                Console.info("Successfully activated " + CommissioningSingle.this.getAddress());
            } else {
                Console.info("Successfully started to activate " + CommissioningSingle.this.getAddress());
            }
            FListener fListener = this;
            synchronized (fListener) {
                CommissioningSingle.this.myActivationreceived = true;
                CommissioningSingle.this.myTimeouted = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileActivationFailed(int failReason, int resetCoverage, String operationFeedback) {
            Console.error("Failed to activate (" + CommissioningSingle.this.getDetails(operationFeedback) + ") " + CommissioningSingle.this.getAddress());
            if (resetCoverage != 91 && resetCoverage != 90) {
                CommissioningSingle.this.myWaitForReset = false;
            }
            FListener fListener = this;
            synchronized (fListener) {
                CommissioningSingle.this.myActivationreceived = true;
                this.myCommResult.setActivationOK(false);
                this.myCommResult.setFeedback("Activation failed");
                this.myCommResult.setExitCode(28);
                CommissioningSingle.this.myTimeouted = false;
                this.notify();
            }
        }
    }

    protected final class FileSendingListener
    implements SendFileToBTSListener {
        private final CommissioningResults myCommResult;

        protected FileSendingListener(CommissioningResults result) {
            this.myCommResult = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferFailed(int failReason, int resetCoverage, String operationFeedback) {
            String s = CommissioningSingle.this.getDetails(operationFeedback);
            if (s == null) {
                s = CommissioningSingle.this.getFailReasonText(failReason);
            }
            Console.error(String.valueOf(CommissioningSingle.this.getToolName()) + " failed (" + s + ") to " + CommissioningSingle.this.getAddress());
            FileSendingListener fileSendingListener = this;
            synchronized (fileSendingListener) {
                this.myCommResult.setCommissioningOK(false);
                this.myCommResult.setFeedback(s);
                this.myCommResult.setExitCode(27);
                CommissioningSingle.this.myTimeouted = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileTransferSucceeded(String fileName, int resetCoverage, String operationFeedback) {
            Console.info("Successfully commissioned " + CommissioningSingle.this.getAddress());
            this.myCommResult.setFeedback(operationFeedback);
            FileSendingListener fileSendingListener = this;
            synchronized (fileSendingListener) {
                CommissioningSingle.this.myTimeouted = false;
                this.notify();
            }
        }
    }
}

