/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FeedbackResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.configuration.Unit;
import com.nokia.em.bts.coreasset.message.DataChangeNotif;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltAdapter;
import com.nokia.em.bts.coreasset.scenario.antennamanagement.AntennaTiltListener;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigureTiltSingle
extends ToolBase {
    private static final String ARG_TILT_ANGLE = "tiltangle";
    private static final String NODE_ID = "_id";
    private static final String NODE_ANTENNA_TILTING_STATE = "AntennaTiltingState";
    private static final String NODEVALUE_STATE_IDLE = "idle";
    private static final String UNIT_TYPE_TILT = "tilt";
    private static final String ARG_CONFFILE = "configurationfile";
    private static final String ARG_IDS = "id";
    private String myAddress;
    private List<Integer> myTiltIds = null;
    private Byte[] myBytes = null;
    private List<Float> myMechanicalAngles = null;
    private ScenarioManagerImpl myScenarioManager;
    private boolean myTimeouted;
    private boolean myTiltOk;

    @Override
    protected void reset() {
        this.myTimeouted = false;
        this.myTiltOk = false;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        this.myAddress = btsInformation.getBTSAddress();
        String username = btsInformation.getUserName();
        String password = btsInformation.getPassword();
        Map<String, String> credentials = this.getCredentialsFrom(args);
        FeedbackResult result = new FeedbackResult(this.myAddress);
        try {
            this.myBytes = this.loadBytesFrom(args.getFirstValue(ARG_CONFFILE));
        }
        catch (Exception e) {
            Console.error("Invalid configuration file");
            result.setOK(false);
            result.setFeedback("Invalid configuration file");
            result.setExitCode(93);
            return result;
        }
        try {
            this.myMechanicalAngles = this.getMechanicalAnglesFrom(args.getFirstValue(ARG_TILT_ANGLE));
        }
        catch (NumberFormatException nfe) {
            Console.error("Invalid mechanical angle");
            result.setOK(false);
            result.setFeedback("Invalid mechanical angle");
            result.setExitCode(3);
            return result;
        }
        if (this.myBytes == null && this.myMechanicalAngles == null) {
            Console.error("Missing configuration file or mechanical angle");
            result.setOK(false);
            result.setFeedback("Missing configuration file or mechanical angle");
            result.setExitCode(3);
            return result;
        }
        if (this.myBytes != null && this.myMechanicalAngles != null) {
            Console.error("Cannot send both configuration file and mechanical angle");
            result.setOK(false);
            result.setFeedback("Cannot send both configuration file and mechanical angle");
            result.setExitCode(3);
            return result;
        }
        try {
            this.myTiltIds = this.getTiltIdsFrom(args.getFirstValue(ARG_IDS));
        }
        catch (NumberFormatException nfe) {
            Console.error("Invalid tilt id");
            result.setOK(false);
            result.setFeedback("Invalid tilt id");
            result.setExitCode(3);
            return result;
        }
        if (this.myMechanicalAngles != null && this.myTiltIds != null && this.myMechanicalAngles.size() != this.myTiltIds.size()) {
            Console.error("Mismatch between ids and mechanical angles");
            result.setOK(false);
            result.setFeedback("Mismatch between ids and mechanical angles");
            result.setExitCode(3);
            return result;
        }
        if (this.myTiltIds == null && this.myMechanicalAngles != null && this.myMechanicalAngles.size() > 1) {
            Console.error("More than one mechanical angle defined without ids");
            result.setOK(false);
            result.setFeedback("More than one mechanical angle defined without ids");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(this.myAddress, username, password, credentials);
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            BTSConnection connection = connectionInfo.getConnection();
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connection);
            }
            result.setOperationalState(this.getOperationalStateText(site));
            if (site == null) {
                Console.error("Failed to get HW data from " + this.myAddress);
                result.setOK(false);
                result.setFeedback("Failed to get HW data");
                result.setExitCode(96);
            } else {
                this.myScenarioManager = new ScenarioManagerImpl(connection);
                int total = 0;
                int success = 0;
                List units = site.getCabinet().getUnits();
                for (Unit unit : units) {
                    Boolean ok = this.configure(unit, connection);
                    if (ok == null) continue;
                    ++total;
                    if (!ok.booleanValue()) continue;
                    ++success;
                }
                if (total != success) {
                    result.setOK(false);
                    result.setFeedback(String.valueOf(success) + "/" + total + " configured");
                    result.setExitCode(94);
                } else if (total == 0) {
                    Console.error("No tilts found");
                    result.setOK(false);
                    result.setFeedback("No tilts found");
                    result.setExitCode(95);
                } else {
                    result.setFeedback(String.valueOf(success) + "/" + total + " configured");
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private List<Float> getMechanicalAnglesFrom(String angles) throws NumberFormatException {
        if (angles == null) {
            return null;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        StringTokenizer st = new StringTokenizer(angles, ",");
        while (st.hasMoreTokens()) {
            list.add(Float.valueOf(st.nextToken()));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean configure(Unit unit, BTSConnection connection) {
        if (!unit.getUnitType().equalsIgnoreCase(UNIT_TYPE_TILT)) {
            return null;
        }
        if (this.myTiltIds != null && !this.myTiltIds.contains(unit.getId())) {
            return null;
        }
        this.myTimeouted = true;
        this.myTiltOk = true;
        TiltStateListener tiltStateListener = new TiltStateListener(unit);
        connection.subscribeNotification((BTSNotificationListener)tiltStateListener);
        TiltListener tiltListener = new TiltListener(unit);
        Thread t = new Thread((AntennaTiltListener)tiltListener, unit){
            private final /* synthetic */ AntennaTiltListener val$tiltListener;
            private final /* synthetic */ Unit val$unit;
            {
                this.val$tiltListener = antennaTiltListener;
                this.val$unit = unit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this.val$tiltListener;
                synchronized (object) {
                    try {
                        ConfigureTiltSingle.this.myScenarioManager.getAntennaTiltConfigureScenario(this.val$tiltListener, this.val$unit.getId(), ConfigureTiltSingle.this.getMechanicalAngle(this.val$unit), ConfigureTiltSingle.this.myBytes).execute();
                        this.val$tiltListener.wait();
                    }
                    catch (Exception e) {
                        Console.error("Tilt " + this.val$unit.getId() + " configure not started in " + ConfigureTiltSingle.this.myAddress, e);
                        ConfigureTiltSingle.this.myTiltOk = false;
                    }
                }
                if (ConfigureTiltSingle.this.myTiltOk) {
                    ConfigureTiltSingle.this.myTimeouted = true;
                    object = this.val$unit;
                    synchronized (object) {
                        try {
                            this.val$unit.wait(60000 + ConfigureTiltSingle.this.myTimeout);
                            if (ConfigureTiltSingle.this.myTimeouted) {
                                Console.error("Tilt " + this.val$unit.getId() + " configure timeout in " + ConfigureTiltSingle.this.myAddress);
                                ConfigureTiltSingle.this.myTiltOk = false;
                            } else {
                                Console.info("Tilt " + this.val$unit.getId() + " configure finished in " + ConfigureTiltSingle.this.myAddress);
                            }
                        }
                        catch (InterruptedException e) {
                            Console.error("Tilt " + this.val$unit.getId() + " configure failed in " + ConfigureTiltSingle.this.myAddress, e);
                            ConfigureTiltSingle.this.myTiltOk = false;
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.notify();
                }
            }
        };
        t.start();
        Thread thread = t;
        synchronized (thread) {
            try {
                t.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        connection.unsubscribeNotification((BTSNotificationListener)tiltStateListener);
        return this.myTiltOk;
    }

    private Float getMechanicalAngle(Unit unit) {
        if (this.myMechanicalAngles == null) {
            return null;
        }
        if (this.myTiltIds != null) {
            int i = 0;
            while (i < this.myTiltIds.size()) {
                if (unit.getId() == this.myTiltIds.get(i).intValue()) {
                    return this.myMechanicalAngles.get(i);
                }
                ++i;
            }
        }
        return this.myMechanicalAngles.get(0);
    }

    private List<Integer> getTiltIdsFrom(String ids) throws NumberFormatException {
        if (ids == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(ids, ",");
        while (st.hasMoreTokens()) {
            list.add(Integer.valueOf(st.nextToken()));
        }
        return list;
    }

    private Byte[] loadBytesFrom(String filename) throws Exception {
        Byte[] devData = null;
        if (filename != null) {
            File file = new File(filename);
            int length = (int)file.length();
            byte[] data = new byte[length];
            FileInputStream fis = new FileInputStream(file);
            fis.read(data);
            fis.close();
            devData = new Byte[length];
            int i = 0;
            while (i < length) {
                devData[i] = data[i];
                ++i;
            }
        }
        return devData;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }

    private final class TiltListener
    extends AntennaTiltAdapter {
        private final Unit myUnit;

        private TiltListener(Unit unit) {
            this.myUnit = unit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configuringAccepted() {
            Console.info("Tilt " + this.myUnit.getId() + " configure started in " + ConfigureTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                ConfigureTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configuringFailed(int reason) {
            Console.error("Tilt " + this.myUnit.getId() + " configure not started in " + ConfigureTiltSingle.this.myAddress);
            TiltListener tiltListener = this;
            synchronized (tiltListener) {
                ConfigureTiltSingle.this.myTiltOk = false;
                ConfigureTiltSingle.this.myTimeouted = false;
                ((Object)((Object)this)).notify();
            }
        }
    }

    private final class TiltStateListener
    implements BTSNotificationListener {
        private final Unit myUnit;

        private TiltStateListener(Unit unit) {
            this.myUnit = unit;
        }

        public void btsNotificationReceived(BTSMessage message) {
            DataChangeNotif notif;
            if (message instanceof DataChangeNotif && (notif = (DataChangeNotif)message).getConfigObjectType() == 10) {
                this.checkTiltStateFrom(notif);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTiltStateFrom(DataChangeNotif notif) {
            NodeList list = notif.getConfigObjectData();
            boolean idOK = false;
            boolean stateOK = false;
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.hasChildNodes()) {
                    String name = node.getNodeName();
                    String value = node.getFirstChild().getNodeValue();
                    if (ConfigureTiltSingle.NODE_ID.equalsIgnoreCase(name) && value.equalsIgnoreCase(String.valueOf(this.myUnit.getId()))) {
                        idOK = true;
                    } else if (ConfigureTiltSingle.NODE_ANTENNA_TILTING_STATE.equalsIgnoreCase(name) && ConfigureTiltSingle.NODEVALUE_STATE_IDLE.equalsIgnoreCase(value)) {
                        stateOK = true;
                    }
                }
                ++i;
            }
            if (idOK && stateOK) {
                Unit unit = this.myUnit;
                synchronized (unit) {
                    ConfigureTiltSingle.this.myTimeouted = false;
                    this.myUnit.notify();
                }
            }
        }
    }
}

