/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.ConsoleResults;
import com.nokia.em.bts.coreasset.application.tools.ConsoleSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConsoleImpl
extends ToolImpl {
    private static final String COLUMN_COMMAND = "Command";
    private static final String COLUMN_RESULT = "Result";
    private List<ConsoleResults> myResults = new ArrayList<ConsoleResults>();

    public ConsoleImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        this.myMaxConcurrentSites = 1;
        return "Console";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "Console";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((ConsoleResults)result);
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    @Override
    public String getShortResult() {
        return "";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new ConsoleSingle();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn(COLUMN_COMMAND);
        table.addColumn(COLUMN_RESULT);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (ConsoleResults br : this.myResults) {
            this.generateRow(table, br);
        }
    }

    private void generateRow(ToolSummaryTable table, ConsoleResults results) {
        for (Map.Entry<String, String> entry : results.getCommands().entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(entry.getKey());
            values.add(entry.getValue());
            table.addRow(values);
        }
    }
}

