/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.ConsoleResults;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.RemoteSingle;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.JSONRPCObject;
import com.nokia.em.bts.coreasset.application.util.LogWriter;
import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.fusesource.jansi.AnsiConsole;

public class ConsoleSingle
extends ToolBase {
    private static final String ARG_CONNECT = "connect";
    private boolean myConsoleRunning = true;

    @Override
    protected void reset() {
        this.myConsoleRunning = true;
    }

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        this.parseCommonParamsFrom(args);
        ConsoleResults result = new ConsoleResults();
        RemoteSingle remote = new RemoteSingle();
        boolean firstTime = args.isDefined(ARG_CONNECT) && args.isDefined("ne") && args.isDefined("pw");
        do {
            String consolePrefix = String.valueOf(LogWriter.DATE_FORMAT.format(new Date())) + "\u001b[0;36m" + "  USER " + "\u001b[0;37m";
            String filePrefix = String.valueOf(LogWriter.DATE_FORMAT.format(new Date())) + "  USER ";
            AnsiConsole.out.print(consolePrefix);
            String command = "";
            if (firstTime) {
                command = "connect -ne " + args.getFirstValue("ne") + " -" + "pw" + " " + args.getFirstValue("pw");
                AnsiConsole.out.println(command);
                firstTime = false;
            } else {
                String readFromConsole = System.console().readLine();
                if (readFromConsole != null) {
                    command = readFromConsole.trim();
                }
            }
            if (command.length() <= 0) continue;
            ((LogWriter)PoseidonRuntime.getRuntime().getObject(LogWriter.class)).writeToFile(String.valueOf(filePrefix) + command);
            if ("quit".equalsIgnoreCase(command) || "exit".equalsIgnoreCase(command)) {
                this.myConsoleRunning = false;
                JSONRPCObject quit = new JSONRPCObject();
                quit.setMethod(command);
                quit.setId(1);
                remote.processJSON(quit.toString());
                result.add(command, "OK");
                continue;
            }
            JSONRPCObject response = new JSONRPCObject(remote.processJSON(this.getJSON(command)));
            if (response.isOk()) {
                Object resObj = response.getResult();
                if (resObj == null || resObj.toString().length() <= 0) continue;
                result.add(command, resObj.toString());
                continue;
            }
            result.add(command, response.getError().getMessage());
        } while (this.myConsoleRunning);
        return result;
    }

    private String getJSON(String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        JSONRPCObject request = new JSONRPCObject();
        if (st.hasMoreTokens()) {
            request.setMethod(st.nextToken());
            request.setId(1);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String param = null;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("-")) {
                    if (param != null) {
                        map.put(param, "");
                    }
                    param = s.substring(1);
                    continue;
                }
                if (param == null) continue;
                map.put(param, s);
                param = null;
            }
            if (param != null) {
                map.put(param, "");
            }
            if (map.size() == 0 && command.indexOf(" ") > 0) {
                map.put("message", command.substring(command.indexOf(" ") + 1));
            }
            request.setNamedParameters(map);
        }
        return request.toString();
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

