/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.EthernetSecurityResults;
import com.nokia.em.bts.coreasset.application.tools.EthernetSecuritySingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class EthernetSecurityImpl
extends ToolImpl {
    private static final String COLUMN_CHANGED = "Changed";
    private List<EthernetSecurityResults> myResults = new ArrayList<EthernetSecurityResults>();

    public EthernetSecurityImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Ethernet Security";
    }

    @Override
    public String getVersion() {
        return "3.0";
    }

    @Override
    public String getFilePrefix() {
        return "EthernetSecurity";
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((EthernetSecurityResults)result);
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new EthernetSecuritySingle();
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.getResultText(this.myResults.get(0));
        }
        return "No results";
    }

    private String getResultText(EthernetSecurityResults result) {
        return result.isOK() ? "OK" : result.getFailureText();
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        table.addColumn(COLUMN_CHANGED);
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (EthernetSecurityResults results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, EthernetSecurityResults results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, EthernetSecurityResults results) {
        values.add(results.getOperationalState());
        values.add(this.getResultText(results));
    }
}

