/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.EthernetSecurityResults;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.coreasset.scenario.ScenarioManagerImpl;
import com.nokia.em.bts.coreasset.scenario.hwmanagement.EthernetSecurityStatusListener;
import com.nokia.em.poseidon.util.PCmdLineParams;

public class EthernetSecuritySingle
extends ToolBase {
    private static final String ARG_ENABLE = "enable";
    private static final String ARG_DISABLE = "disable";
    private boolean myTimeouted = true;

    @Override
    protected void reset() {
        this.myTimeouted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        final EthernetSecurityResults result = new EthernetSecurityResults();
        final String address = btsInformation.getBTSAddress();
        boolean enable = true;
        if (args.isDefined(ARG_DISABLE)) {
            enable = false;
        } else if (!args.isDefined(ARG_ENABLE)) {
            Console.error("No operation, ethernet security status change failed to " + address);
            result.setOK(false);
            result.setFailureText("No operation");
            result.setExitCode(3);
            return result;
        }
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(address, btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(connectionInfo.getAddress());
            ScenarioManagerImpl scenarioManager = new ScenarioManagerImpl(connectionInfo.getConnection());
            String masterId = String.valueOf(site.getOMMaster());
            if (masterId == null) {
                Console.error("Failed to get master id, ethernet security status change failed to " + address);
                result.setOK(false);
                result.setFailureText("No master");
                result.setExitCode(77);
            } else {
                EthernetSecurityStatusListener listener;
                EthernetSecurityStatusListener ethernetSecurityStatusListener = listener = new EthernetSecurityStatusListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void statusChanged() {
                        Console.info("Successfully changed ethernet security status to " + address);
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            EthernetSecuritySingle.this.myTimeouted = false;
                            this.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void statusChangeFailed(int reason) {
                        String failReasonText = EthernetSecuritySingle.this.getFailReasonText(reason);
                        Console.error("Ethernet security status change failed (" + failReasonText + ") to " + address);
                        1 var3_3 = this;
                        synchronized (var3_3) {
                            result.setOK(false);
                            result.setFailureText(failReasonText);
                            result.setExitCode(76);
                            EthernetSecuritySingle.this.myTimeouted = false;
                            this.notify();
                        }
                    }
                };
                synchronized (ethernetSecurityStatusListener) {
                    try {
                        scenarioManager.getChangeEthernetSecurityStatusScenario(listener, enable, masterId).execute();
                        listener.wait(this.myTimeout);
                        if (this.myTimeouted) {
                            Console.error("Ethernet security change timeout with " + address);
                            result.setOK(false);
                            result.setFailureText("Timeout");
                            result.setExitCode(8);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    @Override
    protected String getDefaultConnectionType() {
        return "write";
    }
}

