/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.FileFetchingResults;
import com.nokia.em.bts.coreasset.application.tools.FilesFetcher;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.TextFormattingUtils;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileCollectorImpl
extends ToolImpl {
    private List<FileFetchingResults> myResults = new ArrayList<FileFetchingResults>();

    public FileCollectorImpl(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "File Collector";
    }

    @Override
    public String getVersion() {
        return "8.19";
    }

    @Override
    public String getFilePrefix() {
        return "FileCollector";
    }

    @Override
    public String getResults() {
        ToolSummaryTable table = new ToolSummaryTable();
        this.generateColumnsTo(table);
        this.generateRowsTo(table);
        return table.toString();
    }

    private void generateColumnsTo(ToolSummaryTable table) {
        table.addColumn("Site");
        table.addColumn("Site Status");
        this.generateToolColumnsTo(table);
    }

    private void generateToolColumnsTo(ToolSummaryTable table) {
        for (FileFetchingResults result : this.myResults) {
            this.generateToolColumns(table, result.getFiles());
        }
    }

    private void generateToolColumns(ToolSummaryTable table, Map<String, Boolean> files) {
        for (Map.Entry<String, Boolean> entry : files.entrySet()) {
            String tool = entry.getKey();
            if (table.hasColumn(tool)) continue;
            table.addColumn(tool);
        }
    }

    private void generateRowsTo(ToolSummaryTable table) {
        for (FileFetchingResults results : this.myResults) {
            this.generateRow(table, results);
        }
    }

    private void generateRow(ToolSummaryTable table, FileFetchingResults results) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(results.getAddress());
        if (results.isConnected()) {
            this.insertToolResults(values, results);
        } else if (!results.isLoggedIn()) {
            values.add("Login failed");
        } else if (results.isReserved()) {
            values.add("Reserved");
        } else {
            values.add("Unreachable");
        }
        table.addRow(values);
    }

    private void insertToolResults(List<String> values, FileFetchingResults results) {
        values.add(results.getOperationalState());
        for (Map.Entry<String, Boolean> entry : results.getFiles().entrySet()) {
            values.add(entry.getValue() != false ? "OK" : "Not OK");
        }
    }

    @Override
    public String getShortResult() {
        int successCount = 0;
        int totalCount = 0;
        if (this.myResults.size() > 0) {
            for (Map.Entry<String, Boolean> entry : this.myResults.get(0).getFiles().entrySet()) {
                ++totalCount;
                if (!entry.getValue().booleanValue()) continue;
                ++successCount;
            }
        }
        return String.valueOf(successCount) + "/" + totalCount + TextFormattingUtils.getPlural(" file", successCount) + " fetched";
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new FilesFetcher();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add((FileFetchingResults)result);
    }
}

