/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.GPSStatusResult;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.util.BTSInformation;
import com.nokia.em.bts.coreasset.application.util.ConnectionInformation;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.configuration.Site;
import com.nokia.em.bts.rp.master.alarm.Alarm;
import com.nokia.em.bts.rp.master.connection.BTSConnection;
import com.nokia.em.bts.rp.master.connection.BTSNotificationListener;
import com.nokia.em.bts.rp.master.message.AlarmObservation;
import com.nokia.em.bts.rp.master.message.AlarmStatusReply;
import com.nokia.em.bts.rp.master.message.AlarmStatusRequest;
import com.nokia.em.bts.rp.master.message.BTSMessage;
import com.nokia.em.bts.rp.master.message.Timeout;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.List;

public class GPSStatusChecker
extends ToolBase {
    private BTSConnection myConnection;
    private List<Alarm> myAlarmList;

    @Override
    public OperationResult run(ConnectionInformation c, BTSInformation btsInformation, PCmdLineParams args) {
        ConnectionInformation connectionInfo = c;
        this.parseCommonParamsFrom(args);
        GPSStatusResult result = new GPSStatusResult();
        this.myAlarmList = new ArrayList<Alarm>();
        boolean disconnect = false;
        if (connectionInfo == null) {
            connectionInfo = this.connect(btsInformation.getBTSAddress(), btsInformation.getUserName(), btsInformation.getPassword(), this.getCredentialsFrom(args));
            disconnect = true;
        }
        if (connectionInfo.isConnected()) {
            Site site = connectionInfo.getSite();
            if (site == null) {
                site = this.buildHWModel(connectionInfo.getConnection());
            }
            result.setSite(site);
            result.setProduct(connectionInfo.getProduct());
            result.setOperationalState(this.getOperationalStateText(site));
            result.setAddress(connectionInfo.getAddress());
            this.myConnection = connectionInfo.getConnection();
            this.fetchAlarms();
            result.setAlarmList(this.myAlarmList);
            this.disconnect(connectionInfo, disconnect);
        } else {
            this.createUnconnectedResult(result, connectionInfo);
        }
        return result;
    }

    private void fetchAlarms() {
        int alarmSeqNum = 0;
        AlarmListener notifListener = new AlarmListener();
        this.myConnection.subscribeNotification((BTSNotificationListener)notifListener);
        alarmSeqNum = this.myConnection.createScenario();
        this.myConnection.sendToBTS((BTSMessage)new AlarmStatusRequest(alarmSeqNum));
        this.collectAlarmInformation(alarmSeqNum, notifListener);
    }

    private void collectAlarmInformation(int alarmSeqNum, BTSNotificationListener notifListener) {
        BTSMessage msg = this.myConnection.receiveFromBTS(alarmSeqNum, 15000L);
        while (!(msg instanceof AlarmStatusReply) && !(msg instanceof Timeout) && msg != null) {
            msg = this.myConnection.receiveFromBTS(alarmSeqNum, 15000L);
        }
        this.myConnection.unsubscribeNotification(notifListener);
    }

    @Override
    protected String getDefaultConnectionType() {
        return "read-only";
    }

    private final class AlarmListener
    implements BTSNotificationListener {
        private AlarmListener() {
        }

        public void btsNotificationReceived(BTSMessage btsMessage) {
            if (btsMessage instanceof AlarmObservation) {
                Alarm alarm = new Alarm((AlarmObservation)btsMessage);
                if (!GPSStatusChecker.this.myAlarmList.contains(alarm)) {
                    GPSStatusChecker.this.myAlarmList.add(alarm);
                }
                if (GPSStatusChecker.this.myVerbose) {
                    Console.debug("Received alarm " + alarm.getAlarmDetail());
                }
            }
        }
    }
}

