/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.bts.coreasset.application.tools;

import com.nokia.em.bts.coreasset.application.tools.GetRawAlarmsSingle;
import com.nokia.em.bts.coreasset.application.tools.OperationResult;
import com.nokia.em.bts.coreasset.application.tools.ToolBase;
import com.nokia.em.bts.coreasset.application.tools.ToolImpl;
import com.nokia.em.bts.coreasset.application.util.Console;
import com.nokia.em.bts.coreasset.application.util.ToolSummaryTable;
import java.util.ArrayList;
import java.util.List;

public class GetAlarmHistory
extends ToolImpl {
    private static final String STATUS_FAILED = "Failed";
    private static final String STATUS_SUCCESSFUL = "Successful";
    private static final String COLUMN_RAW_ALARMS_STATUS = "Alarm History";
    private List<OperationResult> myResults = new ArrayList<OperationResult>();

    public GetAlarmHistory(String outdir) {
        super(outdir);
    }

    @Override
    public String getName() {
        return "Get Alarm History";
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    @Override
    public String getFilePrefix() {
        return "GetAlarmHistory";
    }

    @Override
    public String getResults() {
        ToolSummaryTable t = new ToolSummaryTable();
        t.addColumn("Site");
        t.addColumn("Site Status");
        t.addColumn(COLUMN_RAW_ALARMS_STATUS);
        for (OperationResult r : this.myResults) {
            t.addRow(r.getAddress(), this.getStatusText(r), this.getAlarmHistoryResult(r));
        }
        return t.toString();
    }

    @Override
    public String getShortResult() {
        if (this.myResults.size() > 0) {
            return this.getAlarmHistoryResult(this.myResults.get(0));
        }
        return "No results";
    }

    private String getAlarmHistoryResult(OperationResult result) {
        return result.isOK() ? STATUS_SUCCESSFUL : STATUS_FAILED;
    }

    @Override
    protected ToolBase getNewSingleTool() {
        return new GetRawAlarmsSingle();
    }

    @Override
    protected void updateResults(OperationResult result) {
        this.myResults.add(result);
        if (result.isOK()) {
            Console.info("Successfully got alarm history from " + result.getAddress());
        } else {
            Console.error("Failed to get alarm history from " + result.getAddress());
        }
    }
}

